<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
* Compile time component for block tags
* @tag wact:block
* @attributes hide
*/
class Wact_Template_Tag_wact_block extends Wact_Template_Compiler_Node_View {

    /**
    * The view class corresponding to this template node.
    * @var string
    */
    public $parentViewClass = 'Wact_View_Block';

    /**
    * @param Wact_Php_Writer $code
    * @return void
    */
    public function generateConstruct($code) {
        if ($this->getBoolAttributeValue('hide')) {
            $code->writePHP('$this->visible = false;');
        }
    }

}
?>