<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
* Compile time component for block tags
* @tag textarea
* @location LOCATION_CLIENT
* @known_parent Wact_Template_Tag_form
* @end_tag ENDTAG_REQUIRED
*/
class Wact_Template_Tag_textarea extends Wact_Template_Compiler_Node_TagView {

    // We should probably prevent this tag from having any children

    /**
    * The view class corresponding to this template node.
    * @var string
    */
    public $parentViewClass = 'Wact_View_Form_TextArea';

    /**
    */
    function addChild($child) {
        // discard children
    }

    /**
    * Generate the code to initialize the view based on this tag.
    * @param Wact_Php_Writer $code
    */
    function generateConstructParameters($code) {
        // This code is duplicated from parent.  Maybe figure out way to extract?
    
        // Determine which attributes should not propigate to the view
        $viewAttributes = $this->tagInfo->compilerAttributes;

        // Gobally filtered attributes
        $viewAttributes[] = Wact_Template_Compiler_Attribute::WACT_ID;

        $code->writePHP(var_export($this->getAttributesAsArray($viewAttributes), TRUE));
    }

}
?>