<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
* Compile time component for building runtime select components
* @tag select
* @known_parent Wact_Template_Tag_form
* @attributes errorclass errorstyle displayname
* @location LOCATION_CLIENT
*/
class Wact_Template_Tag_select extends Wact_Template_Compiler_Node_TagView {

    /**
    * @return void
    */
    function prepare() {
        if ($this->getBoolAttributeValue('multiple')) {
            $this->parentViewClass = 'Wact_View_Form_Select_Multiple';

            // Repetition of ControlTag::prepare but required for special case
            // of SelectMultiple to provide meaningful error messages
            if (!$this->getBoolAttributeValue('name')) {
                if ($this->getBoolAttributeValue('id')) {
                    // Note - appends [] to id value
                    $this->setAttributeValue('name', $this->getAttributeValue('id') . '[]');
                } else {
                    die('NAMEREQUIRED');
                }
            }

            if (!is_integer(strpos($this->getAttributeValue('name'), '[]'))) {
                die('CONTROLARRAYREQUIRED');/*,
                     array('name' => $this->getAttributeValue('name')));*/
            }
        } else {
            $this->parentViewClass = 'Wact_View_Form_Select_One';
        }

        parent::prepare();
    }

    /**
    * Ignore the compiler time contents and generate the contents at run time.
    * @return void
    */
    // Ignore the compiler time contents and generate the contents at run time.
    function generateContents($code) {
        //$code->writePHP('$this->renderContents();');
    }
}
?>
