<?php

class WactGenericsTestCase extends Wact_Test_Case {

    function setUp() {
        $this->reader = new Wact_Template_Reader_Transient();
        $this->cache = new Wact_Cache_Store_Transient();
        $this->loader = new Wact_Template_Loader($this->reader, $this->cache);
    }

    function testBrTag() {
        $source = '<br id="runtime" wact:id="*">';

        $this->reader->writeSource('/tags/generictag7.tpl.html', $source);
        $tmpl = $this->loader->load('/tags/generictag7.tpl.html');

        $view = $tmpl->findChild('runtime');

        $this->assertTrue($view instanceof Wact_View_Tag);
    }

    function testHrTag() {
        $source = '<hr id="runtime" wact:id="*">';

        $this->reader->writeSource('/tags/generictag8.tpl.html', $source);
        $tmpl = $this->loader->load('/tags/generictag8.tpl.html');

        $view = $tmpl->findChild('runtime');

        $this->assertTrue($view instanceof Wact_View_Tag);
    }

    function testImgTag() {
        $source = '<img id="runtime" wact:id="*">';

        $this->reader->writeSource('/tags/generictag9.tpl.html', $source);
        $tmpl = $this->loader->load('/tags/generictag9.tpl.html');

        $view = $tmpl->findChild('runtime');

        $this->assertTrue($view instanceof Wact_View_Tag);
    }

    function testLinkTag() {
        $source = '<link id="runtime" wact:id="*">';

        $this->reader->writeSource('/tags/generictag10.tpl.html', $source);
        $tmpl = $this->loader->load('/tags/generictag10.tpl.html');

        $view = $tmpl->findChild('runtime');

        $this->assertTrue($view instanceof Wact_View_Tag);
    }

    function testPTag() {
        $source = '<p id="runtime" wact:id="*"></p>';

        $this->reader->writeSource('/tags/generictag11.tpl.html', $source);
        $tmpl = $this->loader->load('/tags/generictag11.tpl.html');

        $view = $tmpl->findChild('runtime');
    }

    function testParamTag() {
        $source = '<param id="runtime" wact:id="*">';

        $this->reader->writeSource('/tags/generictag12.tpl.html', $source);
        $tmpl = $this->loader->load('/tags/generictag12.tpl.html');

        $view = $tmpl->findChild('runtime');

        $this->assertTrue($view instanceof Wact_View_Tag);
    }
}

?>