<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
* @formatter parity
* @max_attributes 0
* @min_attributes 0
*/
class Wact_Template_Formatter_parity extends Wact_Template_Compiler_Formatter {

    protected $varRef;
    
    /**
    * Does this property refer to a constant value at compile time?
    * @return Boolean
    */
    function isConstant() {
        return FALSE;
    }

    /**
    * Generate setup code for an expression reference
    * @param CodeWriter
    * @return void
    */
    function generatePreStatement($code) {
        $this->varRef = '$this->' . $code->createTempProperty('even');
        $code->writePHP('if (' . $this->varRef . ' == "odd") { ');
        $code->writePHP($this->varRef . ' = "even"; ');
        $code->writePHP('} else { ');
        $code->writePHP($this->varRef . ' = "odd"; ');
        $code->writePHP('}');
    }

    /**
    * Generate the code to read the data value at run time
    * Must generate only a valid PHP Expression.
    * @param CodeWriter
    * @return void
    */
    function generateExpression($code) {
        $code->writePHP($this->varRef);
    }

}

?>