<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
* @formatter if
* @min_attributes 3
* @max_attributes 3
*/
class Wact_Template_Formatter_if extends Wact_Template_Compiler_Formatter {

    /**
    * Return this value as a PHP value
    * @return String
    */
    function getValue() {
        if ($this->isConstant()) {
            if ($this->parameters[0]->getValue()) {
                return $this->parameters[1]->getValue();
            } else {
                return $this->parameters[2]->getValue();
            }
        } else {
            parent::getValue();
        }
    }

    /**
    * Generate the code to read the data value at run time
    * Must generate only a valid PHP Expression.
    * @param CodeWriter
    * @return void
    */
    function generateExpression($code) {
        $code->writePHP('((');
        $this->parameters[0]->generateExpression($code);
        $code->writePHP(')?(');
        $this->parameters[1]->generateExpression($code);
        $code->writePHP('):(');
        $this->parameters[2]->generateExpression($code);
        $code->writePHP('))');
    }

}

?>