<?php

class Wact_Template_Formatter_default_TestCase extends Wact_Test_Case_Template {

    protected $tmpl;
    
    function setUp() {
        parent::setUp();
        $this->tmpl = $this->createTempTemplate('{$Var|default:"default"}');
    }
    
    function testDefaultUnset() {
        $this->expectError();
        $output = $this->tmpl->capture();
        $this->assertEqual($output, 'default');        
    }

    function testDefaultString() {
        $this->tmpl->setModel(array('Var' => 'test'));
        $output = $this->tmpl->capture();
        $this->assertEqual($output, 'test');        
    }

    function testDefaultZeroString() {
        $this->tmpl->setModel(array('Var' => '0'));
        $output = $this->tmpl->capture();
        $this->assertEqual($output, '0');        
    }

    function testDefaultEmptyString() {
        $this->tmpl->setModel(array('Var' => ''));
        $output = $this->tmpl->capture();
        $this->assertEqual($output, 'default');        
    }

    function testDefaultNumber() {
        $this->tmpl->setModel(array('Var' => 99));
        $output = $this->tmpl->capture();
        $this->assertEqual($output, '99');        
    }

    function testDefaultZero() {
        $this->tmpl->setModel(array('Var' => 0));
        $output = $this->tmpl->capture();
        $this->assertEqual($output, '0');        
    }

    function testDefaultNull() {
        $this->tmpl->setModel(array('Var' => NULL));
        $output = $this->tmpl->capture();
        $this->assertEqual($output, 'default');        
    }

    function testDefaultTrue() {
        $this->tmpl->setModel(array('Var' => TRUE));
        $output = $this->tmpl->capture();
        $this->assertEqual($output, '1');        
    }

    function testDefaultFalse() {
        $this->tmpl->setModel(array('Var' => FALSE));
        $output = $this->tmpl->capture();
        $this->assertEqual($output, 'default');        
    }

}
?>