<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
* @formatter default
* @min_attributes 2
* @max_attributes 2
*/
class Wact_Template_Formatter_default extends Wact_Template_Compiler_Formatter {

    /**
    * Return this value as a PHP value
    * @return String
    */
    function getValue() {
        if ($this->isConstant()) {
            $value = $this->parameters[0]->getValue();
            if (!$value && $value !== "0" && $value !== 0) {
                return $this->parameters[1]->getValue();
            } else {
                return $value;
            }
        } else {
            parent::getValue();
        }
    }

    /**
    * Generate the code to read the data value at run time
    * Must generate only a valid PHP Expression.
    * @param CodeWriter
    * @return void
    */
    function generateExpression($code) {
        $varRef = '$' . $code->createTempVariable();

        $code->writePHP('(!(' . $varRef . ' = ');
        $this->parameters[0]->generateExpression($code);
        $code->writePHP(')  && ' . $varRef . ' !== "0" && ' . $varRef . ' !== 0) ? (');
        $this->parameters[1]->generateExpression($code);
        $code->writePHP(') : (' . $varRef . ')');
    }

}

?>