<?php


class WactTransientSourceReaderTestCase extends Wact_Test_Case {

    protected $reader;

    function setUp() {
        $this->reader = new Wact_Template_Reader_Transient();
        $this->reader->writeSource('test', 'test data');
        $this->reader->writeSource('path/test', 'path test data');
    }

    function tearDown() {
    }

    function testGetSourceReader() {
        $this->assertEqual($this->reader->readSource('test'), 'test data');
    }

    function testGetSourceReaderWithPath() {
        $this->assertEqual($this->reader->readSource('path/test'), 'path test data');
    }

    function testGetSourceReaderDoesNotExist() {
        $this->assertNull($this->reader->readSource('does_not_exist'));
    }

}

?>
