<?php

class WactFileSourceReaderTester extends Wact_Template_Reader_File {

    public function getSourceFilePath($resourceId) {
        return parent::getSourceFilePath($resourceId);
    }

}

class WactFileSourceReaderTestCase extends Wact_Test_Case {

    protected $reader;
    protected $prefix;

    function setUp() {
        $this->prefix = uniqid();
    
        $this->reader = new WactFileSourceReaderTester('/tmp', $this->prefix, '');
        mkdir('/tmp/' . $this->prefix);
        file_put_contents('/tmp/' . $this->prefix . '/test', 'test data');
        mkdir('/tmp/' . $this->prefix . '/path');
        file_put_contents('/tmp/' . $this->prefix . '/path/test', 'path test data');
    }

    function tearDown() {
        unlink('/tmp/' . $this->prefix . '/test');
        unlink('/tmp/' . $this->prefix . '/path/test');
        rmdir('/tmp/' . $this->prefix . '/path');
        rmdir('/tmp/' . $this->prefix);
    }

    function testGetSourceFilePath() {
        $this->assertEqual($this->reader->getSourceFilePath('test'), 
            array('/tmp/' . $this->prefix . '/test'));
    }

    function testGetSourceReader() {
        $this->assertEqual($this->reader->readSource('test'), 'test data');
    }

    function testGetSourceReaderWithPath() {
        $this->assertEqual($this->reader->readSource('path/test'), 'path test data');
    }

    function testGetSourceReaderDoesNotExist() {
        $this->assertNull($this->reader->readSource('does_not_exist'));
    }

}

?>
