<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
* File level includes
*/

/**
* Manage a set of compilable resources.
*/
class Wact_Template_Reader_File {

    protected $path;

    public function __construct($searchPath = NULL, $sourcePrefix = '') {

        if ($searchPath == NULL) {
            $searchPath = get_include_path();
        }

        $pathArray = explode(PATH_SEPARATOR, $searchPath);

        foreach( $pathArray as $dir) {
            $this->path[] = $dir . '/' . $sourcePrefix;
        }

    }

    /**
    * Deterimine a list of possible file locations for a given resource.
    */
    protected function getSourceFilePath($resourceId) {
        $path = array();

        foreach($this->path as $dir) {
            $path[] = $dir . '/' . $resourceId;
        }
        return $path;
    }

    /**
    * @see WactSourceReader.readSource
    */
    public function readSource($resourceId) {
        $path = $this->getSourceFilePath($resourceId);
        foreach($path as $file) {
            if (file_exists($file) && is_readable($file)) {
                if ($data = @file_get_contents($file)) {
                    return $data;
                } else {
                    return NULL; // Not found
                }
            }
        }
        return NULL;
    }
    
}

?>