<?php

class WactTemplateLoaderTestCase extends Wact_Test_Case {

    protected $loader;

    function setUp() {
        $cache = new Wact_Cache_Store_Transient();
        $reader = new Wact_Template_Reader_Transient();
        $reader->writeSource('test', 'test=value');
        $this->loader = new Wact_Template_Loader($reader, $cache);
    }

    function tearDown() {
    }

    function testLoad() {
        $resource = $this->loader->load('test');
    }

    function testLoadDoesNotExists() {
        try {
            $resource = $this->loader->load('not_found');
            $this->fail('Expected exception not thrown');
        } catch (Wact_Template_Exception_Notfound $e) {
            $this->pass();
            $this->assertEqual($e->getResourceId(), 'not_found');
        }
    }
   
}

?>
