<?php

class Nesting_TestCase extends Wact_Test_Case_Template {

    function testPlainNesting() {
        $template = '<div extra="1">x<div extra="2">y</div>z</div>';
        $tmpl = $this->createTempTemplate($template); 

        $output = $tmpl->capture();
        $this->assertEqual($output, $template);
    }

    function testGenericWithPlainNested() {
        $template = '<div wact:id="test" extra="1">x<div extra="2">y</div>z</div>';
        $tmpl = $this->createTempTemplate($template); 

        $output = $tmpl->capture();
        $this->assertEqual($output, '<div extra="1">x<div extra="2">y</div>z</div>');
    }

    function testGenericWithTwoPlainNested() {
        $template = '<div wact:id="test" extra="1">v<div extra="2">w</div>x<div extra="3">y</div>z</div>';
        $tmpl = $this->createTempTemplate($template);

        $output = $tmpl->capture();
        $this->assertEqual($output, '<div extra="1">v<div extra="2">w</div>x<div extra="3">y</div>z</div>');
    }

    function testPlainWithGenericNested() {
        $template = '<div extra="1">x<div wact:id="test" extra="2">y</div>z</div>';
        $tmpl = $this->createTempTemplate($template); 

        $output = $tmpl->capture();
        $this->assertEqual($output, '<div extra="1">x<div extra="2">y</div>z</div>');
    }

    function testPlainWithTwoGenericNested() {
        $template = '<div extra="1">v<div wact:id="test1" extra="2">w</div>x<div wact:id="test2" extra="3">y</div>z</div>';
        $tmpl = $this->createTempTemplate($template); 

        $output = $tmpl->capture();
        $this->assertEqual($output,  '<div extra="1">v<div extra="2">w</div>x<div extra="3">y</div>z</div>');
    }

}
?>