<?php

/**
* These tests are all malformed HTML.  They test the ability of the parser to
* handle garbage input.
*/
class BadHtml_TestCase extends Wact_Test_Case_Template {

    function testWactEndTagRequired() {
        $this->expectException();
        $tmpl = $this->createTempTemplate('<wact:block Variable="Value">');  // ENDTAG_REQUIRED
    }

    function testWactSelfCloseRequired() {
        $tmpl = $this->createTempTemplate('<wact:block Variable="Value" />');  // ENDTAG_REQUIRED
    }

    function testExtraClose() {
        $this->expectException();
        $tmpl = $this->createTempTemplate('<input type="text"></input>');  // ENTAG_FORBIDDEN
    }

    function testWactLonelyClose() {
        $tmpl = $this->createTempTemplate('</wact:block>');  // ENTAG_FORBIDDEN
    }

    function testWactLonelyCloseForbidden() {
        $this->expectException();
        $tmpl = $this->createTempTemplate('</input>');  // ENTAG_FORBIDDEN
    }

    function testLonelyClose() {
        $tmpl = $this->createTempTemplate('</tag>');
    }

    function testWactSelfCloseExtraClose() {
        $tmpl = $this->createTempTemplate('<wact:block Variable="Value" /></wact:block>');  // ENDTAG_REQUIRED
    }

    function testAttributeEntity_lt() {
        $template = '<tag attribute="<">contents</tag>';
        $tmpl = $this->createTempTemplate($template);

        $output = $tmpl->capture();
        $this->assertEqual($output, $template);
    }

    function testAttributeEntity_gt() {
        $template = '<tag attribute=">">contents</tag>';
        $tmpl = $this->createTempTemplate($template);

        $output = $tmpl->capture();
        $this->assertEqual($output, $template);
    }
    
    function testAttributeEntity_quot() {
        $template = '<tag attribute="\'test\'">contents</tag>';
        $tmpl = $this->createTempTemplate($template);

        $output = $tmpl->capture();
        $this->assertEqual($output, $template);
    }
    
    function testAttributeEntity_amp() {
        $template = '<tag attribute="&">contents</tag>';
        $tmpl = $this->createTempTemplate($template); 

        $output = $tmpl->capture();
        $this->assertEqual($output, $template);
    }
    
    function testContentEntity_lt() {
        $template = '<body><</body>';
        $tmpl = $this->createTempTemplate($template); 

        $output = $tmpl->capture();
        $this->assertEqual($output, $template);
    }
    
    function testContentEntity_gt() {
        $template = '<body>></body>';
        $tmpl = $this->createTempTemplate($template); 

        $output = $tmpl->capture();
        $this->assertEqual($output, $template);
    }
    
    function testContentEntity_quot() {
        $template = '<body>"</body>';
        $tmpl = $this->createTempTemplate($template); 

        $output = $tmpl->capture();
        $this->assertEqual($output, $template);
    }
    
    function testContentEntity_amp() {
        $template = '<body>&</body>';
        $tmpl = $this->createTempTemplate($template); 

        $output = $tmpl->capture();
        $this->assertEqual($output, $template);
    }
    
    function testEmptyClose() {
        $template = '<body></></body>';
        $tmpl = $this->createTempTemplate($template); 

        $output = $tmpl->capture();
        $this->assertEqual($output, $template);
    }

    function testEmptyOpen() {
        $template = '<body><></body>';
        $tmpl = $this->createTempTemplate($template); 

        $output = $tmpl->capture();
        $this->assertEqual($output, $template);
    }

    function testDoubleClose() {
        $template = '<html><body></body/><html>';
        $tmpl = $this->createTempTemplate($template); 

        $output = $tmpl->capture();
        $this->assertEqual($output, $template);
    }

    function testCloseAttribute() {
        $template = '<body></body attribute="test">';
        $tmpl = $this->createTempTemplate($template); 

        $output = $tmpl->capture();
        $this->assertEqual($output, $template);
    }

    function testTruncatedTag1() {
        $template = '<';
        $tmpl = $this->createTempTemplate($template); 

        $output = $tmpl->capture();
        $this->assertEqual($output, $template);
    }
    
    function testTruncatedTag2() {
        $template = '<bo';
        $tmpl = $this->createTempTemplate($template); 

        $output = $tmpl->capture();
        $this->assertEqual($output, $template);
    }

    function testTruncatedClose1() {
        $template = '<body color="#999999">hello</';
        $tmpl = $this->createTempTemplate($template); 

        $output = $tmpl->capture();
        $this->assertEqual($output, $template);
    }

    function testTruncatedClose2() {
        $template = '<body color="#999999">hello</body';
        $tmpl = $this->createTempTemplate($template); 

        $output = $tmpl->capture();
        $this->assertEqual($output, $template);
    }

    function testTruncatedClose3() {
        $template = '<body color="#999999">hello</bo';
        $tmpl = $this->createTempTemplate($template); 

        $output = $tmpl->capture();
        $this->assertEqual($output, $template);
    }

    function testTruncatedValue() {
        $template = '<body color="#99';
        $tmpl = $this->createTempTemplate($template); 

        $output = $tmpl->capture();
        $this->assertEqual($output, $template);
    }

    function testTruncatedContent() {
        $template = '<body color="#999999">hello';
        $tmpl = $this->createTempTemplate($template); 

        $output = $tmpl->capture();
        $this->assertEqual($output, $template);
    }
    
    function testWactAttributeEntity_lt() {
        $template = '<body><wact:block wact:id="test" attribute="<">contents</wact:block></body>';
        $tmpl = $this->createTempTemplate($template); 

        $output = $tmpl->capture();
        $this->assertEqual($output, '<body>contents</body>');
    }
    
    function testWactAttributeEntity_gt() {
        $template = '<body><wact:block wact:id="test" attribute=">">contents</wact:block></body>';
        $tmpl = $this->createTempTemplate($template); 

        $output = $tmpl->capture();
        $this->assertEqual($output, '<body>contents</body>');
    }
    
    function testWactAttributeEntity_quot() {
        $template = '<body><wact:block wact:id="test" attribute="\'test\'">contents</wact:block></body>';
        $tmpl = $this->createTempTemplate($template); 

        $output = $tmpl->capture();
        $this->assertEqual($output, '<body>contents</body>');
    }
    
    function testWactAttributeEntity_amp() {
        $template = '<body><wact:block wact:id="test" attribute="&">contents</wact:block></body>';
        $tmpl = $this->createTempTemplate($template); 

        $output = $tmpl->capture();
        $this->assertEqual($output, '<body>contents</body>');
    }

    function testWactContentEntity_lt() {
        $template = '<body><wact:block wact:id="test"><</wact:block></body>';
        $tmpl = $this->createTempTemplate($template); 

        $output = $tmpl->capture();
        $this->assertEqual($output, '<body><</body>');
    }

    function testWactContentEntity_gt() {
        $template = '<body><wact:block wact:id="test">></wact:block></body>';
        $tmpl = $this->createTempTemplate($template); 

        $output = $tmpl->capture();
        $this->assertEqual($output, '<body>></body>');
    }

    function testWactContentEntity_quot() {
        $template = '<body><wact:block wact:id="test">"</wact:block></body>';
        $tmpl = $this->createTempTemplate($template); 

        $output = $tmpl->capture();
        $this->assertEqual($output, '<body>"</body>');
    }

    function testWactContentEntity_amp() {
        $template = '<body><wact:block wact:id="test">&</wact:block></body>';
        $tmpl = $this->createTempTemplate($template); 

        $output = $tmpl->capture();
        $this->assertEqual($output, '<body>&</body>');
    }

    function testWactTruncatedClose1() {
        $this->expectException();
        $template = '<body><wact:block wact:id="test">Content</';
        $tmpl = $this->createTempTemplate($template); 

        $output = $tmpl->capture();
        $this->assertEqual($output, $template);
    }

    function testWactTruncatedClose2() {
        $this->expectException();
        $template = '<body><wact:block wact:id="test">Content</wact:block';
        $tmpl = $this->createTempTemplate($template); 

        $output = $tmpl->capture();
        $this->assertEqual($output, $template);
    }

    function testWactTruncatedClose3() {
        $this->expectException();
        $template = '<body><wact:block wact:id="test">Content</wact:blo';
        $tmpl = $this->createTempTemplate($template); 

        $output = $tmpl->capture();
        $this->assertEqual($output, $template);
    }

    function testWactTruncatedValue() {
        $template = '<body><wact:block wact:id="test </body>';
        $tmpl = $this->createTempTemplate($template); 

        $output = $tmpl->capture();
        $this->assertEqual($output, $template);
    }

    function testWactTruncatedContent() {
        $this->expectException();
        $template = '<body><wact:block wact:id="test">content';
        $tmpl = $this->createTempTemplate($template); 

        $output = $tmpl->capture();
        $this->assertEqual($output, $template);
    }

    function testTruncatedAttribute() {
        $template = '<body col';
        $tmpl = $this->createTempTemplate($template); 

        $output = $tmpl->capture();
        $this->assertEqual($output, $template);
    }

    function testWactTruncatedAttribute() {
        $template = '<body><wact:block wact:id';
        $tmpl = $this->createTempTemplate($template); 

        $output = $tmpl->capture();
        $this->assertEqual($output, $template);
    }

}
?>