<?php

class TemplateFileter_TestCase extends Wact_Test_Case_Template {

    function testStringConstant() {
        $tmpl = $this->createTempTemplate( '{$"hello"|uppercase}');

        $output = $tmpl->capture();
        $this->assertEqual($output, 'HELLO');
    }
    
    function testFilter() {
        $tmpl = $this->createTempTemplate( '{$Var|uppercase}');

        $tmpl->setModel(array('Var' => 'Foo'));

        $output = $tmpl->capture();
        $this->assertEqual($output, 'FOO');
    }

    function testWactAttributeVariableFilter() {
        $tmpl = $this->createTempTemplate( '<div wact:id="test" extra="{$Var|uppercase}">contents</div>');

        $tmpl->setModel(array('Var' => 'Foo'));

        $output = $tmpl->capture();
        $this->assertEqual($output, '<div extra="FOO">contents</div>');
    }

    function testFilterChain() {
        $tmpl = $this->createTempTemplate( '{$Var|trim|uppercase}');

        $tmpl->setModel(array('Var' => '   Foo   '));

        $output = $tmpl->capture();
        $this->assertEqual($output, 'FOO');
    }

    function testFilterChainOrder() {
        $tmpl = $this->createTempTemplate( '{$Var|lowercase|uppercase}');

        $tmpl->setModel(array('Var' => 'Hello'));

        $output = $tmpl->capture();
        $this->assertEqual($output, 'HELLO');
    }

    function testFilterParameter() {
        $tmpl = $this->createTempTemplate( '{$Var|wordwrap:10}');

        $tmpl->setModel(array('Var' => 'The quick brown fox jumped over the lazy dog.'));

        $output = $tmpl->capture();
        $this->assertEqual($output, "The quick\nbrown fox\njumped\nover the\nlazy dog.");
    }

    function testFilterVariableParameter() {
        $tmpl = $this->createTempTemplate( '{$Var|wordwrap:Size}');

        $tmpl->setModel(array(
            'Var' => 'The quick brown fox jumped over the lazy dog.',
            'Size' => 10));

        $output = $tmpl->capture();
        $this->assertEqual($output, "The quick\nbrown fox\njumped\nover the\nlazy dog.");
    }

    function testTooManyFilterparameters() {
        $this->expectException();
        $tmpl = $this->createTempTemplate( '{$Var|trim:80}');

        $tmpl->setModel(array('Var' => '   Foo   '));

        $output = $tmpl->capture();
    }

    
    function testParameterParsing() {
        $tmpl = $this->createTempTemplate( '{$Var | default : "|trim"}');

        $tmpl->setModel(array('Var' => NULL));

        $output = $tmpl->capture();
        $this->assertEqual($output, "|trim");
    }

    function testParameterParsing2() {
        $tmpl = $this->createTempTemplate('{$Var | default : "test: 99"}');

        $tmpl->setModel(array('Var' => NULL));

        $output = $tmpl->capture();
        $this->assertEqual($output, "test: 99");
    }

    function testParameterParsing3() {
        $tmpl = $this->createTempTemplate('{$Var | default : ", test: 99"}');

        $tmpl->setModel(array('Var' => NULL));

        $output = $tmpl->capture();
        $this->assertEqual($output, ", test: 99");
    }

    function testNumberFormatFilter() {
        $tmpl = $this->createTempTemplate('{$Var|number} {$Var|number:2} {$Var|number:3, ",", "."}');

        $tmpl->setModel(array('Var' => 1234567.4321));

        $output = $tmpl->capture();
        $this->assertEqual($output, '1,234,567 1,234,567.43 1.234.567,432');
    }

    function testTooFewFilterparameters() {
        $this->expectException();
        $tmpl = $this->createTempTemplate('{$Var|wordwrap}');

        $tmpl->setModel(array('Var' =>  'The quick brown fox jumped over the lazy dog.'));

        $output = $tmpl->capture();
    }

    function testBadFilter() {
        $this->expectException();
        $tmpl = $this->createTempTemplate('{$Var|99}');

        $output = $tmpl->capture();
    }

}
?>