<?php

/**
* Some compile time component
* @tag Foo
* @attributes foo  bar baz
* @end_tag ENDTAG_FORBIDDEN
* @known_parent Bar
* @location LOCATION_CLIENT
*/
class FooTestTag {
}


class TagInfoTestCase extends Wact_Test_Case {

    function testAnnotations() {
        $info = new Wact_Template_Compiler_Tag_Info('FooTestTag');
        
        $this->assertEqual($info->getName(), 'FooTestTag');
        $this->assertEqual($info->tag, 'Foo');
        $this->assertEqual($info->endTag, Wact_Template_Compiler_Tag_Info::ENDTAG_FORBIDDEN);
        $this->assertEqual($info->compilerAttributes, array('foo', 'bar', 'baz'));
        $this->assertEqual($info->knownParent, 'Bar');
        $this->assertEqual($info->defaultLocation, Wact_Template_Compiler_Tag_Info::LOCATION_CLIENT);

        $this->assertEqual($info->getFileName(), __FILE__);

    }
     
}

?>