<?php
/**
 * Web Application Component Toolkit
 *
 * @link http://www.phpwact.org/
 *
 * @author Wact Development Team
 * @link http://www.phpwact.org/team
 *
 * @copyright Copyright 2006, Jeff Moore
 * @license http://opensource.org/licenses/mit-license.php MIT
 */

/**
 *
 *
 */
class Wact_Template_Compiler_Tag_Info extends Wact_Reflection_Class {

    /**
    * The tag must have a closing tag
    */
    const ENDTAG_REQUIRED = 1;
    
    /**
    * The tag may have a closing tag
    */
    const ENDTAG_OPTIONAL = 2;

    /**
    * The tag may not have a closing tag
    */
    const ENDTAG_FORBIDDEN = 3;


    /**
    */
    const LOCATION_SERVER = 'server';

    /**
    */
    const LOCATION_CLIENT = 'client';

    /**
    */
    public $tag;

    /**
    */
    public $endTag = self::ENDTAG_REQUIRED;

    /**
    */
    public $compilerAttributes = array();

    /**
    */
    public $knownParent;

    /**
    */
    public $defaultLocation = self::LOCATION_SERVER;

    /**
    */
    function __construct($class) {
        parent::__construct($class);

        $this->tag = $this->getAnnotation('tag');
        if ($note = $this->getAnnotation('end_tag')) {
            $this->endTag = constant(__CLASS__ . '::' . $note);
        }
        if ($note = $this->getAnnotation('attributes')) {
            $this->compilerAttributes = explode(' ', preg_replace('~\s+~', ' ', trim($note)));
        }
        if ($note = $this->getAnnotation('known_parent')) {
            $this->knownParent = $note;
        }
        if ($note = $this->getAnnotation('location')) {
            $this->defaultLocation = constant(__CLASS__ . '::' . $note);
        }
    }
    
    protected function getAnnotation($name) {
        $comment = $this->getDocComment();
        $pattern = '/^\s*\*\s+@' . preg_quote($name, '/') . '\s+(.*)$/m';
        if (preg_match($pattern, $comment, $tagMatches)) {
            return $tagMatches[1];
        }
    }

}

?>