<?php

class Wact_Template_Compiler_Parser_State_LiteralTestCase extends Wact_Template_Compiler_Parser_State_Test {

    function setUp() {
        parent::setUp();
        $this->state = new Wact_Template_Compiler_Parser_State_Literal($this->parser, $this->treeBuilder);
        $this->state->setDocumentLocator($this->locator);
    }

    function tearDown() {
        unset($this->state);
    }

    function testStartElement() {
        $tag = 'test';
        $attrs = array('foo' => 'bar');
        $raw = '<test foo="bar">';
        $this->state->activate('foo');
        $this->locator->setReturnValue('getRawEventString', $raw);
        $this->treeBuilder->expectOnce('addTextNode', array($raw));
        $this->state->startElement($tag, $attrs);
        $this->treeBuilder->tally();
    }

    function testEndElement() {
        $tag = 'test';
        $raw = '</' . $tag . '>';
        $this->locator->setReturnValue('getRawEventString', $raw);
        $this->state->activate('foo');
        $this->treeBuilder->expectOnce('addTextNode', array($raw));
        $this->state->endElement($tag);
        $this->treeBuilder->tally();
    }

    function testEndElementLiteral() {
        $tag = 'test';
        $this->state->activate('test');
        $this->treeBuilder->expectOnce('popTag');
        $this->parser->expectOnce('changeToComponentParsingState');
        $this->state->endElement($tag);
        $this->treeBuilder->tally();
        $this->parser->tally();
    }

    function testEmptyElement() {
        $tag = 'test';
        $attrs = array('foo' => 'bar');
        $raw = '<test foo="bar" />';
        $this->state->activate('foo');
        $this->locator->setReturnValue('getRawEventString', $raw);
        $this->treeBuilder->expectOnce('addTextNode', array($raw));
        $this->state->emptyElement($tag, $attrs);
        $this->treeBuilder->tally();
    }

    function testCharacters() {
        $text = 'test';
        $this->treeBuilder->expectOnce('addTextNode', array($text));
        $this->state->characters($text);
        $this->treeBuilder->tally();
    }

    function testComment() {
        $text = 'test';
        $raw = '<!--' . $text . '-->';
        $this->locator->setReturnValue('getRawEventString', $raw);
        $this->treeBuilder->expectOnce('addTextNode', array($raw));
        $this->state->comment($text);
        $this->treeBuilder->tally();
    }

}

?>