<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
* Base state handler for the Wact_Template_Compiler_Parser_Source. Handles plain text
*/
class Wact_Template_Compiler_Parser_State {

    /**
    * Instance of Wact_Template_Compiler_Parser_Source
    * @var Wact_Template_Compiler_Parser_Source
    */
    protected $parser;

    /**
    * Used to locate position within document
    */
    protected $locator;

    /**
    * Instance of Wact_Template_Compiler_Parser_TreeBuilder
    * @var Wact_Template_Compiler_Parser_TreeBuilder
    */
    protected $treeBuilder;

    /**
    * @param Wact_Template_Compiler_Parser_Source
    */
    function __construct($parser, $treeBuilder) {
        $this->parser = $parser;
        $this->treeBuilder = $treeBuilder;
    }

    /**
    * @param Locator
    */
    function setDocumentLocator($locator) {
        $this->locator = $locator;
        $this->treeBuilder->setDocumentLocator($locator);
    }

}
?>