<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/** 
*/
class Wact_Template_Compiler_Parser_ContentListener implements Wact_Template_Compiler_Expression_Observer {

    protected $treeBuilder;

    protected $locator;

    function __construct($treeBuilder, $locator) {
        $this->treeBuilder = $treeBuilder;
        $this->locator = $locator;
    }

    function addLiteral($text) {
        $this->treeBuilder->addTextNode($text);
    }

    function addExpression(Wact_Template_Compiler_Expression_Node $expr) {

            $location = new Wact_Template_Compiler_Location(
                $this->locator->getPublicId(),
                $this->locator->getLineNumber());

            $output = new Wact_Template_Compiler_Expression_Output (
                NULL, NULL,
                $location,
                $expr);

            $this->treeBuilder->addNode($output);

    }

    function beginFragments() {
    }

    function addLiteralFragment($text) {
        $this->treeBuilder->addTextNode($text);
    }

    function addExpressionFragment(Wact_Template_Compiler_Expression_Node $expr) {
        $this->addExpression($expr);
    }

    function endFragments() {
    }

}
?>
