<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
* Used to write literal text from the source template to the compiled
* template
*/
class Wact_Template_Compiler_Node_Text extends Wact_Template_Compiler_Node_Inline {
    /**
    * A text string to write
    * @var string
    */
    private $contents;

    /**
    * Constructs Wact_Template_Compiler_Node_Text
    * @param string contents of the text node
    */
    function __construct($tag, $tagInfo, $sourceLocation, $text) {
        parent::__construct($tag, $tagInfo, $sourceLocation);
        $this->contents = $text;
    }

    /**
    * Appends a further string to the text node
    * @param string
    * @return void
    */
    function append($text) {
        $this->contents .= $text;
    }

    /**
    */
    function addChild($child) {
        throw new Wact_Template_Compiler_Exception("Cannot add children to terminal node");
    }

    /**
    * Writes the contents of the text node to the compiled template
    * using the writeHTML method
    * @param Wact_Php_Writer $code
    * @return void
    */
    function generatePaintInline($code) {
        $code->writeHTML($this->contents);
    }
}

?>