<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
* Server tag component tags are Wact_Template_Compiler_Node_Views which also correspond to
* an HTML tag. Makes it easier to implement instead of extending from the
* Wact_Template_Compiler_Node_View class
*/
class Wact_Template_Compiler_Node_TagView extends Wact_Template_Compiler_Node_View {

    /**
    * Returns the XML tag name
    * @return string
    */
    function getRenderedTag() {
        return $this->tag;
    }

    /**
    */
    function getAttributeFilter() {
        // Determine which attributes should not propigate to the view
        $filter = $this->tagInfo->compilerAttributes;

        // Gobally filtered attributes
        $filter[] = Wact_Template_Compiler_Attribute::WACT_ID;
        $filter = array_map('strtolower', $filter);
        return $filter;
    }

    /**
    * Returns an array containing the attributes of this component that
    * can be resolved at compile time.
    * @return array representation of attributes
    */
    function getAttributesAsArray($suppress = array()) {
        $attributes = array();
        foreach($this->attributeNodes as $key => $attribute) {
            if (!in_array($key, $suppress) && $attribute->isConstant()) {
                $attributes[$attribute->name] = $attribute->getValueEscaped();
            }
        }
        return $attributes;
    }

    /**
    * @param Wact_Php_Writer $code
    */
    function generatePaintExtraAttributes($code) {
        $suppress = $this->getAttributeFilter();
        foreach($this->attributeNodes as $key => $attribute) {
            if (!in_array($key, $suppress) && !$attribute->isConstant()) {
                $attribute->generate($code);
            }
        }
    }
    
    /**
    * @param Wact_Php_Writer $code
    */
    function generateExtraMethods($code) {
        $oldScope = $code->switchToClassScope($this->getViewClass());
        $code->createMethod('paintExtraAttributes');
        $this->generatePaintExtraAttributes($code);
        $code->setScope($oldScope);
    }

    /**
    * Generate the code to initialize the view based on this tag.
    * @param Wact_Php_Writer $code
    */
    function generateConstructParameters($code) {
        $code->writePHP(var_export($this->getAttributesAsArray($this->getAttributeFilter()), TRUE));
        $code->writePHP(', ');
        $code->writePHP(var_export($this->closing == self::CLOSING_TAG, TRUE));
    }
}
?>