<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
* Server tag component tags are Wact_Template_Compiler_Node_Views which also correspond to
* an HTML tag. Makes it easier to implement instead of extending from the
* Wact_Template_Compiler_Node_View class
*/
class Wact_Template_Compiler_Node_ScopedView extends Wact_Template_Compiler_Node_View {

    /**
    * Does this component desire to generate code into its own paint method?
    */
    function isPaintRequired() {
        return TRUE;
    }

    /**
    * @param Wact_Php_Writer
    * @return void
    */
    function generateExtraMethods($code) {

        if ($this->hasAttribute('from')) {
            $oldScope = $code->switchToClassScope($this->getViewClass());
            $code->createMethod('render');

            $from = $this->getAttribute('from');

            $from->generatePreStatement($code);

            $code->writePHP('$this->setModel(');
            $from->generateExpression($code);
            $code->writePHP(');');

            $from->generatePostStatement($code);
        
            $code->writePHP('parent::render();');    
            $code->setScope($oldScope);
        }

    }

    /**
    * @return Boolean Indicating whether or not this component is a Scope
    */
    function hasModel() {
        return TRUE;
    }

}
?>