<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
* Compile time component for tags in template which are not
* recognized WACT tags but have a wact:id attribute.
* This allows native HTML tags, for example, to be manipulated
* at runtime.
* Wact_Template_Compiler_Generic_Tag is for tags with no children.
*/
class Wact_Template_Compiler_Generic_Tag extends Wact_Template_Compiler_Node_TagView {

    /**
    * The view class corresponding to this template node.
    * @var string
    */
    public $parentViewClass = 'Wact_View_Tag';

    /**
    * Generate the code to initialize the view based on this tag.
    * @param Wact_Php_Writer $code
    */
    function generateConstructParameters($code) {
        $code->writePHP(var_export($this->getRenderedTag(), TRUE) . ',');
        parent::generateConstructParameters($code);
    }
    
}

?>