<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
*/
class Wact_Template_Compiler_Formatter_Info extends Wact_Reflection_Class {

    public $formatter;
    public $minParameterCount = 1;
    public $maxParameterCount = 1;

    function __construct($class) {
        parent::__construct($class);

        $this->formatter = $this->getAnnotation('formatter');;

        $note = $this->getAnnotation('min_attributes');
        if ($note !== FALSE) {
            $this->minParameterCount = (int) $note;
        }
        
        $note = $this->getAnnotation('max_attributes');
        if ($note !== FALSE) {
            $this->maxParameterCount = (int) $note;
        }
    }
    
    protected function getAnnotation($name) {
        $comment = $this->getDocComment();
        $pattern = '/^\s*\*\s+@' . preg_quote($name, '/') . '\s+(.*)$/m';
        if (preg_match($pattern, $comment, $tagMatches)) {
            return $tagMatches[1];
        }
        return FALSE;
    }

}
?>