<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
* Outputs the result of an expression
* @see CoreOutputTag
*/
class Wact_Template_Compiler_Expression_Output extends Wact_Template_Compiler_Node_Inline {

    /**
    * @var Expression
    */
    var $expression;

    /**
    */
    function __construct($tag, $tagInfo, $sourceLocation, $expression) {
        parent::__construct($tag, $tagInfo, $sourceLocation);
        $this->expression = $expression;
    }

    /**
    */
    function prepare() {
        $this->expression->prepare();
        parent::prepare();
    }

    /**
    */
    function addChild($child) {
        throw new Wact_Template_Compiler_Exception("Cannot add children to terminal node");
    }

    /**
    * @param Wact_Php_Writer $code
    * @return void
    */
    function generatePaintInline($code) {
        if ($this->expression->isConstant()) {
            $code->writeHTML($this->expression->getValue());
        } else {
            $this->expression->generatePreStatement($code);
            $code->writePHP('echo ');
            $this->expression->generateExpression($code);
            $code->writePHP(';');
            $this->expression->generatePostStatement($code);
        }
    }

}
?>