<?php

class Wact_Template_Compiler_Expression_Node_AdditionTestCase extends Wact_Test_Case {
    
    function testGetValue() {
        $one = new Wact_Template_Compiler_Expression_Node_Constant(1);
        $two = new Wact_Template_Compiler_Expression_Node_Constant(2);
        $node = new Wact_Template_Compiler_Expression_Node_Addition($one, $two);

        $this->assertIdentical($node->isConstant(), TRUE);
        $this->assertIdentical($node->getValue(), 3);
    }

}

class Wact_Template_Compiler_Expression_Node_SubtractionTestCase extends Wact_Test_Case {
    
    function testGetValue() {
        $one = new Wact_Template_Compiler_Expression_Node_Constant(1);
        $two = new Wact_Template_Compiler_Expression_Node_Constant(2);
        $node = new Wact_Template_Compiler_Expression_Node_Subtraction($one, $two);

        $this->assertIdentical($node->isConstant(), TRUE);
        $this->assertIdentical($node->getValue(), -1);
    }

}


class Wact_Template_Compiler_Expression_Node_MultiplicationTestCase extends Wact_Test_Case {
    
    function testGetValue() {
        $two = new Wact_Template_Compiler_Expression_Node_Constant(2);
        $three = new Wact_Template_Compiler_Expression_Node_Constant(3);
        $node = new Wact_Template_Compiler_Expression_Node_Multiplication($two, $three);

        $this->assertIdentical($node->isConstant(), TRUE);
        $this->assertIdentical($node->getValue(), 6);
    }

}

class Wact_Template_Compiler_Expression_Node_DivisionTestCase extends Wact_Test_Case {
    
    function testGetValue() {
        $four = new Wact_Template_Compiler_Expression_Node_Constant(4);
        $two = new Wact_Template_Compiler_Expression_Node_Constant(2);
        $node = new Wact_Template_Compiler_Expression_Node_Division($four, $two);

        $this->assertIdentical($node->isConstant(), TRUE);
        $this->assertIdentical($node->getValue(), 2);
    }

}

class Wact_Template_Compiler_Expression_Node_ModuloTestCase extends Wact_Test_Case {
    
    function testGetValue() {
        $four = new Wact_Template_Compiler_Expression_Node_Constant(4);
        $two = new Wact_Template_Compiler_Expression_Node_Constant(2);
        $node = new Wact_Template_Compiler_Expression_Node_Modulo($four, $two);

        $this->assertIdentical($node->isConstant(), TRUE);
        $this->assertIdentical($node->getValue(), 0);
    }

}

class Wact_Template_Compiler_Expression_Node_UnaryMinusTestCase extends Wact_Test_Case {
    
    function testGetValue() {
        $four = new Wact_Template_Compiler_Expression_Node_Constant(4);
        $node = new Wact_Template_Compiler_Expression_Node_UnaryMinus($four);

        $this->assertIdentical($node->isConstant(), TRUE);
        $this->assertIdentical($node->getValue(), -4);
    }

}

class Wact_Template_Compiler_Expression_Node_ConcatinationTestCase extends Wact_Test_Case {
    
    function testGetValue() {
        $head = new Wact_Template_Compiler_Expression_Node_Constant('head');
        $tail = new Wact_Template_Compiler_Expression_Node_Constant('tail');
        $node = new Wact_Template_Compiler_Expression_Node_Concatination($head, $tail);

        $this->assertIdentical($node->isConstant(), TRUE);
        $this->assertIdentical($node->getValue(), 'headtail');
    }

}

?>
