<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
* Bind to a data model value.
*/
class Wact_Template_Compiler_Expression_Node_Data extends Wact_Template_Compiler_Expression_Node {
    
    private $name;
    
    function __construct($name) {
        $this->name = $name;
    }

    /**
    * Does this property refer to a constant value at compile time?
    * @return Boolean
    */
    function isConstant() {
        return FALSE;
    }

    /**
    * Return this value as a PHP value
    * @return String
    */
    function getValue() {
        throw new Wact_Template_Compiler_Exception("Cannot evaluate non-constant expression during templating compilation");
    }

    /**
    * Generate the code to read the data value at run time
    * Must generate only a valid PHP Expression.
    * @param Wact_Php_Writer
    * @return void
    */
    function generateExpression($code) {
        // if this is being generated into the method of a node that
        // has a model, we could optimize this to $this->model->
        // [hasModel() is true]
        $code->writePHP('$this->myScope->model->' . $this->name);
    }
    
}

?>