<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
*
*/
abstract class Wact_Template_Compiler_Expression_Node_Binary extends Wact_Template_Compiler_Expression_Node {

    protected $firstOperand;
    protected $secondOperand;

    function __construct($first, $second) {
        $this->firstOperand = $first;
        $this->secondOperand = $second;
    }

    function isConstant() {
        return $this->firstOperand->isConstant() && $this->secondOperand->isConstant();
    }
    
    function generatePreStatement($code) {
        $this->firstOperand->generatePreStatement($code);
        $this->secondOperand->generatePreStatement($code);
    }

    function generateExpression($code) {
        $this->firstOperand->generateExpression($code);
        $this->secondOperand->generateExpression($code);
    }

    function generatePostStatement($code) {
        $this->firstOperand->generatePostStatement($code);
        $this->secondOperand->generatePostStatement($code);
    }

    function prepare() {
        $this->firstOperand->prepare();
        $this->secondOperand->prepare();
    }
    
}


?>