<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
* represents POST method parameters.
*/
class Wact_Request_Post extends Wact_Request_Parameter {

    function getRawValue() {
        if (isset($_POST[$this->sourceLocation])) {
            return $this->undoMagicSlashing($_POST[$this->sourceLocation]);
        }
    }

    function hasValue() {
        return array_key_exists($this->sourceLocation, $_POST);
    }

    /**
    */
    function WriteValueToTransition($transition, $value) {

        if ($this->getDefault() !== $value) {
            $transition->WriteValueToChannel(
                Wact_Controller_Transition_Form::CHANNEL_POST, 
                $this->getSourceLocation(), 
                $value);
        }

    }
    
}

?>