<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
* represents PATH_INFO parameters.
*/
class Wact_Request_Method extends Wact_Request_Parameter {

    function __construct() {
        parent::__construct('REQUEST_METHOD');
    }

    function getRawValue() {
        if (isset($_SERVER['REQUEST_METHOD'])) {
            return $_SERVER['REQUEST_METHOD'];
        }
    }

    function hasValue() {
        return array_key_exists('REQUEST_METHOD', $_SERVER);
    }

}

?>