<?php
/**
 * Web Application Component Toolkit
 *
 * @link http://www.phpwact.org/
 *
 * @author Wact Development Team
 * @link http://www.phpwact.org/team
 *
 * @copyright Copyright 2006, Jeff Moore
 * @license http://opensource.org/licenses/mit-license.php MIT
 */

/**
 *
 */
class Wact_Reflection_Parameter extends ReflectionParameter {

    /**
     * @return Wact_Reflection_Class
     */
    public function getDeclaringClass() {
        $class = parent::getDeclaringClass();
        if ($class !== NULL) {
            return new Wact_Reflection_Class($class->getName());
        } else {
            return NULL;
        }
    }

    /**
     * @return Wact_Reflection_Function
     */
    public function getDeclaringFunction() {
        $func = parent::getDeclaringFunction();
        if ($func instanceof ReflectionFunction) {
            return new Wact_Reflection_Function($func->getName());
        } else {
            return $this->getDeclaringClass();
        }
    }
    
    /**
     * @return Wact_Reflection_Class
     */
    public function getClass() {
        $class = parent::getClass();
        if ($class) {
            return new Wact_Reflection_Class($class->getName());
        } else {
            return NULL;
        }
    }
    
    /**
     * Return the type of this parameter
     * @return string type of this parameter accounting for docblocks
     */
    public function getType() {
        $comment = parent::getDeclaringFunction()->getDocComment();
        if ($comment) {
            $pattern = '/^\s*\*\s+@param\s+(\w+).*\$' . preg_quote($this->getName(), '/') . '/m';
            if (preg_match($pattern, $comment, $tagMatches)) {
                return $tagMatches[1];
            }
        }
        if ($argClassInfo = parent::getClass()) {
            return $argClassInfo->getName();
        }
        return NULL; // Unknown
    }
    
}

?>