<?php


interface WactReflectionObjectInterfaceTester {

}

class WactReflectionObjectTester implements WactReflectionObjectInterfaceTester {
    public $prop = TRUE;
    
    function foo() {
    }
}

class WactReflectionObjectStaticTester {
    static public $prop = 13;
}

class WactReflectionObjectConstructorTester {
    function __construct() {
    }
}

class WactReflectionObjectTestCase extends Wact_Test_Case {

    function testGetParentClassWithNoParent() {
        $class = new Wact_Reflection_Object(new StdClass());
        $this->assertFalse($class->getParentClass());
    }
    
    function testGetParentClassWithParent() {
        $class = new Wact_Reflection_Object(new StdClass());
        $this->assertFalse($class->getParentClass());
    }
    
    function testGetInterfaces() {
        $class = new Wact_Reflection_Object(new WactReflectionObjectTester());
        foreach($class->getInterfaces() as $name => $interface) {
            $this->assertEqual($name, 'WactReflectionClassTester');
            $this->assertIsA($interface, 'Wact_Reflection_Class');
            $this->assertEqual($interface->getName(), 'WactReflectionClassInterfaceTester');
        }
    }

    function testGetInterfacesWithNoneImplemented() {
        $class = new Wact_Reflection_Object(new StdClass());
        $this->assertIdentical($class->getInterfaces(), array());
    }
    
    function testGetProperty() {
        $class = new Wact_Reflection_Object(new WactReflectionObjectTester());
        $property = $class->getProperty('prop');
        $this->assertIsA($property, 'Wact_Reflection_Property');
        $this->assertEqual($property->getName(), 'prop');
    }

    function testGetPropertyThatDoesntExist() {
        $this->expectException('ReflectionException');
        $class = new Wact_Reflection_Object(new WactReflectionObjectTester());
        $property = $class->getProperty('doesnotexist');
    }

    function testGetProperties() {
        $class = new Wact_Reflection_Object(new WactReflectionObjectTester());
        foreach($class->getProperties() as $name => $property) {
            $this->assertIsA($property, 'Wact_Reflection_Property');
            $this->assertEqual($property->getName(), 'prop');
        }
    }

    function testGetMethod() {
        $class = new Wact_Reflection_Object(new WactReflectionObjectTester());
        $method = $class->getMethod('foo');
        $this->assertIsA($method, 'Wact_Reflection_Method');
        $this->assertEqual($method->getName(), 'foo');
    }
    
    function testGetMethods() {
        $class = new Wact_Reflection_Object(new WactReflectionObjectTester());
        foreach($class->getMethods() as $name => $method) {
            $this->assertIsA($method, 'Wact_Reflection_Method');
            $this->assertEqual($method->getName(), 'foo');
        }
    }

    function testGetConstructor() {
        $class = new Wact_Reflection_Object(new WactReflectionObjectConstructorTester());
        $method = $class->getConstructor();
        $this->assertIsA($method, 'Wact_Reflection_Method');
        $this->assertEqual($method->getName(), '__construct');
    }

    function testGetConstructorWithNoneDefined() {
        $class = new Wact_Reflection_Object(new StdClass());
        $method = $class->getConstructor();
        $this->AssertNull($method);
    }
    
}

?>