<?php
/**
 * Web Application Component Toolkit
 *
 * @link http://www.phpwact.org/
 *
 * @author Wact Development Team
 * @link http://www.phpwact.org/team
 *
 * @copyright Copyright 2006, Jeff Moore
 * @license http://opensource.org/licenses/mit-license.php MIT
 */

class Wact_Reflection_Method extends ReflectionMethod {

    /**
     * @return Wact_Reflection_Class
     */
    public function getDeclaringClass() {
        return new Wact_Reflection_Class(parent::getDeclaringClass()->getName());
    }

    /**
     * @return array of Wact_Reflection_Parameter
     */
    public function getParameters() {
        $parameters = array();
        foreach (parent::getParameters() as $name => $parameter) {
            $parameters[] = new Wact_Reflection_Parameter(
                array(parent::getDeclaringClass()->getName(), $this->getName()), 
                $parameter->getName());
        }
        return $parameters;
    }
    
}

?>