<?php

class WactBinderGetTestCase extends Wact_Test_Case {

    function testGetIndex() {
        $index = 'test';
        $value = 'value';
        $arr = array($index => $value);
        $this->assertEqual(Wact_Property_Binder::get($arr, $index), $value);
    }

    function testGetIndexMissing() {
        $index = 'test';
        $arr = array();
        $this->assertNull(Wact_Property_Binder::get($arr, $index, Wact_Property_Binder::NULL_IF_NOT_FOUND));

        try {
            $value = Wact_Property_Binder::get($arr, $index, Wact_Property_Binder::EXCEPTION_IF_NOT_FOUND);
            
            $this->fail('Expected exception not thrown');
        } catch (Wact_Property_Exception_IndexNotFound $e) {
            $this->pass();
        }

        // Should trigger a standard error
        // $value = Wact_Property_Binder::get($arr, $index);
    }

    function testGetIndexNULL() {
        $index = 'test';
        $arr = array($index => NULL);
        $this->assertNull(Wact_Property_Binder::get($arr, $index, Wact_Property_Binder::NULL_IF_NOT_FOUND));
        $this->assertNull(Wact_Property_Binder::get($arr, $index, Wact_Property_Binder::EXCEPTION_IF_NOT_FOUND));
        $this->assertNull(Wact_Property_Binder::get($arr, $index, Wact_Property_Binder::DONT_CHECK_IF_EXISTS));
    }

    function testGetProperty() {
        $index = 'test';
        $value = 'value';
        $obj = new StdClass();
        $obj->{$index} = $value;
        $this->assertEqual(Wact_Property_Binder::get($obj, $index), $value);
    }

    function testGetPropertyMissing() {
        $index = 'test';
        $obj = new StdClass();
        $this->assertNull(Wact_Property_Binder::get($obj, $index, Wact_Property_Binder::NULL_IF_NOT_FOUND));

        try {
            $value = Wact_Property_Binder::get($obj, $index, Wact_Property_Binder::EXCEPTION_IF_NOT_FOUND);
            
            $this->fail('Expected exception not thrown');
        } catch (Wact_Property_Exception_PropertyNotFound $e) {
            $this->pass();
        }

        // Should trigger a standard error
        // $value = Wact_Property_Binder::get($obj, $index);
    }

    function testGetPropertyNULL() {
        $index = 'test';
        $obj->{$index} = NULL;
        $this->assertNull(Wact_Property_Binder::get($obj, $index, Wact_Property_Binder::NULL_IF_NOT_FOUND));
        $this->assertNull(Wact_Property_Binder::get($obj, $index, Wact_Property_Binder::EXCEPTION_IF_NOT_FOUND));
        $this->assertNull(Wact_Property_Binder::get($obj, $index, Wact_Property_Binder::DONT_CHECK_IF_EXISTS));
    }

    function testGetUngettable() {
        try {
            Wact_Property_Binder::get(5, 'test');
            
            $this->fail('Expected exception not thrown');
        } catch (Wact_Property_Exception_Dereference $e) {
            $this->pass();
        }
    }

    function testGetNULL() {
        try {
            Wact_Property_Binder::get(NULL, 'test');
            
            $this->fail('Expected exception not thrown');
        } catch (Wact_Property_Exception_Dereference $e) {
            $this->pass();
        }
    }

}


class Wact_Property_BinderSetTestCase extends Wact_Test_Case {

    function testSetIndex() {
        $index = 'test';
        $value = 'foo';
        $var = array();
        Wact_Property_Binder::set($var, $index, $value);
        $this->assertEqual(Wact_Property_Binder::get($var, $index), $value);
    }

    function testSetProperty() {
        $index = 'test';
        $value = 'foo';
        $var = new StdClass();
        Wact_Property_Binder::set($var, $index, $value);
        $this->assertEqual(Wact_Property_Binder::get($var, $index), $value);
    }

    function testSetUnsettable() {
        try {
            $value = 'foo';
            $var = 5;
            Wact_Property_Binder::set($var, 'test', $value);
            
            $this->fail('Expected exception not thrown');
        } catch (Wact_Property_Exception_Dereference $e) {
            $this->pass();
        }
    }

    function testSetNULL() {
        try {
            $value = 'foo';
            $var = NULL;
            Wact_Property_Binder::set($var, 'test', $value);
            
            $this->fail('Expected exception not thrown');
        } catch (Wact_Property_Exception_Dereference $e) {
            $this->pass();
        }
    }

}

class WactBinderGetPathTestCase extends Wact_Test_Case {

    function testGetPathIndex() {
        $index = 'test';
        $value = 'value';
        $arr = array($index => $value);
        $this->assertEqual(Wact_Property_Binder::getPath($arr, $index), $value);
    }

    function testGetPathIndexMissing() {
        $index = 'test';
        $arr = array();
        $this->assertNull(Wact_Property_Binder::getPath($arr, $index, Wact_Property_Binder::NULL_IF_NOT_FOUND));

        try {
            $value = Wact_Property_Binder::getPath($arr, $index, Wact_Property_Binder::EXCEPTION_IF_NOT_FOUND);
            
            $this->fail('Expected exception not thrown');
        } catch (Wact_Property_Exception_IndexNotFound $e) {
            $this->pass();
        }

        // Should trigger a standard error
        // $value = Wact_Property_Binder::getPath($arr, $index);
    }

    function testGetIndexPathNULL() {
        $index = 'test';
        $arr = array($index => NULL);
        $this->assertNull(Wact_Property_Binder::getPath($arr, $index, Wact_Property_Binder::NULL_IF_NOT_FOUND));
        $this->assertNull(Wact_Property_Binder::getPath($arr, $index, Wact_Property_Binder::EXCEPTION_IF_NOT_FOUND));
        $this->assertNull(Wact_Property_Binder::getPath($arr, $index, Wact_Property_Binder::DONT_CHECK_IF_EXISTS));
    }

    function testGetPathProperty() {
        $index = 'test';
        $value = 'value';
        $obj = new StdClass();
        $obj->{$index} = $value;
        $this->assertEqual(Wact_Property_Binder::getPath($obj, $index), $value);
    }

    function testGetPathPropertyMissing() {
        $index = 'test';
        $obj = new StdClass();
        $this->assertNull(Wact_Property_Binder::getPath($obj, $index, Wact_Property_Binder::NULL_IF_NOT_FOUND));

        try {
            $value = Wact_Property_Binder::getPath($obj, $index, Wact_Property_Binder::EXCEPTION_IF_NOT_FOUND);
            
            $this->fail('Expected exception not thrown');
        } catch (Wact_Property_Exception_PropertyNotFound $e) {
            $this->pass();
        }

        // Should trigger a standard error
        // $value = Wact_Property_Binder::getPath($obj, $index);
    }

    function testGetPathPropertyNULL() {
        $index = 'test';
        $obj->{$index} = NULL;
        $this->assertNull(Wact_Property_Binder::getPath($obj, $index, Wact_Property_Binder::NULL_IF_NOT_FOUND));
        $this->assertNull(Wact_Property_Binder::getPath($obj, $index, Wact_Property_Binder::EXCEPTION_IF_NOT_FOUND));
        $this->assertNull(Wact_Property_Binder::getPath($obj, $index, Wact_Property_Binder::DONT_CHECK_IF_EXISTS));
    }

    function testGetPathUngettable() {
        try {
            Wact_Property_Binder::getPath(5, 'test');
            
            $this->fail('Expected exception not thrown');
        } catch (Wact_Property_Exception_Dereference $e) {
            $this->pass();
        }
    }

    function testGetPathNULL() {
        try {
            Wact_Property_Binder::getPath(NULL, 'test');
            
            $this->fail('Expected exception not thrown');
        } catch (Wact_Property_Exception_Dereference $e) {
            $this->pass();
        }
    }
    
}

class WactBinderCreatePathTestCase extends Wact_Test_Case {
    
    function testCreatePath() {
        $path = 'test';
        $value = 'foo';
        $result = Wact_Property_Binder::createPath($path, $value);
        $this->assertEqual($result->$path, $value);
    }

    function testCreatePathChain() {
        $path = 'first.second';
        $value = 'foo';
        $result = Wact_Property_Binder::createPath($path, $value);
        $this->assertEqual($result->first->second, $value);
    }

    function testCreatePathLongChain() {
        $path = 'first.second.third';
        $value = 'foo';
        $result = Wact_Property_Binder::createPath($path, $value);
        $this->assertEqual($result->first->second->third, $value);
    }
    
}

class WactBinderSetPathTestCase extends Wact_Test_Case {

    function testSetIndex() {
        $index = 'test';
        $value = 'foo';
        $var = array();
        Wact_Property_Binder::setPath($var, $index, $value);
        $this->assertEqual(Wact_Property_Binder::getPath($var, $index), $value);
    }

    function testSetPathProperty() {
        $index = 'test';
        $value = 'foo';
        $var = new StdClass();
        Wact_Property_Binder::setPath($var, $index, $value);
        $this->assertEqual(Wact_Property_Binder::getPath($var, $index), $value);
    }

    function testSetPathUnsettable() {
        try {
            $value = 'foo';
            $var = 5;
            Wact_Property_Binder::setPath($var, 'test', $value);
            
            $this->fail('Expected exception not thrown');
        } catch (Wact_Property_Exception_Dereference $e) {
            $this->pass();
        }
    }

    function testSetPathNULL() {
        try {
            $value = 'foo';
            $var = NULL;
            Wact_Property_Binder::setPath($var, 'test', $value);
            
            $this->fail('Expected exception not thrown');
        } catch (Wact_Property_Exception_Dereference $e) {
            $this->pass();
        }
    }

}


?>