<?php

class Wact_Php_Writer_BlockTestCase extends Wact_Test_Case {
    function testEmpty() {
        $block = new Wact_Php_Writer_Block(Wact_Php_Writer_Block::MODE_HTML);
        $this->assertEqual($block->getCode(), '');

        $block = new Wact_Php_Writer_Block(Wact_Php_Writer_Block::MODE_PHP);
        $this->assertEqual($block->getCode(), '');
    }

    function testKeepContext() {
        $block = new Wact_Php_Writer_Block(Wact_Php_Writer_Block::MODE_HTML);
        $block->switchToPHP();
        $this->assertEqual($block->getCode(), '<' . '?php  ?' . '>');

        $block = new Wact_Php_Writer_Block(Wact_Php_Writer_Block::MODE_PHP);
        $block->switchToHTML();
        $this->assertEqual($block->getCode(), ' ?' . '><' . '?php ');
    }

    function testWritePHP() {
        $st = 'echo "Hello World!"';

        $block = new Wact_Php_Writer_Block(Wact_Php_Writer_Block::MODE_PHP);
        $block->writePHP($st);
        $this->assertEqual($block->getCode(), $st);

        $block = new Wact_Php_Writer_Block(Wact_Php_Writer_Block::MODE_HTML);
        $block->writePHP($st);
        $this->assertEqual($block->getCode(), '<?php ' . $st . ' ?>');
    }

    function testWriteHTML() {
        $st = '<p>Foo</p>';
        $st2 = '<p>Bar</p>';

        $block = new Wact_Php_Writer_Block(Wact_Php_Writer_Block::MODE_PHP);
        $block->writeHTML($st);
        $block->writeHTML($st2);
        $this->assertEqual($block->getCode(), ' ?>' . $st . $st2 . '<?php ');

        $block = new Wact_Php_Writer_Block(Wact_Php_Writer_Block::MODE_HTML);
        $block->writeHTML($st);
        $block->writeHTML($st2);
        $this->assertEqual($block->getCode(), $st . $st2);
    }

    function testCreateTempVariable() {
        $block = new Wact_Php_Writer_Block(Wact_Php_Writer_Block::MODE_PHP);
        $var = $block->createTempVariable();
        $this->assertWantedPattern('/[a-z][a-z0-9]*/i', $var);
        $this->assertEqual($block->getCode(), '');

        $block = new Wact_Php_Writer_Block(Wact_Php_Writer_Block::MODE_HTML);
        $var = $block->createTempVariable();
        $this->assertWantedPattern('/[a-z][a-z0-9]*/i', $var);
        $this->assertEqual($block->getCode(), '');
    }

    function testGetSecondTempVariable() {
        $block = new Wact_Php_Writer_Block(Wact_Php_Writer_Block::MODE_PHP);
        $A = $block->createTempVariable();
        $B = $block->createTempVariable();
        $this->assertNotEqual($A, $B);
        $this->assertEqual($block->getCode(), '');

        $block = new Wact_Php_Writer_Block(Wact_Php_Writer_Block::MODE_HTML);
        $A = $block->createTempVariable();
        $B = $block->createTempVariable();
        $this->assertNotEqual($A, $B);
        $this->assertEqual($block->getCode(), '');
    }

    function testCreateTempVariables() {
        $block = new Wact_Php_Writer_Block(Wact_Php_Writer_Block::MODE_PHP);
        for ($i = 1; $i <= 30; $i++) {
            $var = $block->createTempVariable();
            $this->assertWantedPattern('/[a-z][a-z0-9]*/i', $var);
        }
        $this->assertEqual($block->getCode(), '');

        $block = new Wact_Php_Writer_Block(Wact_Php_Writer_Block::MODE_HTML);
        for ($i = 1; $i <= 30; $i++) {
            $var = $block->createTempVariable();
            $this->assertWantedPattern('/[a-z][a-z0-9]*/i', $var);
        }
        $this->assertEqual($block->getCode(), '');
    }

    function testLiteral() {
        $block = new Wact_Php_Writer_Block(Wact_Php_Writer_Block::MODE_PHP);
        $block->writePHPLiteral("f'o'o\\");
        $this->assertEqual($block->getCode(), "'f\'o\'o\\\\'");
    }

}

?>