<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
* Turn a console oriented exception message into an HTML message.
*/
class Wact_Exception_Formatter_Html extends Wact_Error_Formatter_Html_StackTrace implements Wact_Exception_Formatter {

    /**
    */
    static function replaceInternalSpaces($match) {
        return "\n" . str_repeat('&nbsp;', strlen($match[0]) - 1);
    }

    /**
    */
    static function replaceFirstSpaces($match) {
        return str_repeat('&nbsp;', strlen($match[0]));
    }

    /**
    */
    static function convertToHtml($message) {
        $message = htmlspecialchars($message);
        $message = preg_replace_callback('/^ +/',
            array(__CLASS__, 'replaceFirstSpaces'),
            $message);
        $message = preg_replace_callback('/\n +/',
            array(__CLASS__, 'replaceInternalSpaces'),
            $message);
        $message = nl2br($message);
        return $message;
    }

    /**
    */
    function beginException() {
        $this->message .=  "<table style='color:black;background-color:white' border='1' cellspacing='0'>\n";
    }

    /**
    */
    function endException() {
        $this->message .= "</table>";
    }

    /**
    */
    function beginList() {
        $this->message .=  "<ol>\n";
    }

    /**
    */
    function endList() {
        $this->message .= "</ol>";
    }

    /**
    */
    function beginListItem() {
        $this->message .=  "<li>\n";
    }

    /**
    */
    function endListItem() {
        $this->message .= "</li>";
    }

    /**
    */
    function writeExceptionMessage($message, $file, $line, $class) {
        $this->message .= "<tr>\n";
        $this->message .= "<td bgcolor='#ff9999'>\n";
        $this->message .= '<b>' . $class . '</b> in <b>' . $file . '</b> '
               . 'on line <b>' . $line . "</b>\n";
        $this->message .= "<br />\n";
        $this->message .= htmlspecialchars($message) . "\n";

        $this->message .= "</td>\n";
        $this->message .= "</tr>\n";
    }

    /**
    */
    function beginChildSection($title) {
        $this->message .= "<tr><td bgcolor='#aaaaaa'><b>$title</b></td></tr>\n";
        $this->message .= "<tr>\n";
        $this->message .= "<td style='border-left-color:#aaaaaa;border-left-width:2em;'>\n";
    }

    /**
    */
    function endChildSection() {
        $this->message .= "</td>\n";
        $this->message .= "</tr>\n";
    }

    /**
    */
    function writeException($e) {
        if (method_exists($e, 'toHtml')) {
            $this->message .= $e->toHtml();
        } else {
            $this->message .= self::
                convertToHtml($e->__toString());
        }
    }
    
}

?>