<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
* Output a formatted stack trace
*/
class Wact_Error_Formatter_Html_StackTrace extends Wact_Error_Formatter_Base {

    /**
    */
    function writeStackTrace($trace) {
        $this->message .= "<tr><td bgcolor='#aaaaaa'><b>Stack Trace</b></td></tr>\n";
        $this->message .= "<tr>\n";
        $this->message .= "<td>\n";

        $this->message .= "<table border='1px' cellspacing='0' width='100%'>\n";
        $this->message .= "<tr>\n";
        $this->message .= "<td align='center' bgcolor='#cccccc' width='20'><b>#</b></td>\n";
        $this->message .= "<td align='center' bgcolor='#cccccc'><b>Function</b></td>\n";
        $this->message .= "<td align='center' bgcolor='#cccccc'><b>Location</b></td>\n";
        $this->message .= "</tr>\n";

        foreach ($trace as $sequence => $step) {
            $this->message .= "<tr bgcolor='#ffffff'>\n";
            $this->message .= '<td align="center">' . $sequence . "</td>\n";
            $this->message .= "<td>\n";
            if (!empty($step['class'])) {
                $this->message .= $step['class'] . $step['type'];
            }
            $this->message .= $step['function'];
            $args = array();
            if (!empty($step['args'])) {
                foreach ($step['args'] as $arg) {
                    if (is_null($arg)) {
                        $args[] = 'null';
                    } else if (is_array($arg)) {
                        $args[] = 'Array';
                    } else if (is_object($arg)) {
                        $args[] = 'Object[' . get_class($arg) . ']';
                    } else if (is_bool($arg)) {
                        $args[] = $arg ? 'true' : 'false';
                    } else if (is_int($arg) || is_double($arg)) {
                        $args[] = $arg;
                    } else {
                        $arg = (string) $arg;
                        $str = htmlspecialchars(substr($arg, 0, 16));
                        if (strlen($arg) > 16) {
                            $str .= '&hellip;';
                        }
                        $args[] = "'" . $str . "'";
                    }
                }
            }
            $this->message .= '(' . implode(', ',$args) . ")\n";
            $this->message .= "</td>\n";
            $this->message .= "<td>\n";
            $this->message .= isset($step['file']) ? $step['file'] : 'unknown';
            $this->message .= ':';
            $this->message .= isset($step['line']) ? $step['line'] : 'unknown';
            $this->message .= "</td>\n";
            $this->message .= "</tr>\n";
        }

        $this->message .= "</td>\n";
        $this->message .= "</tr>\n";

        $this->message .=  "<tr>\n";
        $this->message .= '<td align="center">' . ($sequence + 1) . "</td>\n";
        $this->message .= "<td>{main}</td>\n";
        $this->message .= "<td>&nbsp;</td>\n";
        $this->message .= "</tr>\n";

        $this->message .= "</table>\n";
        $this->message .= "</td>\n";
        $this->message .= "</tr>\n";
    }
    
}

?>