<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/

/**
*/
class Wact_Controller_Transition_Link extends Wact_Controller_Transition {

    const CHANNEL_GET = 'get';
    const CHANNEL_PATH_INFO = 'pathinfo';
    const CHANNEL_DERIVED = 'derived';

    /**
    */
    protected $channels = array(
        self::CHANNEL_DERIVED => array(),
        self::CHANNEL_GET => array(),
        self::CHANNEL_PATH_INFO => array());

    /**
    */
    function getControllerBase() {
        // this is implementation is probably inadequate.  
        // What are the i18n implications of using
        // this superglobal??
        // mod re-write implications?
        return $_SERVER['SCRIPT_NAME'];
    }

    /**
    */
    function getHref() {
        $base = $this->getControllerBase();
        if (!empty($this->channels[self::CHANNEL_PATH_INFO]['PATH_INFO'])) {
            $base .= '/' . $this->channels[self::CHANNEL_PATH_INFO]['PATH_INFO'];
        }
        $parameterStr = '';
        if (isset($this->channels[self::CHANNEL_GET])) {
            foreach ($this->channels[self::CHANNEL_GET] as $name => $value) {
                if (empty($parameterStr)) {
                    $parameterStr = $name . '=' . urlencode($value);
                } else {
                    $parameterStr .= '&' . $name . '=' . urlencode($value);
                }
            }
        }
        if (empty($parameterStr)) {
            return $base;
        } else {
            return $base . '?' . $parameterStr;
        }
    }

}

?>