<?php

class PathInfoDispatchControllerTestCase extends Wact_Test_Case {

    protected $config;
    
    function setUp() {
        $this->config = new Wact_Config_Registry();
    }

    function getBase() {
        return $_SERVER['SCRIPT_NAME'];
    }
    
    

    function getLink($controller, $commandPath) {
        $model = new Wact_Response_Model();
        $transition = new Wact_Controller_Transition_Link($controller, $commandPath, $model);
        $transition->build();
        return  $transition->getHref();
    }

    function testSpecified() {
        $controller = new Wact_Controller_Base($this->config);

        $controller->dispatchOn(new Wact_Request_PathInfo())->defaultTo('index');

        $controller->addChild('index', new Wact_Controller_Base($this->config));
        $controller->addChild('test', new Wact_Controller_Base($this->config));
        
        $expectedPath = $this->getBase() . '/test';
        $link = $this->getLink($controller, '/test');
        $this->assertEqual($expectedPath, $link);
    }

    function testDefault() {
        $controller = new Wact_Controller_Base($this->config);
        $controller->dispatchOn(new Wact_Request_PathInfo())->defaultTo('index');
        $controller->addChild('index', new Wact_Controller_Base($this->config));
        $controller->addChild('test', new Wact_Controller_Base($this->config));

        $expectedPath = $this->getBase();
        $link = $this->getLink($controller, '/index');
        $this->assertEqual($expectedPath, $link);
    }

    function testRoot() {
        $controller = new Wact_Controller_Base($this->config);
        $controller->dispatchOn(new Wact_Request_PathInfo())->defaultTo('index');
        $controller->addChild('index', new Wact_Controller_Base($this->config));
        $controller->addChild('test', new Wact_Controller_Base($this->config));
        
        $expectedPath = $this->getBase();
        $link = $this->getLink($controller, '/');
        $this->assertEqual($expectedPath, $link);
    }

    function testInnerSpecifiedOuterSpecified() {
        $inner = new Wact_Controller_Base($this->config);
        $inner->dispatchOn(new Wact_Request_Segmented('option', 'PATH_INFO'))->defaultTo('index');
        $inner->addChild('index', new Wact_Controller_Base($this->config));
        $inner->addChild('test2', new Wact_Controller_Base($this->config));

        $outer = new Wact_Controller_Base($this->config);
        $outer->dispatchOn(new Wact_Request_Segmented('module', 'PATH_INFO'))->defaultTo('index');
        $outer->defineInput(new Wact_Request_PathInfo());
        $outer->addChild('index', new Wact_Controller_Base($this->config));
        $outer->addChild('test1', $inner);

        // this expectation is unneccessarily brittle due to parameter ordering.
        $expectedPath = $this->getBase() . '/test1/test2';
        $link = $this->getLink($outer, '/test1/test2');
        $this->assertEqual($expectedPath, $link);
    }

    function testThreeLevelDeep() {
        $third = new Wact_Controller_Base($this->config);
        $third->dispatchOn(new Wact_Request_Segmented('mode', 'PATH_INFO'))->defaultTo('index');
        $third->addChild('index', new Wact_Controller_Base($this->config));
        $third->addChild('test3', new Wact_Controller_Base($this->config));

        $second = new Wact_Controller_Base($this->config);
        $second->dispatchOn(new Wact_Request_Segmented('option', 'PATH_INFO'))->defaultTo('index');
        $second->addChild('index', new Wact_Controller_Base($this->config));
        $second->addChild('test2', $third);

        $first = new Wact_Controller_Base($this->config);
        $first->dispatchOn(new Wact_Request_Segmented('module', 'PATH_INFO'))->defaultTo('index');
        $first->defineInput(new Wact_Request_PathInfo());
        $first->addChild('index', new Wact_Controller_Base($this->config));
        $first->addChild('test1', $second);
        
        // this expectation is unneccessarily brittle due to parameter ordering.
        $expectedPath = $this->getBase() . '/test1/test2/test3';
        $link = $this->getLink($first, '/test1/test2/test3');
        $this->assertEqual($expectedPath, $link);
    }

    function testInnerDefaultOuterSpecified() {
        $inner = new Wact_Controller_Base($this->config);
        $inner->dispatchOn(new Wact_Request_Segmented('option', 'PATH_INFO'))->defaultTo('index');
        $inner->addChild('index', new Wact_Controller_Base($this->config));
        $inner->addChild('test2', new Wact_Controller_Base($this->config));

        $outer = new Wact_Controller_Base($this->config);
        $outer->dispatchOn(new Wact_Request_Segmented('module', 'PATH_INFO'))->defaultTo('index');
        $outer->defineInput(new Wact_Request_PathInfo());
        $outer->addChild('test1', new Wact_Controller_Base($this->config));
        $outer->addChild('index', $inner);

        $expectedPath = $this->getBase() . '/index/test2';
        $link = $this->getLink($outer, '/index/test2');
        $this->assertEqual($expectedPath, $link);
    }

    function testInnerSpecifiedOuterDefault() {
        $inner = new Wact_Controller_Base($this->config);
        $inner->dispatchOn(new Wact_Request_Segmented('option', 'PATH_INFO'))->defaultTo('index');
        $inner->addChild('index', new Wact_Controller_Base($this->config));
        $inner->addChild('test2', new Wact_Controller_Base($this->config));

        $outer = new Wact_Controller_Base($this->config);
        $outer->dispatchOn(new Wact_Request_Segmented('module', 'PATH_INFO'))->defaultTo('index');
        $outer->defineInput(new Wact_Request_PathInfo());
        $outer->addChild('index', new Wact_Controller_Base($this->config));
        $outer->addChild('test1', $inner);

        $expectedPath = $this->getBase() . '/test1';
        $link = $this->getLink($outer, '/test1/index');
        $this->assertEqual($expectedPath, $link);
    }

    function testInnerDefaultOuterDefault() {
        $inner = new Wact_Controller_Base($this->config);
        $inner->dispatchOn(new Wact_Request_Segmented('option', 'PATH_INFO'))->defaultTo('index');
        $inner->addChild('index', new Wact_Controller_Base($this->config));
        $inner->addChild('test2', new Wact_Controller_Base($this->config));

        $outer = new Wact_Controller_Base($this->config);
        $outer->dispatchOn(new Wact_Request_Segmented('module', 'PATH_INFO'))->defaultTo('index');
        $outer->defineInput(new Wact_Request_PathInfo());
        $outer->addChild('test1', new Wact_Controller_Base($this->config));
        $outer->addChild('index', $inner);

        $expectedPath = $this->getBase();
        $link = $this->getLink($outer, '/index/index');
        $this->assertEqual($expectedPath, $link);
    }

    function testInnerDefaultOuterDefaultAbbreviatedCommandPath() {
        $inner = new Wact_Controller_Base($this->config);
        $inner->dispatchOn(new Wact_Request_Segmented('option', 'PATH_INFO'))->defaultTo('index');
        $inner->addChild('index', new Wact_Controller_Base($this->config));
        $inner->addChild('test2', new Wact_Controller_Base($this->config));

        $outer = new Wact_Controller_Base($this->config);
        $outer->dispatchOn(new Wact_Request_Segmented('module', 'PATH_INFO'))->defaultTo('index');
        $outer->defineInput(new Wact_Request_PathInfo());
        $outer->addChild('test1', new Wact_Controller_Base($this->config));
        $outer->addChild('index', $inner);

        $expectedPath = $this->getBase();
        $link = $this->getLink($outer, '/index/');
        $this->assertEqual($expectedPath, $link);
    }

}

?>