<?php

// A little debug utility to help visual the structure of your application

class WactControllerDebugger {
    
    function printPageHeader() {
        echo "<h3>Controller Dump:</h3>";
    }

    function printParameter($parameter) {
        echo get_class($parameter), ' ', $parameter->getName();
        if ($parameter->getSourceLocation() != $parameter->getName()) {
            echo ' from ', $parameter->getSourceLocation();
        }
        if ($parameter->getModelLocation() !== NULL) {
            echo ' bound to ', $parameter->getModelLocation();
        }
    }

    function printView($controller) {
        $view = $controller->getView();
        $name = $controller->getPartialViewName();
        if (is_object($view)) {
            echo '<p>';
            echo 'View';
            echo '<ul>';
            echo '<li>';
            echo get_class($view);
            if (empty($name)) {
                echo ' (top level view)';
            } else {
                echo " (will become a child of the '$name' node of the next higher view)";
            }
            echo '</li>';
            echo '</ul>';
            echo '</p>';
        }
    }


    // Should indicate if children are public or private
    function printController($controller) {
        echo '<div class="controller">';
        if (is_object($controller->parent)) {
            echo $controller->getName(), ' :: ';
        }
        echo get_class($controller);
        
        $parameters = $controller->getParameters();
        if (count($parameters) > 0) {
            echo '<p>';
            echo 'Parameters';
            echo '<ul>';
            foreach (array_keys($parameters) as $key) {
                $parameter = $parameters[$key];
                echo '<li>';
                self::printParameter($parameter);

                if ($controller->isDispatcher($key)) {
                    echo ' (dispatcher)';
                }

                echo "</li>\n";
            }
            echo '</ul>';
            echo '</p>';
        }

        self::printView($controller);

        $children = $controller->getChildNames();
        if (count($children) > 0) {
            echo '<p>';
            echo 'Child controllers ';

            echo '<ul>';
            foreach ($children as $key) {
                echo '<li>';
                $child = $controller->getChild($key);
                self::printController($child);

                echo '</li>';
            }
            echo '</ul>';
            echo '</p>';
        }

        echo '</div>';
    }
    
    static function dump($controller) {
        self::printPageHeader();
        self::printController($controller);
    }
}

?>