<?php

Mock::generate(
        'Wact_Controller_Base',
        'MockController');

class ControllerTestCase extends Wact_Test_Case {

    protected $controller;
    protected $config;

    function setUp() {
        $this->config = new Wact_Config_Registry();
        $this->controller = new Wact_Controller_Base($this->config);
    }

    function testAddChild() {
        $name = 'test';
        $child = new MockController($this);
        $child->expectOnce('setParent', array('*', $name));
        $this->controller->addChild($name, $child);
        $child->tally();
    }

    function testAddChild2() {
        $name = 'test';
        $child = new MockController($this);
        $child->expectOnce('setParent', array('*', $name));
        $this->controller->addChild($name, $child);
        $child->tally();
    }

    function testHasChild() {
        $name = 'test';
        $this->assertFalse($this->controller->hasChild($name));

        $child = new MockController($this);
        $this->controller->addChild($name, $child);
        $this->assertTrue($this->controller->hasChild($name));
    }

    function testGetChild() {
        $name = 'test';
        $child = new MockController($this);
        $this->controller->addChild($name, $child);
        $this->assertReference($child, $this->controller->getChild($name));
    }

    function testGetChildNotFound() {
        $name = 'test';
        $this->assertNull($this->controller->getChild($name));
    }

}

?>