<?php

class WactConfigRegistryFactoryTester {
    public $param;
    public $optional;
    public $value;
    /**
     * @var prop_type
     */
    public $prop;
    
    /**
     * @param param_type | string $param The password to use for something or other
     * @param optional_type|string $optional The password to use for something or other
     */
    function __construct($param, $optional = NULL) {
        $this->param = $param;
        $this->optional = $optional;
    }
    
    /**
     * @param value_type|string $value The password to use for something or other
     */
    function setValue($value) {
        $this->value = $value;
    }
}

Mock::generate('Wact_Config_Registry', 'MockWact_Config_Registry');

class WactConfigFactoryTestCase extends Wact_Test_Case {

    /**
     * Enter description here...
     *
     * @var unknown_type
     */
    protected $registry;
    
    /**
     * Enter description here...
     *
     * @var unknown_type
     */
    protected $context;

    function setUp() {
        $this->factory = new Wact_Config_Registry_Factory();
        $this->context = new MockWact_Config_Registry($this);
    }

    function testCreatingValue() {
        $this->factory->asValue('unique');
        $value = $this->factory->createInstance(NULL);
        
        $this->assertEqual($value, 'unique');
    }
    
    function testCreatingStdClass() {
        $obj = $this->factory->createInstance(NULL);
        
        $this->assertIsa($obj, "StdClass");
    }

    function testCreatingAliasToType() {
        $this->context->setReturnValue('get', 'bar', array('foo', '*'));
        
        $this->factory->asAliasToType('foo');
        $obj = $this->factory->createInstance($this->context);
        
        $this->assertEqual($obj, 'bar');
    }
    
    function testCreatingTestClass() {
        $this->context->setReturnValue('get', 'bar', array('param_type'));
        
        $this->factory->asClass('WactConfigRegistryFactoryTester');
        $obj = $this->factory->createInstance($this->context);
        
        $this->assertIsa($obj, "WactConfigRegistryFactoryTester");
        $this->assertEqual($obj->param, 'bar');
    }

    function testCreatingClassWithSpecifiedParameter() {
        $this->context->expectNever('get');
                
        $this->factory->asClass('WactConfigRegistryFactoryTester');
        $obj = $this->factory->createInstance($this->context, array('foo'));
        
        $this->assertIsa($obj, "WactConfigRegistryFactoryTester");
        $this->assertEqual($obj->param, 'foo');
    }

    function testCreatingClassWithParameterValue() {
        $this->context->expectNever('get');
        
        $this->factory
            ->asClass('WactConfigRegistryFactoryTester')
            ->parameterValue('param', 'foo');
        $obj = $this->factory->createInstance($this->context);
        
        $this->assertIsa($obj, "WactConfigRegistryFactoryTester");
        $this->assertEqual($obj->param, 'foo');
    }

    function testCreatingClassWithParameterValueNumeric() {
        $this->context->expectNever('get');
        
        $this->factory
            ->asClass('WactConfigRegistryFactoryTester')
            ->parameterValue(0, 'foo');
        $obj = $this->factory->createInstance($this->context);
        
        $this->assertIsa($obj, "WactConfigRegistryFactoryTester");
        $this->assertEqual($obj->param, 'foo');
    }

    function testCreatingClassWithParameterType() {
        $this->context->setReturnValue('get', 'bar', array('foo'));
                
        $this->factory
            ->asClass('WactConfigRegistryFactoryTester')
            ->parameterType('param', 'foo');
        $obj = $this->factory->createInstance($this->context);
        
        $this->assertIsa($obj, "WactConfigRegistryFactoryTester");
        $this->assertEqual($obj->param, 'bar');
    }

    function testCreatingClassWithParameterTypeNumeric() {
        $this->context->setReturnValue('get', 'bar', array('foo'));
                        
        $this->factory
            ->asClass('WactConfigRegistryFactoryTester')
            ->parameterType(0, 'foo');
        $obj = $this->factory->createInstance($this->context);
        
        $this->assertIsa($obj, "WactConfigRegistryFactoryTester");
        $this->assertEqual($obj->param, 'bar');
    }

    function testForcingOptionalToBeRequired() {
        $this->context->setReturnValue('get', 'bar', array('optional_type'));
                        
        $this->factory
            ->asClass('WactConfigRegistryFactoryTester')
            ->parameterRequired('optional');
        $obj = $this->factory->createInstance($this->context);
        
        $this->assertIsa($obj, "WactConfigRegistryFactoryTester");
        $this->assertEqual($obj->optional, 'bar');
    }

    function testForcingOptionalToBeRequiredNumeric() {
        $this->context->setReturnValue('get', 'bar', array('optional_type'));
                        
        $this->factory
            ->asClass('WactConfigRegistryFactoryTester')
            ->parameterRequired(1);
        $obj = $this->factory->createInstance($this->context);
        
        $this->assertIsa($obj, "WactConfigRegistryFactoryTester");
        $this->assertEqual($obj->optional, 'bar');
    }

    function testCreatingClassWithPropertyValue() {
        $this->factory
            ->asClass('WactConfigRegistryFactoryTester')
            ->propertyValue('prop', 'foo');
        $obj = $this->factory->createInstance($this->context);
        
        $this->assertIsa($obj, "WactConfigRegistryFactoryTester");
        $this->assertEqual($obj->prop, 'foo');
    }

    function testCreatingClassWithPropertyType() {
        $this->context->setReturnValue('get', 'bar', array('foo'));
        
        $this->factory
            ->asClass('WactConfigRegistryFactoryTester')
            ->propertyType('prop', 'foo');
        $obj = $this->factory->createInstance($this->context);
        
        $this->assertIsa($obj, "WactConfigRegistryFactoryTester");
        $this->assertEqual($obj->prop, 'bar');
    }

    function testForcingPropertyToBeRequired() {
        $this->context->setReturnValue('get', 'bar', array('prop_type'));
        
        $this->factory
            ->asClass('WactConfigRegistryFactoryTester')
            ->propertyRequired('prop');
        $obj = $this->factory->createInstance($this->context);
        
        $this->assertIsa($obj, "WactConfigRegistryFactoryTester");
        $this->assertEqual($obj->prop, 'bar');
    }
    
    function testCreatingClassWithSetterValue() {
        $this->factory
            ->asClass('WactConfigRegistryFactoryTester')
            ->setterValue('setValue', 'foo');
        $obj = $this->factory->createInstance($this->context);
        
        $this->assertIsa($obj, "WactConfigRegistryFactoryTester");
        $this->assertEqual($obj->value, 'foo');
    }

    function testCreatingClassWithSetterType() {
        $this->context->setReturnValue('get', 'bar', array('foo'));
        
        $this->factory
            ->asClass('WactConfigRegistryFactoryTester')
            ->setterType('setValue', 'foo');
        $obj = $this->factory->createInstance($this->context);
        
        $this->assertIsa($obj, "WactConfigRegistryFactoryTester");
        $this->assertEqual($obj->value, 'bar');
    }
    
    function testForcingSetterToBeRequired() {
        $this->context->setReturnValue('get', 'bar', array('value_type'));
        
        $this->factory
            ->asClass('WactConfigRegistryFactoryTester')
            ->setterRequired('setValue');
        $obj = $this->factory->createInstance($this->context);
        
        $this->assertIsa($obj, "WactConfigRegistryFactoryTester");
        $this->assertEqual($obj->value, 'bar');
    }
    
    function testCreatingClassWithSetterValueShortcut() {
        $this->factory
            ->asClass('WactConfigRegistryFactoryTester')
            ->setValue('foo');
        $obj = $this->factory->createInstance($this->context);
        
        $this->assertIsa($obj, "WactConfigRegistryFactoryTester");
        $this->assertEqual($obj->value, 'foo');
    }

    function testCreatingClassWithSetterTypeShortcut() {
        $this->context->setReturnValue('get', 'bar', array('value_type'));
        
        $this->factory
            ->asClass('WactConfigRegistryFactoryTester')
            ->setValue();
        $obj = $this->factory->createInstance($this->context);
        
        $this->assertIsa($obj, "WactConfigRegistryFactoryTester");
        $this->assertEqual($obj->value, 'bar');
    }
    
}
?>