<?php

abstract class Wact_Cache_Store_Test extends Wact_Test_Case {

    protected $cache;

    function testFetchDoesNotExist() {
        $this->assertNull($this->cache->fetch('test'));
    }

    function testFetchDoesNotExistWithDefault() {
        $this->assertIdentical($this->cache->fetch('test', FALSE), FALSE);
    }
    
    function testStoreFetch() {
        $this->cache->store('test', 'data');
        $this->assertEqual($this->cache->fetch('test'), 'data');
    }

    function testFetchValueDoesNotExist() {
        $this->assertNull($this->cache->fetchValue('test'));
    }

    function testFetchValueDoesNotExistWithDefault() {
        $this->assertIdentical($this->cache->fetchValue('test', FALSE), FALSE);
    }
    
    function testStoreValueFetchValue() {
        $this->cache->storeValue('test', 'data');
        $this->assertEqual($this->cache->fetchValue('test'), 'data');
    }

    function testStoreValueFetchValueNull() {
        $this->cache->storeValue('test', NULL);
        $this->assertEqual($this->cache->fetchValue('test', FALSE), NULL);
    }

    function testStoreValueFetchValueFalse() {
        $this->cache->storeValue('test', FALSE);
        $this->assertEqual($this->cache->fetchValue('test'), FALSE);
    }
    
    function testStoreFetchWithPath() {
        $this->cache->store('path/test', 'data');
        $this->assertEqual($this->cache->fetch('path/test'), 'data');
    }
    
    function testincludeCodeDoesNotExist() {
        $this->assertFalse($this->cache->includeCode('test'));
    }

    function testStoreincludeCode() {
        $class = '_testclass' . uniqid();
        $data = '<?php class ' . $class . ' {} ?>';
        $this->assertFalse(class_exists($class, FALSE));
        $this->cache->store('test', $data);
        $this->assertTrue($this->cache->includeCode('test'));
        $this->assertTrue(class_exists($class, FALSE));
    }
   
    function testRemove() {
        $this->cache->store('test', 'data');
        $this->assertEqual($this->cache->fetch('test'), 'data');
        $this->cache->remove('test');
        $this->assertFalse($this->cache->fetch('test'));
    }

    function testRemoveDoesNotExist() {
        // What is the proper behavior in this case?
    }

    function testClear() {
        $this->cache->store('test', 'data');
        $this->assertEqual($this->cache->fetch('test'), 'data');
        $this->cache->clear();
        $this->assertFalse($this->cache->fetch('test'));
    }
    
}

?>
