<?php

class WactFileCacheTestCase extends Wact_Cache_Store_Test {

    protected $cache;

    function setUp() {
        clearstatcache();
        $this->cache = new Wact_Cache_Store_File();
    }

    function tearDown() {
        $this->cache->clear();
    }

    function testGetLocation() {
        $this->assertNotEqual($this->cache->getLocation(), NULL);
    }

    function testStoreOverwriteDirectoryWithFileError() {
        $this->cache->store('path/test', 'data');
        $this->assertFalse($this->cache->store('path', 'bad data'));
    }

    function testStoreOverwriteFileWithDirectoryError() {
        $this->cache->store('path', 'data');

        // This would cause overwriting a directory with a file
        $this->assertFalse($this->cache->store('path/test', 'bad data'));
    }

    function testRemoveError() {
        $this->cache->store('path/test', 'data');
        $this->assertFalse($this->cache->remove('path'));
    }
    
}

?>
