<?php
/**
* Web Application Component Toolkit
*
* @link http://www.phpwact.org/
*
* @author Wact Development Team
* @link http://www.phpwact.org/team
*
* @copyright Copyright 2006, Jeff Moore
* @license http://opensource.org/licenses/mit-license.php MIT
*/


/**
*/
class Wact_Cache_Store_Eaccelerator implements Wact_Cache_Store {

    /**
     * Is the extension that supports this cache store available?  
     */
    function isAvailable() {
        return extension_loaded('eaccelerator') && ini_get('eaccelerator.enable');
    }  

    /**
    * @see Wact_Cache_Store.store
    */
    public function store($key, $data, $lifetime = NULL) {
        settype($key, 'string');
        return eaccelerator_put($key, (string) $data, $lifetime);
    }

    /**
    * @see Wact_Cache_Store.storeValue
    */
    public function storeValue($key, $data, $lifetime = NULL) {
        return $this->store($key, serialize($data), $lifetime);
    }
    
    /**
    * @see Wact_Cache_Store.fetch
    */
    public function fetch($key, $default = NULL) {
        settype($key, 'string');
        $result = eaccelerator_get($key);
        if ($result === NULL) {
            return $default;
        } else {
            return $result;
        }
    }

    /**
    * @see Wact_Cache_Store.fetch
    */
    public function fetchValue($key, $default = NULL) {
        $result = $this->fetch($key, FALSE);
        if ($result === FALSE) {
            return $default;
        }
        return unserialize($result);
    }
    
    /**
    * @see Wact_Cache_Store.includeCode
    */
    public function includeCode($key) {
        $code = $this->fetch($key, FALSE);
        if ($code !== FALSE) {
            // Strange concatination works better with source code parsing tools
            $result = eval(' ?' . '>' . $code . '<' . '?php ');

            if (is_null($result)) {
                return TRUE;
            } else {
                return $result;
            }
        }
        return FALSE;
    }
    
    /**
    * @see Wact_Cache_Store.remove
    */
    public function remove($key) {
        settype($key, 'string');
        return eaccelerator_rm($key);
    }
    
    /**
    * @see Wact_Cache_Store.clear
    */
    public function clear() {
        // requires higher privileges
        eaccelerator_Clear();
        return TRUE;
    }
    
}

?>