<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

// +----------------------------------------------------------------------+
// | Akelos Framework - http://www.akelos.org                             |
// +----------------------------------------------------------------------+
// | Copyright (c) 2002-2006, Akelos Media, S.L.  & Bermi Ferrer Martinez |
// | Released under the GNU Lesser General Public License, see LICENSE.txt|
// +----------------------------------------------------------------------+

/**
 * @package ActiveSupport
 * @subpackage I18n-L10n
 * @author Bermi Ferrer <bermi a.t akelos c.om>
 * @copyright Copyright (c) 2002-2006, Akelos Media, S.L. http://www.akelos.org
 * @license GNU Lesser General Public License <http://www.gnu.org/copyleft/lesser.html>
 */

$ISO_3166_1_COUNTRIES = array('AD','AE','AF','AG','AI','AL','AM','AN',
'AO','AQ','AR','AS','AT','AU','AW','AZ','BA','BB','BD','BE','BF','BG',
'BH','BI','BJ','BM','BN','BO','BR','BS','BT','BV','BW','BY','BZ','CA',
'CC','CD','CF','CG','CH','CI','CK','CL','CM','CN','CO','CR','CU','CV',
'CX','CY','CZ','DE','DJ','DK','DM','DO','DZ','EC','EE','EG','EH','ER',
'ES','ET','FI','FJ','FK','FM','FO','FR','GA','GB','GD','GE','GF','GH',
'GI','GL','GM','GN','GP','GQ','GR','GS','GT','GU','GW','GY','HK','HM',
'HN','HR','HT','HU','ID','IE','IL','IN','IO','IQ','IR','IS','IT','JM',
'JO','JP','KE','KG','KH','KI','KM','KN','KP','KR','KW','KY','KZ','LA',
'LB','LC','LI','LK','LR','LS','LT','LU','LV','LY','MA','MC','MD','MG',
'MH','MK','ML','MM','MN','MO','MP','MQ','MR','MS','MT','MU','MV','MW',
'MX','MY','MZ','NA','NC','NE','NF','NG','NI','NL','NO','NP','NR','NU',
'NZ','OM','PA','PE','PF','PG','PH','PK','PL','PM','PN','PR','PS','PT',
'PW','PY','QA','RE','RO','RU','RW','SA','SB','SC','SD','SE','SG','SH',
'SI','SJ','SK','SL','SM','SN','SO','SR','ST','SV','SY','SZ','TC','TD',
'TF','TG','TH','TJ','TK','TM','TN','TO','TP','TR','TT','TV','TW','TZ',
'UA','UG','UM','US','UY','UZ','VA','VC','VE','VG','VI','VN','VU','WF',
'WS','YE','YT','YU','ZA','ZM','ZW');

$ISO_3166_1_ALPHA_COUNTRIES_XREF = array('AF'=>'AFG','AL'=>'ALB','DZ'=>'DZA',
'AS'=>'ASM','AD'=>'AND','AO'=>'AGO','AI'=>'AIA','AQ'=>'ATA','AG'=>'ATG','AR'=>'ARG',
'AM'=>'ARM','AW'=>'ABW','AU'=>'AUS','AT'=>'AUT','AZ'=>'AZE','BS'=>'BHS','BH'=>'BHR',
'BD'=>'BGD','BB'=>'BRB','BY'=>'BLR','BE'=>'BEL','BZ'=>'BLZ','BJ'=>'BEN','BM'=>'BMU',
'BT'=>'BTN','BO'=>'BOL','BA'=>'BIH','BW'=>'BWA','BV'=>'BVT','BR'=>'BRA','IO'=>'IOT',
'BN'=>'BRN','BG'=>'BGR','BF'=>'BFA','BI'=>'BDI','KH'=>'KHM','CM'=>'CMR','CA'=>'CAN',
'CV'=>'CPV','KY'=>'CYM','CF'=>'CAF','TD'=>'TCD','CL'=>'CHL','CN'=>'CHN','CX'=>'CXR',
'CC'=>'CCK','CO'=>'COL','KM'=>'COM','CG'=>'COG','CK'=>'COK','CR'=>'CRI','CI'=>'CIV',
'HR'=>'HRV','CU'=>'CUB','CY'=>'CYP','CZ'=>'CZE','DK'=>'DNK','DJ'=>'DJI','DM'=>'DMA',
'DO'=>'DOM','TL'=>'TLS','EC'=>'ECU','EG'=>'EGY','SV'=>'SLV','GQ'=>'GNQ','ER'=>'ERI',
'EE'=>'EST','ET'=>'ETH','FK'=>'FLK','FO'=>'FRO','FJ'=>'FJI','FI'=>'FIN','FR'=>'FRA',
'FX'=>'FXX','GF'=>'GUF','PF'=>'PYF','TF'=>'ATF','GA'=>'GAB','GM'=>'GMB','GE'=>'GEO',
'DE'=>'DEU','GH'=>'GHA','GI'=>'GIB','GR'=>'GRC','GL'=>'GRL','GD'=>'GRD','GP'=>'GLP',
'GU'=>'GUM','GT'=>'GTM','GN'=>'GIN','GW'=>'GNB','GY'=>'GUY','HT'=>'HTI','HM'=>'HMD',
'HN'=>'HND','HK'=>'HKG','HU'=>'HUN','IS'=>'ISL','IN'=>'IND','ID'=>'IDN','IR'=>'IRN',
'IQ'=>'IRQ','IE'=>'IRL','IL'=>'ISR','IT'=>'ITA','JM'=>'JAM','JP'=>'JPN','JO'=>'JOR',
'KZ'=>'KAZ','KE'=>'KEN','KI'=>'KIR','KP'=>'PRK','KR'=>'KOR','KW'=>'KWT','KG'=>'KGZ',
'LA'=>'LAO','LV'=>'LVA','LB'=>'LBN','LS'=>'LSO','LR'=>'LBR','LY'=>'LBY','LI'=>'LIE',
'LT'=>'LTU','LU'=>'LUX','MO'=>'MAC','MK'=>'MKD','MG'=>'MDG','MW'=>'MWI','MY'=>'MYS',
'MV'=>'MDV','ML'=>'MLI','MT'=>'MLT','MH'=>'MHL','MQ'=>'MTQ','MR'=>'MRT','MU'=>'MUS',
'YT'=>'MYT','MX'=>'MEX','FM'=>'FSM','MD'=>'MDA','MC'=>'MCO','MN'=>'MNG','MS'=>'MSR',
'MA'=>'MAR','MZ'=>'MOZ','MM'=>'MMR','NA'=>'NAM','NR'=>'NRU','NP'=>'NPL','NL'=>'NLD',
'AN'=>'ANT','NC'=>'NCL','NZ'=>'NZL','NI'=>'NIC','NE'=>'NER','NG'=>'NGA','NU'=>'NIU',
'NF'=>'NFK','MP'=>'MNP','NO'=>'NOR','OM'=>'OMN','PK'=>'PAK','PW'=>'PLW','PA'=>'PAN',
'PG'=>'PNG','PY'=>'PRY','PE'=>'PER','PH'=>'PHL','PN'=>'PCN','PL'=>'POL','PT'=>'PRT',
'PR'=>'PRI','QA'=>'QAT','RE'=>'REU','RO'=>'ROU','RU'=>'RUS','RW'=>'RWA','KN'=>'KNA',
'LC'=>'LCA','VC'=>'VCT','WS'=>'WSM','SM'=>'SMR','ST'=>'STP','SA'=>'SAU','SN'=>'SEN',
'SC'=>'SYC','SL'=>'SLE','SG'=>'SGP','SK'=>'SVK','SI'=>'SVN','SB'=>'SLB','SO'=>'SOM',
'ZA'=>'ZAF','ES'=>'ESP','LK'=>'LKA','SH'=>'SHN','PM'=>'SPM','SD'=>'SDN','SR'=>'SUR',
'SJ'=>'SJM','SZ'=>'SWZ','SE'=>'SWE','CH'=>'CHE','SY'=>'SYR','TW'=>'TWN','TJ'=>'TJK',
'TZ'=>'TZA','TH'=>'THA','TG'=>'TGO','TK'=>'TKL','TO'=>'TON','TT'=>'TTO','TN'=>'TUN',
'TR'=>'TUR','TM'=>'TKM','TC'=>'TCA','TV'=>'TUV','UG'=>'UGA','UA'=>'UKR','AE'=>'ARE',
'GB'=>'GBR','US'=>'USA','UM'=>'UMI','UY'=>'URY','UZ'=>'UZB','VU'=>'VUT','VA'=>'VAT',
'VE'=>'VEN','VN'=>'VNM','VG'=>'VGB','VI'=>'VIR','WF'=>'WLF','EH'=>'ESH','YE'=>'YEM',
'YU'=>'YUG','ZR'=>'ZAR','ZM'=>'ZMB','ZW'=>'ZWE');


$ISO_639_2_LANGUAGES = array('af','ar','az','be','bg','br','ca','cs','cy',
'da','de','el','en','eo','es','et','eu','fi','fo','fr','fy','ga','gd','gv',
'he','hr','hu','id','is','it','ja','kl','ku','la','lb','lt','lv','mk','mt',
'nl','no','pl','pt','rm','ro','ru','se','sk','sl','so','sq','sr','sv','sw',
'tr','uk','vi','yi','zh');

// As taken from the wikipedia
$ISO_639_2_LANGUAGE_DESCRIPTIONS = array (
  'af' => 'Afrikaans',
  'ar' => 'العربية',
  'az' => 'Azərbaycan',
  'be' => 'Беларуская',
  'br' => 'Brezhoneg',
  'bg' => 'Български',
  'ca' => 'Català',
  'cs' => 'Česky',
  'cy' => 'Cymraeg',
  'da' => 'Dansk',
  'de' => 'Deutsch',
  'et' => 'Eesti',
  'el' => 'Ελληνικά',
  'es' => 'Español',
  'eo' => 'Esperanto',
  'eu' => 'Euskara',
  'fo' => 'Føroyskt',
  'fr' => 'Français',
  'fy' => 'Frysk',
  'ga' => 'Gaeilge',
  'gv' => 'Gaelg',
  'gd' => 'Gàidhlig',
  'hr' => 'Hrvatski',
  'id' => 'Bahasa Indonesia',
  'is' => 'Íslenska',
  'it' => 'Italiano',
  'he' => 'עברית',
  'sw' => 'Kiswahili',
  'ku' => 'Kurdî / كوردی',
  'la' => 'Latina',
  'lv' => 'Latviešu',
  'lb' => 'Lëtzebuergesch',
  'lt' => 'Lietuvių',
  'hu' => 'Magyar',
  'mk' => 'Македонски',
  'nl' => 'Nederlands',
  'ja' => '日本語',
  'no' => '‪Norsk (bokmål)‬',
  'pl' => 'Polski',
  'pt' => 'Português',
  'ro' => 'Română',
  'rm' => 'Rumantsch',
  'ru' => 'Русский',
  'se' => 'Sámegiella',
  'sq' => 'Shqip',
  'sk' => 'Slovenčina',
  'sl' => 'Slovenščina',
  'so' => 'Soomaaliga',
  'sr' => 'Српски / Srpski',
  'fi' => 'Suomi',
  'sv' => 'Svenska',
  'tr' => 'Türkçe',
  'uk' => 'Українська',
  'vi' => 'Tiếng Việt',
  'yi' => 'ייִדיש',
  'zh' => '中文',
);

$ISO_639_2_3_LANGUAGES_XREF = array('af'=>'afr','ar'=>'ara','az'=>'aze','be'=>'bel',
'bg'=>'bul','br'=>'bre','ca'=>'cat','cs'=>'ces','cy'=>'cym','da'=>'dan','de'=>'deu',
'el'=>'ell','en'=>'eng','eo'=>'epo','es'=>'spa','et'=>'est','eu'=>'eus','fi'=>'fin',
'fo'=>'fao','fr'=>'fra','fy'=>'fry','ga'=>'gle','gd'=>'gla','gv'=>'glv','he'=>'heb',
'hr'=>'hrv','hu'=>'hun','id'=>'ind','is'=>'isl','it'=>'ita','ja'=>'jpn','kl'=>'kal',
'ku'=>'kur','la'=>'lat','lb'=>'ltz','lt'=>'lit','lv'=>'lav','mk'=>'mkd','mt'=>'mlt',
'nl'=>'nld','no'=>'nor','pl'=>'pol','pt'=>'por','rm'=>'roh','ro'=>'ron','ru'=>'rus',
'se'=>'sme','sk'=>'slk','sl'=>'slv','so'=>'som','sq'=>'sqi','sr'=>'srp','sv'=>'swe',
'sw'=>'swa','tr'=>'tur','uk'=>'ukr','vi'=>'vie','yi'=>'yid','zh'=>'zho');


$ISO_639_2_3_LANGUAGES = array('aar','abk','ace','ach','ada','ady','afa',
'afh','afr','aka','akk','alb','ale','alg','amh','ang','apa','ara','arc',
'arg','arm','arn','arp','art','arw','asm','ast','ath','aus','ava','ave',
'awa','aym','aze','bad','bai','bak','bal','bam','ban','baq','bas','bat',
'bej','bel','bem','ben','ber','bho','bih','bik','bin','bis','bla','bnt',
'bod','bos','bra','bre','btk','bua','bug','bul','bur','byn','cad','cai',
'car','cat','cau','ceb','cel','ces','cha','chb','che','chg','chi','chk',
'chm','chn','cho','chp','chr','chu','chv','chy','cmc','cop','cor','cos',
'cpe','cpf','cpp','cre','crh','crp','csb','cus','cym','cze','dak','dan',
'dar','day','del','den','deu','dgr','din','div','doi','dra','dsb','dua',
'dum','dut','dyu','dzo','efi','egy','eka','ell','elx','eng','enm','epo',
'est','eus','ewe','ewo','fan','fao','fas','fat','fij','fil','fin','fiu',
'fon','fra','fre','frm','fro','fry','ful','fur','gaa','gay','gba','gem',
'geo','ger','gez','gil','gla','gle','glg','glv','gmh','goh','gon','gor',
'got','grb','grc','gre','grn','guj','gwi','hai','hat','hau','haw','heb',
'her','hil','him','hin','hit','hmn','hmo','hrv','hsb','hun','hup','hye',
'iba','ibo','ice','ido','iii','ijo','iku','ile','ilo','ina','inc','ind',
'ine','inh','ipk','ira','iro','isl','ita','jav','jbo','jpn','jpr','jrb',
'kaa','kab','kac','kal','kam','kan','kar','kas','kat','kau','kaw','kaz',
'kbd','kha','khi','khm','kho','kik','kin','kir','kmb','kok','kom','kon',
'kor','kos','kpe','krc','kro','kru','kua','kum','kur','kut','lad','lah',
'lam','lao','lat','lav','lez','lim','lin','lit','lol','loz','ltz','lua',
'lub','lug','lui','lun','luo','lus','mac','mad','mag','mah','mai','mak',
'mal','man','mao','map','mar','mas','may','mdf','mdr','men','mga','mic',
'min','mis','mkd','mkh','mlg','mlt','mnc','mni','mno','moh','mol','mon',
'mos','mri','msa','mul','mun','mus','mwl','mwr','mya','myn','myv','nah',
'nai','nap','nau','nav','nbl','nde','ndo','nds','nep','new','nia','nic',
'niu','nld','nno','nob','nog','non','nor','nso','nub','nwc','nya','nym',
'nyn','nyo','nzi','oci','oji','ori','orm','osa','oss','ota','oto','paa',
'pag','pal','pam','pan','pap','pau','peo','per','phi','phn','pli','pol',
'pon','por','pra','pro','pus','que','raj','rap','rar','roa','roh','rom',
'ron','rum','run','rus','sad','sag','sah','sai','sal','sam','san','sas',
'sat','scc','scn','sco','scr','sel','sem','sga','sgn','shn','sid','sin',
'sio','sit','sla','slk','slo','slv','sma','sme','smi','smj','smn','smo',
'sms','sna','snd','snk','sog','som','son','sot','spa','sqi','srd','srp',
'srr','ssa','ssw','suk','sun','sus','sux','swa','swe','syr','tah','tai',
'tam','tat','tel','tem','ter','tet','tgk','tgl','tha','tib','tig','tir',
'tiv','tkl','tlh','tli','tmh','tog','ton','tpi','tsi','tsn','tso','tuk',
'tum','tup','tur','tut','tvl','twi','tyv','udm','uga','uig','ukr','umb',
'und','urd','uzb','vai','ven','vie','vol','vot','wak','wal','war','was',
'wel','wen','wln','wol','xal','xho','yao','yap','yid','yor','ypk','zap',
'zen','zha','zho','znd','zul','zun');

$ISO_4217_CURRENCIES = array(
'ANG'=>'&#402;',
'ARS'=>'&#8369;',
'AUD'=>'&#36;',
'AWG'=>'&#402;',
'BBD'=>'&#36;',
'BEF'=>'&#8355;',
'BMD'=>'&#36;',
'BND'=>'&#36;',
'BRC'=>'&#8354;',
'BSD'=>'&#36;',
'BZD'=>'&#36;',
'CAD'=>'&#36;',
'CLP'=>'&#36;',
'CNY'=>'&#22291;',
'COP'=>'&#8369;',
'CRC'=>'&#8353;',
'CUP'=>'&#8369;',
'CYP'=>'&#163;',
'DOP'=>'&#8369;',
'EGP'=>'&#163;',
'ESP'=>'&#8359;',
'EUR'=>'&#8364;',
'FJD'=>'&#36;',
'FKP'=>'&#163;',
'FRF'=>'&#8355;',
'GBP'=>'&#163;',
'GGP'=>'&#163;',
'GIP'=>'&#163;',
'GRD'=>'&#8367;',
'GYD'=>'&#36;',
'HKD'=>'&#36;',
'IEP'=>'&#163;',
'ILS'=>'&#8362;',
'IMP'=>'&#163;',
'INR'=>'&#8360;',
'IRR'=>'&#65020;',
'ITL'=>'&#8356;',
'JEP'=>'&#163;',
'JMD'=>'&#36;',
'JPY'=>'&#165;',
'KHR'=>'&#6107;',
'KPW'=>'&#8361;',
'KRW'=>'&#8361;',
'KYD'=>'&#36;',
'LAK'=>'&#8365;',
'LBP'=>'&#163;',
'LKR'=>'&#3065;',
'LRD'=>'&#36;',
'LUF'=>'&#8355;',
'MNT'=>'&#8366;',
'MTL'=>'&#8356;',
'MUR'=>'&#8360;',
'MXN'=>'&#36;',
'NAD'=>'&#36;',
'NGN'=>'&#8358;',
'NLG'=>'&#402;',
'NPR'=>'&#8360;',
'NZD'=>'&#36;',
'OMR'=>'&#65020;',
'PEN'=>'&#83;&#47;&#46;',
'PHP'=>'&#8369;',
'PKR'=>'&#8360;',
'QAR'=>'&#65020;',
'SAR'=>'&#65020;',
'SBD'=>'&#36;',
'SCR'=>'&#8360;',
'SGD'=>'&#36;',
'SHP'=>'&#163;',
'SRD'=>'&#36;',
'SVC'=>'&#8353;',
'SYP'=>'&#163;',
'THB'=>'&#3647;',
'TRL'=>'&#8356;',
'TRY'=>'&#8356;',
'TTD'=>'&#36;',
'TVD'=>'&#36;',
'TWD'=>'&#36;',
'USD'=>'&#36;',
'UYU'=>'&#8369;',
'VAL'=>'&#8356;',
'VND'=>'&#8363;',
'XCD'=>'&#36;',
'XEU'=>'&#8352;',
'YER'=>'&#65020;',
'ZAR'=>'&#82;',
'ZWD'=>'&#36;');


$OBSOLETE_CURRENCIES = array('ADP', 'AFA', 'AON', 'AOR', 'ATS', 'BEC',
'BEF', 'BEL', 'BGL', 'CSK', 'DDM', 'DEM', 'ECS', 'ECV', 'ESA', 'ESB',
'ESP', 'FIM', 'FRF', 'GRD', 'IEP', 'ITL', 'LUF', 'MXP', 'NLG', 'PLZ',
'PTE', 'RUR', 'SRG', 'SUR', 'TRL', 'XEU', 'YUD', 'YUM', 'ZAL', 'ZRN',
'ZRZ');


$CURRENCY_COUNTRY_XREF = array('AD'=>'EUR','AE'=>'AED','AF'=>'AFN',
'AG'=>'XCD','AI'=>'XCD','AL'=>'ALL','AM'=>'AMD','AN'=>'ANG',
'AO'=>'AOA','AR'=>'ARS','AS'=>'USD','AT'=>'EUR','AU'=>'AUD',
'AW'=>'AWG','AZ'=>'AZM','BA'=>'BAM','BB'=>'BBD','BD'=>'BDT',
'BE'=>'EUR','BF'=>'XOF','BG'=>'BGN','BH'=>'BHD','BI'=>'BIF',
'BJ'=>'XOF','BM'=>'BMD','BN'=>'BND','BO'=>'BOV','BR'=>'BRL',
'BS'=>'BSD','BT'=>'BTN','BV'=>'NOK','BW'=>'BWP','BY'=>'BYR',
'BZ'=>'BZD','CA'=>'CAD','CC'=>'AUD','CD'=>'CDF','CF'=>'XAF',
'CG'=>'XAF','CH'=>'CHF','CI'=>'XOF','CK'=>'NZD','CL'=>'CLF',
'CM'=>'XAF','CN'=>'CNY','CO'=>'COU','CR'=>'CRC','CS'=>'CSD',
'CU'=>'CUP','CV'=>'CVE','CX'=>'AUD','CY'=>'CYP','CZ'=>'CZK',
'DE'=>'EUR','DJ'=>'DJF','DK'=>'DKK','DM'=>'XCD','DO'=>'DOP',
'DZ'=>'DZD','EC'=>'USD','EE'=>'EEK','EG'=>'EGP','EH'=>'MAD',
'ER'=>'ERN','ES'=>'EUR','ET'=>'ETB','FI'=>'EUR','FJ'=>'FJD',
'FK'=>'FKP','FM'=>'USD','FO'=>'DKK','FR'=>'EUR','GA'=>'XAF',
'GB'=>'GBP','GD'=>'XCD','GE'=>'GEL','GF'=>'EUR','GH'=>'GHC',
'GI'=>'GIP','GL'=>'DKK','GM'=>'GMD','GN'=>'GNF','GP'=>'EUR',
'GQ'=>'XAF','GR'=>'EUR','GT'=>'GTQ','GU'=>'USD','GW'=>'XOF',
'GY'=>'GYD','HK'=>'HKD','HM'=>'AUD','HN'=>'HNL','HR'=>'HRK',
'HT'=>'USD','HU'=>'HUF','ID'=>'IDR','IE'=>'EUR','IL'=>'ILS',
'IN'=>'INR','IO'=>'USD','IQ'=>'IQD','IR'=>'IRR','IS'=>'ISK',
'IT'=>'EUR','JM'=>'JMD','JO'=>'JOD','JP'=>'JPY','KE'=>'KES',
'KG'=>'KGS','KH'=>'KHR','KI'=>'AUD','KM'=>'KMF','KN'=>'XCD',
'KP'=>'KPW','KR'=>'KRW','KW'=>'KWD','KY'=>'KYD','KZ'=>'KZT',
'LA'=>'LAK','LB'=>'LBP','LC'=>'XCD','LI'=>'CHF','LK'=>'LKR',
'LR'=>'LRD','LS'=>'LSL','LT'=>'LTL','LU'=>'EUR','LV'=>'LVL',
'LY'=>'LYD','MA'=>'MAD','MC'=>'EUR','MD'=>'MDL','MG'=>'MGF',
'MH'=>'USD','MK'=>'MKD','ML'=>'XOF','MM'=>'MMK','MN'=>'MNT',
'MO'=>'MOP','MP'=>'USD','MQ'=>'EUR','MR'=>'MRO','MS'=>'XCD',
'MT'=>'MTL','MU'=>'MUR','MV'=>'MVR','MW'=>'MWK','MX'=>'MXV',
'MY'=>'MYR','MZ'=>'MZM','NA'=>'NAD','NC'=>'XPF','NE'=>'XOF',
'NF'=>'AUD','NG'=>'NGN','NI'=>'NIO','NL'=>'EUR','NO'=>'NOK',
'NP'=>'NPR','NR'=>'AUD','NU'=>'NZD','NZ'=>'NZD','OM'=>'OMR',
'PA'=>'USD','PE'=>'PEN','PF'=>'XPF','PG'=>'PGK','PH'=>'PHP',
'PK'=>'PKR','PL'=>'PLN','PM'=>'EUR','PN'=>'NZD','PR'=>'USD',
'PT'=>'EUR','PW'=>'USD','PY'=>'PYG','QA'=>'QAR','RE'=>'EUR',
'RO'=>'ROL','RU'=>'RUB','RW'=>'RWF','SA'=>'SAR','SB'=>'SBD',
'SC'=>'SCR','SD'=>'SDD','SE'=>'SEK','SG'=>'SGD','SH'=>'SHP',
'SI'=>'SIT','SJ'=>'NOK','SK'=>'SKK','SL'=>'SLL','SM'=>'EUR',
'SN'=>'XOF','SO'=>'SOS','SR'=>'SRD','ST'=>'STD','SV'=>'USD',
'SY'=>'SYP','SZ'=>'SZL','TC'=>'USD','TD'=>'XAF','TF'=>'EUR',
'TG'=>'XOF','TH'=>'THB','TJ'=>'TJS','TK'=>'NZD','TL'=>'USD',
'TM'=>'TMM','TN'=>'TND','TO'=>'TOP','TR'=>'TRL','TT'=>'TTD',
'TV'=>'AUD','TW'=>'TWD','TZ'=>'TZS','UA'=>'UAH','UG'=>'UGX',
'UM'=>'USD','US'=>'USN','UY'=>'UYU','UZ'=>'UZS','VA'=>'EUR',
'VC'=>'XCD','VE'=>'VEB','VG'=>'USD','VI'=>'USD','VN'=>'VND',
'VU'=>'VUV','WF'=>'XPF','WS'=>'WST','YE'=>'YER','YT'=>'EUR',
'ZA'=>'ZAR','ZM'=>'ZMK','ZW'=>'ZWD');


$LANGUAGE_COUNTRY_XREF = array(
'af'=>'ZA',
'ar'=>array('SA','IQ','EG','LY','DZ','MA','TN','OM','YE','SY','JO','LB','KW','AE','BH','QA'),
'az'=>'AZ',
'be'=>'BY',
'bg'=>'BG',
'ca'=>'ES',
'cs'=>'CZ',
'da'=>'DK',
'de'=>array('DE','CH','AT','LU','LI'),
'dv'=>'MV',
'el'=>'GR',
'en'=>array('US','GB','AU','CA','NZ','IE','ZA','JM','BZ','TT','ZW','PH'),
'es'=>array('ES','MX','GT','CR','PA','DO','VE','CO','PE','AR','EC','CL','UY','PY','BO','SV','HN','NI','PR'),
'et'=>'EE',
'eu'=>'ES',
'fa'=>'IR',
'fi'=>'FI',
'fo'=>'FO',
'fr'=>array('FR','BE','CA','CH','LU','MC'),
'gl'=>'ES',
'gu'=>'IN',
'he'=>'IL',
'hi'=>'IN',
'hr'=>array('CS','SP','HR'),
'hu'=>'HU',
'hy'=>'AM',
'id'=>'ID',
'is'=>'IS',
'it'=>array('IT','CH'),
'iw'=>'IL',
'ja'=>'JP',
'ka'=>'GE',
'kk'=>'KZ',
'kn'=>'IN',
'ko'=>'KR',
'kok'=>'IN',
'ky'=>'KG',
'lt'=>'LT',
'lv'=>'LV',
'mk'=>'MK',
'mn'=>'MN',
'mr'=>'IN',
'ms'=>array('MY','BN'),
'nl'=>array('NL','BE'),
'no'=>'NO',
'pa'=>'IN',
'pl'=>'PL',
'pt'=>array('PT','BR'),
'ro'=>'RO',
'ru'=>'RU',
'sa'=>'IN',
'sk'=>'SK',
'sl'=>'SI',
'sq'=>'AL',
'sr'=>array('CS','SP','HR'),
'sv'=>array('SE','FI'),
'sw'=>'KE',
'ta'=>'IN',
'te'=>'IN',
'th'=>'TH',
'tr'=>'TR',
'tt'=>'RU',
'uk'=>'UA',
'ur'=>array('PK','IN'),
'uz'=>'UZ',
'vi'=>'VN',
'zh'=>array('TW','CN','HK','SG','MO')
);

$COUNTRY_LANGUAGE_XREF = array(
'AE'=>'ar',
'AL'=>'sq',
'AM'=>'hy',
'AR'=>'es',
'AT'=>'de',
'AU'=>'en',
'AZ'=>'az',
'BE'=>array('fr','nl'),
'BG'=>'bg',
'BH'=>'ar',
'BN'=>'ms',
'BO'=>'es',
'BR'=>'pt',
'BY'=>'be',
'BZ'=>'en',
'CA'=>array('en','fr'),
'CH'=>array('fr','de','it'),
'CL'=>'es',
'CN'=>'zh',
'CO'=>'es',
'CR'=>'es',
'CS'=>array('hr','sr'),
'CZ'=>'cs',
'DE'=>'de',
'DK'=>'da',
'DO'=>'es',
'DZ'=>'ar',
'EC'=>'es',
'EE'=>'et',
'EG'=>'ar',
'ES'=>array('es','ca','eu','gl'),
'FI'=>array('fi','sv'),
'FO'=>'fo',
'FR'=>'fr',
'GB'=>'en',
'GE'=>'ka',
'GR'=>'el',
'GT'=>'es',
'HK'=>'zh',
'HN'=>'es',
'HR'=>array('hr','sr'),
'HU'=>'hu',
'ID'=>'id',
'IE'=>'en',
'IL'=>array('he','iw'),
'IN'=>array('hi','gu','kn','kok','mr','pa','sa','ta','te','ur'),
'IQ'=>'ar',
'IR'=>'fa',
'IS'=>'is',
'IT'=>'it',
'JM'=>'en',
'JO'=>'ar',
'JP'=>'ja',
'KE'=>'sw',
'KG'=>'ky',
'KR'=>'ko',
'KW'=>'ar',
'KZ'=>'kk',
'LB'=>'ar',
'LI'=>'de',
'LT'=>'lt',
'LU'=>array('fr','de'),
'LV'=>'lv',
'LY'=>'ar',
'MA'=>'ar',
'MC'=>'fr',
'MK'=>'mk',
'MN'=>'mn',
'MO'=>'zh',
'MV'=>'dv',
'MX'=>'es',
'MY'=>'ms',
'NI'=>'es',
'NL'=>'nl',
'NO'=>'no',
'NZ'=>'en',
'OM'=>'ar',
'PA'=>'es',
'PE'=>'es',
'PH'=>'en',
'PK'=>'ur',
'PL'=>'pl',
'PR'=>'es',
'PT'=>'pt',
'PY'=>'es',
'QA'=>'ar',
'RO'=>'ro',
'RU'=>array('ru','tt'),
'SA'=>'ar',
'SE'=>'sv',
'SG'=>'zh',
'SI'=>'sl',
'SK'=>'sk',
'SP'=>array('hr','sr'),
'SV'=>'es',
'SY'=>'ar',
'TH'=>'th',
'TN'=>'ar',
'TR'=>'tr',
'TT'=>'en',
'TW'=>'zh',
'UA'=>'uk',
'US'=>'en',
'UY'=>'es',
'UZ'=>'uz',
'VE'=>'es',
'VN'=>'vi',
'YE'=>'ar',
'ZA'=>array('en','af'),
'ZW'=>'en'
);


$LANGUAGE_LOCALE_ALIAS = array('bg'=>'bg_BG','ca'=>'ca_ES','cn'=>'zh_CN',
'cs'=>'cs_CZ','cy'=>'cy_GB','da'=>'da_DK','de'=>'de_DE','el'=>'el_GR',
'en'=>'en_US','es'=>'es_ES','et'=>'et_EE','eu'=>'eu_ES','fa'=>'fa_IR',
'fi'=>'fi_FI','fo'=>'fo_FO','fr'=>'fr_FR','he'=>'he_IL','hr'=>'hr_HR',
'hu'=>'hu_HU','id'=>'id_ID','is'=>'is_IS','it'=>'it_IT','ja'=>'ja_JP',
'ko'=>'ko_KR','lt'=>'lt_LT','my'=>'ms_MY','nb'=>'nb_NO','nl'=>'nl_NL',
'pl'=>'pl_PL','pt'=>'pt_PT','ro'=>'ro_RO','ru'=>'ru_RU','sk'=>'sk_SK',
'sl'=>'sl_SI','sr'=>'sr_YU','sv'=>'sv_SE','th'=>'th_TH','tl'=>'tl_PH',
'tr'=>'tr_TR','tw'=>'zh_TW','uk'=>'uk_UA');

$DEFAULT_CHARSETS = array('ar'=>'cp1256','bg_BG'=>'cp1251',
'ca_ES'=>'iso-8859-1','cs_CZ'=>'iso-8859-2','cy_GB'=>'iso-8859-1',
'da_DK'=>'iso-8859-1','de_DE'=>'iso-8859-1','el_GR'=>'iso-8859-7',
'en_GB'=>'iso-8859-15','en_US'=>'iso-8859-1','es_ES'=>'iso-8859-1',
'et_EE'=>'iso-8859-15','eu_ES'=>'iso-8859-1','fa_IR'=>'utf-8',
'fi_FI'=>'iso-8859-1','fo_FO'=>'iso-8859-1','fr_FR'=>'iso-8859-1',
'he_IL'=>'cp1255','hr_HR'=>'iso-8859-2','hu_HU'=>'iso-8859-2',
'id_ID'=>'iso-8859-1','is_IS'=>'iso-8859-1','it_IT'=>'iso-8859-1',
'ja_JP'=>'iso-2022-jp','ko_KR'=>'euc-KR','lt_LT'=>'utf-8',
'ms_MY'=>'iso-8859-1','nb_NO'=>'iso-8859-1','nl_NL'=>'iso-8859-1',
'nn_NO'=>'iso-8859-1','pl_PL'=>'iso-8859-2','pt_BR'=>'iso-8859-1',
'pt_PT'=>'iso-8859-1','ro_RO'=>'iso-8859-2','ru_RU'=>'utf-8',
'ru_UA'=>'koi8-r','sk_SK'=>'iso-8859-2','sl_SI'=>'iso-8859-2',
'sr_YU'=>'iso-8859-2','sv_SE'=>'iso-8859-1','th_TH'=>'tis-620',
'tl_PH'=>'iso-8859-1','tr_TR'=>'iso-8859-9','uk_UA'=>'koi8-u',
'zh_CN'=>'gb2312','zh_TW'=>'big5');

$DEFAULT_SYSTEM_LOCALE = array('bg_BG'=>'bg_BG.CP1251','ca_ES'=>'ca_ES.ISO8859-1',
'cs_CZ'=>'cs_CZ.ISO8859-2','cy_GB'=>'cy_GB.ISO8859-1','da_DK'=>'da_DK.ISO8859-1',
'de_DE'=>'de_DE.ISO8859-1','el_GR'=>'el_GR.ISO8859-7','en_GB'=>'en_GB.ISO8859-15',
'en_US'=>'en_US.ISO8859-1','es_ES'=>'es_ES.ISO8859-1','et_EE'=>'et_EE.ISO8859-15',
'eu_ES'=>'eu_ES.ISO8859-1','fa_IR'=>'fa_IR.UTF-8','fi_FI'=>'fi_FI.ISO8859-1',
'fo_FO'=>'fo_FO.ISO8859-1','fr_FR'=>'fr_FR.ISO8859-1','he_IL'=>'he_IL.CP1255',
'hr_HR'=>'hr_HR.ISO8859-2','hu_HU'=>'hu_HU.ISO8859-2','id_ID'=>'id_ID.ISO8859-1',
'is_IS'=>'is_IS.ISO8859-1','it_IT'=>'it_IT.ISO8859-1','ja_JP'=>'ja_JP.EUC-JP',
'ko_KR'=>'ko_KR.EUC-KR','lt_LT'=>'lt_LT.UTF-8','ms_MY'=>'ms_MY.ISO8859-1',
'nb_NO'=>'nb_NO.ISO8859-1','nl_NL'=>'nl_NL.ISO8859-1','nn_NO'=>'nn_NO.ISO8859-1',
'pl_PL'=>'pl_PL.ISO8859-2','pt_BR'=>'pt_BR.ISO8859-1','pt_PT'=>'pt_PT.ISO8859-1',
'ro_RO'=>'ro_RO.ISO8859-2','ru_RU'=>'ru_RU.UTF-8','ru_UA'=>'ru_UA.KOI8-R',
'sk_SK'=>'sk_SK.ISO8859-2','sl_SI'=>'sl_SI.ISO8859-2','sr_YU'=>'sr_YU.ISO8859-2',
'sv_SE'=>'sv_SE.ISO8859-1','th_TH'=>'th_TH.TIS-620','tl_PH'=>'tl_PH.ISO8859-1',
'tr_TR'=>'tr_TR.ISO8859-9','uk_UA'=>'uk_UA.KOI8-U','zh_CN'=>'zh_CN.GB2312',
'zh_TW'=>'zh_TW.BIG5');

$RIGHT_TO_LEFT_LANGUAGES = array('ar','fa','he');

$VALID_SCRIPTS = array('Arab', 'Armn', 'Bali', 'Batk', 'Beng', 'Blis', 'Bopo', 'Brah', 'Brai', 'Bugi', 'Buhd', 'Cans', 'Cham', 'Cher', 'Cirt', 'Copt', 'Cprt', 'Cyrl', 'Cyrs', 'Deva', 'Dsrt', 'Egyd', 'Egyh', 'Egyp', 'Ethi', 'Geor', 'Glag', 'Goth', 'Grek', 'Gujr', 'Guru', 'Hang', 'Hani', 'Hano', 'Hans', 'Hant', 'Hebr', 'Hira', 'Hmng', 'Hrkt', 'Hung', 'Inds', 'Ital', 'Java', 'Kali', 'Kana', 'Khar', 'Khmr', 'Knda', 'Laoo', 'Latf', 'Latg', 'Latn', 'Lepc', 'Limb', 'Lina', 'Linb', 'Mand', 'Maya', 'Mero', 'Mlym', 'Mong', 'Mymr', 'Ogam', 'Orkh', 'Orya', 'Osma', 'Perm', 'Phag', 'Phnx', 'Plrd', 'Qaaa..Qabx', 'Qaai', 'Roro', 'Runr', 'Sara', 'Shaw', 'Sinh', 'Sylo', 'Syrc', 'Syre', 'Syrj', 'Syrn', 'Tagb', 'Tale', 'Talu', 'Taml', 'Telu', 'Teng', 'Tfng', 'Tglg', 'Thaa', 'Thai', 'Tibt', 'Ugar', 'Vaii', 'Visp', 'Xpeo', 'Xsux', 'Yiii', 'Zxxx', 'Zyyy', 'Zzzz');

$MEASUREMENT_SYSTEMS = array('metric','US','UK');


$LANGUAGE_CHARSETS = array(
'af'=>array('cp1252','iso_8859_15','iso_8859_1'),
'ar'=>array('iso_8859_6','cp1256'),
'be'=>array('iso_8859_5','cp1251','cp866'),
'bg'=>array('iso_8859_5','cp1251','cp866'),
'br'=>array('cp1252','iso_8859_15','iso_8859_1','iso_8859_14'),
'ca'=>array('cp1252','iso_8859_15','iso_8859_1'),
'cs'=>array('iso_8859_2','cp1250'),
'cy'=>array('cp1252','iso_8859_15','iso_8859_1','iso_8859_14'),
'da'=>array('cp1252','iso_8859_9','iso_8859_15','iso_8859_1'),
'de'=>array('cp1252','iso_8859_15','iso_8859_1'),
'el'=>array('iso_8859_7','cp1253'),
'en'=>array('cp1252','iso_8859_15','iso_8859_1'),
'eo'=>array('iso_8859_3'),
'es'=>array('cp1252','iso_8859_15','iso_8859_1'),
'et'=>array('iso_8859_4','iso_8859_10','cp1257','iso_8859_15'),
'eu'=>array('cp1252','iso_8859_15','iso_8859_1'),
'fi'=>array('cp1252','iso_8859_15','iso_8859_1'),
'fo'=>array('cp1252','iso_8859_15','iso_8859_1'),
'fr'=>array('cp1252','iso_8859_15','iso_8859_1'),
'ga'=>array('cp1252','iso_8859_15','iso_8859_1','iso_8859_14'),
'gd'=>array('cp1252','iso_8859_15','iso_8859_1','iso_8859_14'),
'gv'=>array('cp1252','iso_8859_15','iso_8859_1','iso_8859_14'),
'he'=>array('iso_8859_8','cp1255'),
'hr'=>array('iso_8859_2','cp1250'),
'hu'=>array('iso_8859_2','cp1250'),
'id'=>array('cp1252','iso_8859_15','iso_8859_1'),
'is'=>array('cp1252','iso_8859_15','iso_8859_1'),
'it'=>array('cp1252','iso_8859_15','iso_8859_1'),
'ja'=>array('euc_jp','shift_jis'),
'kl'=>array('cp1252','iso_8859_15','iso_8859_1'),
'lt'=>array('iso_8859_4','iso_8859_10','cp1257','iso_8859_13'),
'lv'=>array('iso_8859_4','iso_8859_10','cp1257','iso_8859_13'),
'mk'=>array('iso_8859_5','cp1251','cp866'),
'mt'=>array('iso_8859_3'),
'nl'=>array('cp1252','iso_8859_15','iso_8859_1'),
'no'=>array('cp1252','iso_8859_15','iso_8859_1'),
'pl'=>array('iso_8859_2','cp1250'),
'pt'=>array('cp1252','iso_8859_15','iso_8859_1'),
'ro'=>array('iso_8859_2','cp1250'),
'ru'=>array('koi8_r','iso_8859_5','cp1251','cp866','koi8_u'),
'se'=>array('iso_8859_10'),
'sk'=>array('iso_8859_2','cp1250'),
'sl'=>array('iso_8859_2','cp1250'),
'sq'=>array('iso_8859_2','cp1250','cp1252','iso_8859_15','iso_8859_1','iso_8859_9'),
'sr'=>array('iso_8859_2','cp1250','iso_8859_5','cp1251','cp866'),
'sv'=>array('cp1252','iso_8859_15','iso_8859_1'),
'sw'=>array('cp1252','iso_8859_15','iso_8859_1'),
'tr'=>array('iso_8859_9','iso_8859_3','cp1254'),
'uk'=>array('iso_8859_5','cp1251','cp866','koi8_u'),
'vi'=>array('cp1258','viscii'),
'zh'=>array('euc_tw','big5')
);



$WINDOWS_LOCALES = array(
'0x436'=>array('ZAF','AFK','Afrikaans','1252','850'),
'0x41c'=>array('ALB','SQI','Albanian','1250','852'),
'0x1401'=>array('DZA','ARG','Arabic (Algeria)','1256','720'),
'0x3c01'=>array('BHR','ARH','Arabic (Bahrain)','1256','720'),
'0xc01'=>array('EGY','ARE','Arabic (Egypt)','1256','720'),
'0x801'=>array('IRQ','ARI','Arabic (Iraq)','1256','720'),
'0x2c01'=>array('JOR','ARJ','Arabic (Jordan)','1256','720'),
'0x3401'=>array('KWT','ARK','Arabic (Kuwait)','1256','720'),
'0x3001'=>array('LBN','ARB','Arabic (Lebanon)','1256','720'),
'0x1001'=>array('LBY','ARL','Arabic (Libya)','1256','720'),
'0x1801'=>array('MAR','ARM','Arabic (Morocco)','1256','720'),
'0x2001'=>array('OMN','ARO','Arabic (Oman)','1256','720'),
'0x4001'=>array('QAT','ARQ','Arabic (Qatar)','1256','720'),
'0x401'=>array('SAU','ARA','Arabic (Saudi Arabia)','1256','720'),
'0x2801'=>array('SYR','ARS','Arabic (Syria)','1256','720'),
'0x1c01'=>array('TUN','ART','Arabic (Tunisia)','1256','720'),
'0x3801'=>array('ARE','ARU','Arabic (U.A.E.)','1256','720'),
'0x2401'=>array('YEM','ARY','Arabic (Yemen)','1256','720'),
'0x42b'=>array('ARM','HYE','Armenian','0','1'),
'0x82c'=>array('AZE','AZE','Azeri (Cyrillic)','1251','866'),
'0x42c'=>array('AZE','AZE','Azeri (Latin)','1254','857'),
'0x42d'=>array('ESP','EUQ','Basque','1252','850'),
'0x423'=>array('BLR','BEL','Belarusian','1251','866'),
'0x402'=>array('BGR','BGR','Bulgarian','1251','866'),
'0x403'=>array('ESP','CAT','Catalan','1252','850'),
'0xc04'=>array('HKG','ZHH','Chinese (Hong Kong S.A.R.)','950','950'),
'0x1404'=>array('MCO','ZHM','Chinese (Macau S.A.R.)','950','950'),
'0x804'=>array('CHN','CHS','Chinese (PRC)','936','936'),
'0x1004'=>array('SGP','ZHI','Chinese (Singapore)','936','936'),
'0x404'=>array('TWN','CHT','Chinese (Taiwan)','950','950'),
'0x41a'=>array('HRV','HRV','Croatian','1250','852'),
'0x405'=>array('CZE','CSY','Czech','1250','852'),
'0x406'=>array('DNK','DAN','Danish','1252','850'),
'0x465'=>array('MDV','DIV','Divehi','0','1'),
'0x813'=>array('BEL','NLB','Dutch (Belgium)','1252','850'),
'0x413'=>array('NLD','NLD','Dutch (Netherlands)','1252','850'),
'0xc09'=>array('AUS','ENA','English (Australia)','1252','850'),
'0x2809'=>array('BLZ','ENL','English (Belize)','1252','850'),
'0x1009'=>array('CAN','ENC','English (Canada)','1252','850'),
'0x2409'=>array('CAR','ENB','English (Caribbean)','1252','850'),
'0x1809'=>array('IRL','ENI','English (Ireland)','1252','850'),
'0x2009'=>array('JAM','ENJ','English (Jamaica)','1252','850'),
'0x1409'=>array('NZL','ENZ','English (New Zealand)','1252','850'),
'0x3409'=>array('PHL','ENP','English (Philippines)','1252','437'),
'0x1c09'=>array('ZAF','ENS','English (South Africa)','1252','437'),
'0x2c09'=>array('TTO','ENT','English (Trinidad)','1252','850'),
'0x809'=>array('GBR','ENG','English (United Kingdom)','1252','850'),
'0x409'=>array('USA','ENU','English (United States)','1252','437'),
'0x3009'=>array('ZWE','ENW','English (Zimbabwe)','1252','437'),
'0x425'=>array('EST','ETI','Estonian','1257','775'),
'0x438'=>array('FRO','FOS','Faroese','1252','850'),
'0x429'=>array('IRN','FAR','Farsi','1256','720'),
'0x40b'=>array('FIN','FIN','Finnish','1252','850'),
'0x80c'=>array('BEL','FRB','French (Belgium)','1252','850'),
'0xc0c'=>array('CAN','FRC','French (Canada)','1252','850'),
'0x40c'=>array('FRA','FRA','French (France)','1252','850'),
'0x140c'=>array('LUX','FRL','French (Luxembourg)','1252','850'),
'0x180c'=>array('MCO','FRM','French (Monaco)','1252','850'),
'0x100c'=>array('CHE','FRS','French (Switzerland)','1252','850'),
'0x42f'=>array('MKD','MKI','FYRO Macedonian','1251','866'),
'0x456'=>array('ESP','GLC','Galician','1252','850'),
'0x437'=>array('GEO','KAT','Georgian','0','1'),
'0xc07'=>array('AUT','DEA','German (Austria)','1252','850'),
'0x407'=>array('DEU','DEU','German (Germany)','1252','850'),
'0x1407'=>array('LIE','DEC','German (Liechtenstein)','1252','850'),
'0x1007'=>array('LUX','DEL','German (Luxembourg)','1252','850'),
'0x807'=>array('CHE','DES','German (Switzerland)','1252','850'),
'0x408'=>array('GRC','ELL','Greek','1253','737'),
'0x447'=>array('IND','GUJ','Gujarati','0','1'),
'0x40d'=>array('ISR','HEB','Hebrew','1255','862'),
'0x439'=>array('IND','HIN','Hindi','0','1'),
'0x40e'=>array('HUN','HUN','Hungarian','1250','852'),
'0x40f'=>array('ISL','ISL','Icelandic','1252','850'),
'0x421'=>array('IDN','IND','Indonesian','1252','850'),
'0x410'=>array('ITA','ITA','Italian (Italy)','1252','850'),
'0x810'=>array('CHE','ITS','Italian (Switzerland)','1252','850'),
'0x411'=>array('JPN','JPN','Japanese','932','932'),
'0x44b'=>array('IND','KAN','Kannada','0','1'),
'0x43f'=>array('KAZ','KKZ','Kazakh','1251','866'),
'0x457'=>array('IND','KNK','Konkani','0','1'),
'0x412'=>array('KOR','KOR','Korean','949','949'),
'0x440'=>array('KGZ','KYR','Kyrgyz (Cyrillic)','1251','866'),
'0x426'=>array('LVA','LVI','Latvian','1257','775'),
'0x427'=>array('LTU','LTH','Lithuanian','1257','775'),
'0x83e'=>array('BRN','MSB','Malay (Brunei Darussalam)','1252','850'),
'0x43e'=>array('MYS','MSL','Malay (Malaysia)','1252','850'),
'0x44e'=>array('IND','MAR','Marathi','0','1'),
'0x450'=>array('MNG','MON','Mongolian (Cyrillic)','1251','866'),
'0x414'=>array('NOR','NOR','Norwegian (Bokmal)','1252','850'),
'0x814'=>array('NOR','NON','Norwegian (Nynorsk)','1252','850'),
'0x415'=>array('POL','PLK','Polish','1250','852'),
'0x416'=>array('BRA','PTB','Portuguese (Brazil)','1252','850'),
'0x816'=>array('PRT','PTG','Portuguese (Portugal)','1252','850'),
'0x446'=>array('IND','PAN','Punjabi','0','1'),
'0x418'=>array('ROM','ROM','Romanian','1250','852'),
'0x419'=>array('RUS','RUS','Russian','1251','866'),
'0x44f'=>array('IND','SAN','Sanskrit','0','1'),
'0xc1a'=>array('SPB','SRB','Serbian (Cyrillic)','1251','855'),
'0x81a'=>array('SPB','SRL','Serbian (Latin)','1250','852'),
'0x41b'=>array('SVK','SKY','Slovak','1250','852'),
'0x424'=>array('SVN','SLV','Slovenian','1250','852'),
'0x2c0a'=>array('ARG','ESS','Spanish (Argentina)','1252','850'),
'0x400a'=>array('BOL','ESB','Spanish (Bolivia)','1252','850'),
'0x340a'=>array('CHL','ESL','Spanish (Chile)','1252','850'),
'0x240a'=>array('COL','ESO','Spanish (Colombia)','1252','850'),
'0x140a'=>array('CRI','ESC','Spanish (Costa Rica)','1252','850'),
'0x1c0a'=>array('DOM','ESD','Spanish (Dominican Republic)','1252','850'),
'0x300a'=>array('ECU','ESF','Spanish (Ecuador)','1252','850'),
'0x440a'=>array('SLV','ESE','Spanish (El Salvador)','1252','850'),
'0x100a'=>array('GTM','ESG','Spanish (Guatemala)','1252','850'),
'0x480a'=>array('HND','ESH','Spanish (Honduras)','1252','850'),
'0xc0a'=>array('ESP','ESN','Spanish (International Sort)','1252','850'),
'0x80a'=>array('MEX','ESM','Spanish (Mexico)','1252','850'),
'0x4c0a'=>array('NIC','ESI','Spanish (Nicaragua)','1252','850'),
'0x180a'=>array('PAN','ESA','Spanish (Panama)','1252','850'),
'0x3c0a'=>array('PRY','ESZ','Spanish (Paraguay)','1252','850'),
'0x280a'=>array('PER','ESR','Spanish (Peru)','1252','850'),
'0x500a'=>array('PRI','ESU','Spanish (Puerto Rico)','1252','850'),
'0x40a'=>array('ESP','ESP','Spanish (Traditional Sort)','1252','850'),
'0x380a'=>array('URY','ESY','Spanish (Uruguay)','1252','850'),
'0x200a'=>array('VEN','ESV','Spanish (Venezuela)','1252','850'),
'0x441'=>array('KEN','SWK','Swahili','1252','437'),
'0x41d'=>array('SWE','SVE','Swedish','1252','850'),
'0x81d'=>array('FIN','SVF','Swedish (Finland)','1252','850'),
'0x45a'=>array('SYR','SYR','Syriac','0','1'),
'0x449'=>array('IND','TAM','Tamil','0','1'),
'0x444'=>array('RUS','TTT','Tatar','1251','866'),
'0x44a'=>array('IND','TEL','Telugu','0','1'),
'0x41e'=>array('THA','THA','Thai','874','874'),
'0x41f'=>array('TUR','TRK','Turkish','1254','857'),
'0x422'=>array('UKR','UKR','Ukrainian','1251','866'),
'0x420'=>array('PAK','URD','Urdu','1256','720'),
'0x843'=>array('UZB','UZB','Uzbek (Cyrillic)','1251','866'),
'0x443'=>array('UZB','UZB','Uzbek (Latin)','1254','857'),
'0x42a'=>array('VNM','VIT','Vietnamese','1258','1258')
);

//Windows code => Country Code, Language Locale,  English description, code page, OEM codepage
$ISO_WINDOWS_LANGUAGE_XREF = array('af'=>'0x436','sq'=>'0x41c','am'=>'0x45e',
'ar'=>'0x401','hy'=>'0x42b','as'=>'0x44d','az'=>'0x42c','eu'=>'0x42d','bn'=>'0x445',
'bg'=>'0x402','my'=>'0x455','be'=>'0x423','km'=>'0x453','ca'=>'0x403','zh'=>'0x404',
'zh'=>'0x404','hr'=>'0x41a','cs'=>'0x405','da'=>'0x406','nl'=>'0x413','en'=>'0x409',
'et'=>'0x425','fo'=>'0x438','fa'=>'0x429','fi'=>'0x40b','fr'=>'0x40c','fy'=>'0x462',
'gl'=>'0x456','gd'=>'0x43c','ka'=>'0x437','de'=>'0x407','el'=>'0x408','gn'=>'0x474',
'gu'=>'0x447','ha'=>'0x468','he'=>'0x40d','hi'=>'0x439','hu'=>'0x40e','is'=>'0x40f',
'id'=>'0x421','iu'=>'0x45d','ga'=>'0x43c','it'=>'0x410','ja'=>'0x411','kn'=>'0x44b',
'ks'=>'0x460','kk'=>'0x43f','ky'=>'0x440','ko'=>'0x412','lo'=>'0x454','la'=>'0x476',
'lv'=>'0x426','lt'=>'0x427','mk'=>'0x42f','ms'=>'0x43e','ml'=>'0x44c','mt'=>'0x43a',
'mr'=>'0x44e','mn'=>'0x450','ne'=>'0x461','no'=>'0x414','or'=>'0x448','om'=>'0x472',
'ps'=>'0x463','pl'=>'0x415','pt'=>'0x416','pa'=>'0x446','rm'=>'0x417','ro'=>'0x418',
'ru'=>'0x419','sa'=>'0x44f','sr'=>'0x41a','sd'=>'0x459','si'=>'0x45b','sk'=>'0x41b',
'sl'=>'0x424','so'=>'0x477','es'=>'0x40a','sw'=>'0x441','sv'=>'0x41d','tl'=>'0x464',
'tg'=>'0x428','ta'=>'0x449','tt'=>'0x444','te'=>'0x44a','th'=>'0x41e','bo'=>'0x451',
'ti'=>'0x473','ts'=>'0x431','tr'=>'0x41f','tk'=>'0x442','uk'=>'0x422','ur'=>'0x420',
'uz'=>'0x443','vi'=>'0x42a','cy'=>'0x452','xh'=>'0x434','yi'=>'0x43d','yo'=>'0x46a',
'zu'=>'0x435');

$LANG_CODEPAGE_XREF = array('af'=>'cp1252','ar'=>'cp1256','az'=>'cp1254','be'=>'cp1251','bg'=>'cp1251',
'ca'=>'cp1252','cs'=>'cp1250','da'=>'cp1252','de'=>'cp1252','dv'=>'cp0','el'=>'cp1253','en'=>'cp1252',
'es'=>'cp1252','et'=>'cp1257','eu'=>'cp1252','fa'=>'cp1256','fi'=>'cp1252','fo'=>'cp1252','fr'=>'cp1252',
'gl'=>'cp1252','he'=>'cp1255','hr'=>'cp1250','hu'=>'cp1250','id'=>'cp1252','is'=>'cp1252','it'=>'cp1252',
'iw'=>'cp1255','ja'=>'cp932','kk'=>'cp1251','ko'=>'cp949','ky'=>'cp1251','lt'=>'cp1257','lv'=>'cp1257',
'mk'=>'cp1251','mn'=>'cp1251','ms'=>'cp1252','nl'=>'cp1252','no'=>'cp1252','pl'=>'cp1250','pt'=>'cp1252',
'ro'=>'cp1250','ru'=>'cp1251','sk'=>'cp1250','sl'=>'cp1250','sq'=>'cp1250','sr'=>'cp1250','sv'=>'cp1252',
'sw'=>'cp1252','th'=>'cp874','tr'=>'cp1254','tt'=>'cp1251','uk'=>'cp1251','ur'=>'cp1256','uz'=>'cp1254',
'vi'=>'cp1258','zh'=>'cp950','br'=>'cp1252','cy'=>'cp1252','eo'=>'iso-8859-3','ga'=>'cp1252',
'gd'=>'cp1252','gv'=>'cp1252','kl'=>'cp1252','mt'=>'iso-8859-3','se'=>'iso-8859-10'
);


// EZ
$aliasTable = array( 'ascii' => 'us-ascii',
'latin1' => 'iso-8859-1',
'latin2' => 'iso-8859-2',
'latin3' => 'iso-8859-3',
'latin4' => 'iso-8859-4',
'latin5' => 'iso-8859-9',
'latin6' => 'iso-8859-10',
'latin7' => 'iso-8859-13',
'latin8' => 'iso-8859-14',
'latin9' => 'iso-8859-15',
'cyrillic' => 'iso-8859-5',
'arabic' => 'iso-8859-6',
'greek' => 'iso-8859-7',
'hebrew' => 'iso-8859-8',
'thai' => 'iso-8859-11',

'koi8-r' => 'koi8-r',
'koi-8-r' => 'koi8-r',

'cp1250' => 'windows-1250',
'cp1251' => 'windows-1251',
'cp1252' => 'windows-1252',
'cp1253' => 'windows-1253',
'cp1254' => 'windows-1254',
'cp1255' => 'windows-1255',
'cp1256' => 'windows-1256',
'cp1257' => 'windows-1257',
'cp1258' => 'windows-1258',
'winlatin1' => 'windows-1252',
'winlatin2' => 'windows-1250',
'wincyrillic' => 'windows-1251',
'wingreek' => 'windows-1253',
'winturkish' => 'windows-1254',
'winhebrew' => 'windows-1255',
'winarabic' => 'windows-1256',
'winbaltic' => 'windows-1257',
'winvietnamese' => 'windows-1258',

'doslatinus' => 'cp437',
'dosgreek' => 'cp737',
'dosbaltrim' => 'cp775',
'doslatin1' => 'cp850',
'doslatin2' => 'cp852',
'doscyrillic' => 'cp855',
'dosturkish' => 'cp857',
'dosportuguese' => 'cp860',
'dosicelandic' => 'cp861',
'doshebrew' => 'cp862',
'doscanadaf' => 'cp863',
'dosarabic' => 'cp864',
'dosnordic' => 'cp865',
'dosgreek2' => 'cp869',
'doscyrillicrussian' => 'cp866',
'dosthai' => 'cp874',

'macroman' => 'macintosh',
'nextstep' => 'next',

'utf8' => 'utf-8',
'utf7' => 'utf-7',

'utf16' => 'utf-16',
'utf16be' => 'utf-16be',
'utf16le' => 'utf-16le',

'utf32' => 'utf-32',
'utf32be' => 'utf-32be',
'utf32le' => 'utf-32le',

'ucs2le' => 'ucs-2le',

'ucs4' => 'ucs-4',
'ucs4be' => 'ucs-4be',
'ucs4le' => 'ucs-4le',

'ucs2' => 'ucs-2',
'ucs2be' => 'ucs-2be',
'ucs2le' => 'ucs-2le',

'shift-jis' => 'cp932',
'gbk' => 'gbk',
'euc-cn' => 'euc-cn',
'unifiedhangul' => 'cp849',
'uhc' => 'cp849',
'big5' => 'cp850'
);
for ( $i = 1; $i <= 15; ++$i )
$aliasTable["iso8859-$i"] = "iso-8859-$i";
$aliasTable['unicode'] = 'unicode';
//EZ



$CHARSET_ALIAS = array(
'armscii8'=>'armscii_8','ascii'=>'ascii','big5hkscs'=>'big5_hkscs',
'big5'=>'big5','cp1046'=>'cp1046','cp1124'=>'cp1124','cp1125'=>'cp1125','cp1129'=>'cp1129',
'cp1133'=>'cp1133','cp1161'=>'cp1161','cp1162'=>'cp1162','cp1163'=>'cp1163','cp1250'=>'cp1250',
'cp1251'=>'cp1251','cp1252'=>'cp1252','cp1253'=>'cp1253','cp1254'=>'cp1254','cp1255'=>'cp1255',
'cp1256'=>'cp1256','cp1257'=>'cp1257','cp1258'=>'cp1258','cp437'=>'cp437','cp737'=>'cp737',
'cp775'=>'cp775','cp850'=>'cp850','cp852'=>'cp852','cp853'=>'cp853','cp855'=>'cp855','cp856'=>'cp856',
'cp857'=>'cp857','cp858'=>'cp858','cp860'=>'cp860','cp861'=>'cp861','cp862'=>'cp862','cp863'=>'cp863',
'cp864'=>'cp864','cp865'=>'cp865','cp866'=>'cp866','cp869'=>'cp869','cp874'=>'cp874','cp922'=>'cp922',
'cp932'=>'cp932','cp949'=>'cp949','cp950'=>'cp950','dechanyu'=>'dec_hanyu','deckanji'=>'dec_kanji',
'euccn'=>'euc_cn','eucjisx0213'=>'euc_jisx0213','eucjp'=>'euc_jp','euckr'=>'euc_kr','euctw'=>'euc_tw',
'gb18030'=>'gb18030','gbk'=>'gbk','georgianacademy'=>'georgian_academy','georgianps'=>'georgian_ps',
'hproman8'=>'hp_roman8','iso88591'=>'iso_8859_1','iso885910'=>'iso_8859_10','iso885913'=>'iso_8859_13',
'iso885914'=>'iso_8859_14','iso885915'=>'iso_8859_15','iso885916'=>'iso_8859_16','iso88592'=>'iso_8859_2',
'iso88593'=>'iso_8859_3','iso88594'=>'iso_8859_4','iso88595'=>'iso_8859_5','iso88596'=>'iso_8859_6',
'iso88597'=>'iso_8859_7','iso88598'=>'iso_8859_8','iso88599'=>'iso_8859_9','isoir165'=>'iso_ir_165',
'iso646cn'=>'iso646_cn','iso646jp'=>'iso646_jp','jisx0201'=>'jis_x0201','johab'=>'johab','koi8r'=>'koi8_r',
'koi8ru'=>'koi8_ru','koi8t'=>'koi8_t','koi8u'=>'koi8_u','macarabic'=>'macarabic',
'maccentraleurope'=>'maccentraleurope','maccroatian'=>'maccroatian','maccyrillic'=>'maccyrillic',
'macgreek'=>'macgreek','machebrew'=>'machebrew','maciceland'=>'maciceland','macroman'=>'macroman',
'macromania'=>'macromania','macthai'=>'macthai','macturkish'=>'macturkish','macukraine'=>'macukraine',
'mulelao1'=>'mulelao_1','nextstep'=>'nextstep','riscoslatin1'=>'riscos_latin1','shiftjis'=>'shift_jis',
'shiftjisx0213'=>'shift_jisx0213','tcvn'=>'tcvn','tds565'=>'tds565','tis620'=>'tis_620','viscii'=>'viscii'
);


//http://www.openi18n.org/subgroups/sa/locnameguide/final/CodesetAliasTable.html
$LINUX_CHARSET_EQUIVALENCE = array(
'ISO-646-US'=>array('ANSI_X3.4-1986','ISO-IR-6','ANSI_X3.4-1968','ISO_646.IRV:1991','ASCII','ISO646-US','US-ASCII','IBM367','CP367','iso-ir-6','ISO_646.irv:1991','us','cp367','csASCII'),
'TCA-BIG5'=>array('BIG5','BIG5-CP950','Big5','csBig5'),
'HKSCS-BIG5'=>array('BIG5-HKSCS','BIG5HKSCS','Big5-HKSCS'),
'EUC-JP'=>array('EUC-JP','Extended_UNIX_Code_Packed_Format_for_Japanese','csEUCPkdFmtJapanese'),
'UTF-8'=>array('UTF-8'),
'EUC-KR'=>array('EUC-KR','csEUCKR'),
'EUC-TW'=>array('EUC-TW'),
'GB-18030'=>array('GB18030'),
'GB-2312'=>array('GB2312','csGB2312'),
'GB-K'=>array('GBK'),
'ISO-8859-1'=>array('ISO-8859-1','ISO-IR-100','ISO_8859-1:1987','ISO_8859-1','LATIN1','L1','IBM819','CP819','iso-ir-100','latin1','l1','csISOLatin1'),
'ISO-8859-2'=>array('ISO-8859-2','ISO-IR-101','ISO_8859-2:1987','ISO_8859-2','LATIN2','L2','iso-ir-101','latin2','l2','csISOLatin2'),
'ISO-8859-3'=>array('ISO-8859-3','ISO-IR-109','ISO_8859-3:1988','ISO_8859-3','LATIN3','L3','iso-ir-109','latin3','l3','csISOLatin3'),
'ISO-8859-4'=>array('ISO-8859-4','ISO-IR-110','ISO_8859-4:1988','ISO_8859-4','LATIN4','L4','iso-ir-110','latin4','l4','csISOLatin4'),
'ISO-8859-5'=>array('ISO-8859-5','ISO-IR-144','ISO_8859-5:1988','ISO_8859-5','CYRILLIC','iso-ir-144','cyrillic','csISOLatinCyrillic'),
'ISO-8859-6'=>array('ISO-8859-6','ISO-IR-127','ISO_8859-6:1987','ISO_8859-6','ECMA-114','ASMO-708','ARABIC','iso-ir-127','arabic','csISOLatinArabic'),
'ISO-8859-7'=>array('ISO-8859-7','ISO-IR-126','ISO_8859-7:1987','ISO_8859-7','ELOT_928','ECMA-118','GREEK','GREEK8','iso-ir-126','greek','greek8','csISOLatinGreek'),
'ISO-8859-8'=>array('ISO-8859-8','ISO-IR-138','ISO_8859-8:1988','ISO_8859-8','HEBREW','iso-ir-138','hebrew','csISOLatinHebrew'),
'ISO-8859-9'=>array('ISO-8859-9','ISO-IR-148','ISO_8859-9:1989','ISO_8859-9','LATIN5','L5','iso-ir-148','latin5','l5','csISOLatin5'),
'ISO-8859-13'=>array('ISO-8859-13','ISO-IR-179','LATIN7','L7'),
'ISO-8859-14'=>array('ISO-8859-14','LATIN8','L8','iso-ir-199','ISO_8859-14:1998','ISO_8859-14','latin8','iso-celtic','l8'),
'ISO-8859-15'=>array('ISO-8859-15'),
'ISO-8859-16'=>array('ISO-8859-16','ISO-IR-226','LATIN10','L10'),
'KOI-8-R'=>array('KOI8-R','csKOI8R'),
'KOI-8-U'=>array('KOI8-U'),
'KOI-8-T'=>array('KOI8-T'),
'SHIFTJIS'=>array('SHIFT_JIS','SJIS','Shift_JIS','MS_Kanji','csShiftJIS'),
'VISCII'=>array('viscii'),
'CP-437'=>array('IBM437','CP437','437','cp437','csPC8CodePage437'),
'CP-850'=>array('IBM850','CP850','850','cp850','csPC850Multilingual'),
'CP-851'=>array('IBM851','CP851','851','cp851','csIBM851'),
'CP-852'=>array('IBM852','CP852','852','cp852','csPCp852'),
'CP-855'=>array('IBM855','CP855','855','cp855','csIBM855'),
'CP-857'=>array('IBM857','CP857','857','cp857','csIBM857'),
'CP-860'=>array('IBM860','CP860','860','cp860','csIBM860'),
'CP-861'=>array('IBM861','CP861','861','CP-IS','cp861','cp-is','csIBM861'),
'CP-862'=>array('IBM862','CP862','862','cp862','csPC862LatinHebrew'),
'CP-863'=>array('IBM863','CP863','863','cp863','csIBM863'),
'CP-864'=>array('IBM864','CP864','cp864','csIBM864'),
'CP-865'=>array('IBM865','CP865','865','cp865','csIBM865'),
'CP-866'=>array('IBM866','CP866','866','cp866','csIBM866'),
'CP-868'=>array('IBM868','CP868','CP-AR','cp-ar','csIBM868'),
'CP-869'=>array('IBM869','CP869','869','CP-GR','cp869','cp-gr','csIBM869'),
'CP-891'=>array('IBM891','CP891','cp891','csIBM891'),
'CP-903'=>array('IBM903','CP903','cp903','csIBM903'),
'CP-904'=>array('IBM904','CP904','904','cp904','csIBM904'),
'CP-1251'=>array('CP1251','MS-CYRL','windows-1251'),
'CP-1255'=>array('CP1255','MS-HEBR','windows-1255'),
'TIS-620'=>array('TIS-620','TIS620','TIS620-0','TIS620.2529-1','TIS620.2533-0','ISO-IR-166'),
'GEORGIAN-PS'=>array('GEORGIAN-PS')
);


$LINUX_CHARSET_EQUIVALENCE_2 = array(
'ASCII'=>array('ansix341986','isoir6','ansix341968','iso646irv:1991','ascii','iso646us','usascii','ibm367','cp367','us','csascii'),
'BIG5'=>array('big5','big5cp950','csbig5','tcabig5'),
'BIG5-HKSCS'=>array('big5hkscs','hkscsbig5'),
'EUC-JP'=>array('eucjp','extendedunixcodepackedformatforjapanese','cseucpkdfmtjapanese'),
'UTF-8'=>array('utf8'),
'EUC-KR'=>array('euckr','cseuckr'),
'EUC-TW'=>array('euctw'),
'GB-18030'=>array('gb18030','gb2312','csgb2312'),
'GB-K'=>array('gbk'),
'ISO-8859-1'=>array('iso88591','isoir100','iso88591:1987','latin1','l1','ibm819','cp819','csisolatin1'),
'ISO-8859-2'=>array('iso88592','isoir101','iso88592:1987','latin2','l2','csisolatin2'),
'ISO-8859-3'=>array('iso88593','isoir109','iso88593:1988','latin3','l3','csisolatin3'),
'ISO-8859-4'=>array('iso88594','isoir110','iso88594:1988','latin4','l4','csisolatin4'),
'ISO-8859-5'=>array('iso88595','isoir144','iso88595:1988','cyrillic','csisolatincyrillic'),
'ISO-8859-6'=>array('iso88596','isoir127','iso88596:1987','ecma114','asmo708','arabic','csisolatinarabic'),
'ISO-8859-7'=>array('iso88597','isoir126','iso88597:1987','elot928','ecma118','greek','greek8','csisolatingreek'),
'ISO-8859-8'=>array('iso88598','isoir138','iso88598:1988','hebrew','csisolatinhebrew'),
'ISO-8859-9'=>array('iso88599','isoir148','iso88599:1989','latin5','l5','csisolatin5'),
'ISO-8859-13'=>array('iso885913','isoir179','latin7','l7'),
'ISO-8859-14'=>array('iso885914','latin8','l8','isoir199','iso885914:1998','isoceltic'),
'ISO-8859-15'=>array('iso885915'),
'ISO-8859-16'=>array('iso885916','isoir226','latin10','l10'),
'KOI-8-R'=>array('koi8r','cskoi8r'),
'KOI-8-U'=>array('koi8u'),
'KOI-8-T'=>array('koi8t'),
'SHIFTJIS'=>array('shiftjis','sjis','mskanji','csshiftjis'),
'VISCII'=>array('viscii'),
'CP-437'=>array('ibm437','cp437','437','cspc8codepage437'),
'CP-850'=>array('ibm850','cp850','850','cspc850multilingual'),
'CP-852'=>array('ibm852','cp852','852','cspcp852'),
'CP-855'=>array('ibm855','cp855','855','csibm855'),
'CP-857'=>array('ibm857','cp857','857','csibm857'),
'CP-860'=>array('ibm860','cp860','860','csibm860'),
'CP-861'=>array('ibm861','cp861','861','cpis','csibm861'),
'CP-862'=>array('ibm862','cp862','862','cspc862latinhebrew'),
'CP-863'=>array('ibm863','cp863','863','csibm863'),
'CP-864'=>array('ibm864','cp864','csibm864'),
'CP-865'=>array('ibm865','cp865','865','csibm865'),
'CP-866'=>array('ibm866','cp866','866','csibm866'),
'CP-869'=>array('ibm869','cp869','869','cpgr','csibm869'),
'CP-1251'=>array('cp1251','mscyrl','windows1251'),
'CP-1255'=>array('cp1255','mshebr','windows1255'),
'TIS-620'=>array('tis620','tis6200','tis62025291','tis62025330','isoir166'),
'GEORGIAN-PS'=>array('georgianps')
);

$CHARSET_ALIAS_HELP = array('437'=>'cp437','850'=>'cp850','852'=>'cp852','855'=>'cp855','857'=>'cp857',
'860'=>'cp860','861'=>'cp861','862'=>'cp862','863'=>'cp863','865'=>'cp865','866'=>'cp866','869'=>'cp869',
'ansix341968'=>'ascii','ansix341986'=>'ascii','arabic'=>'iso88596','asmo708'=>'iso88596','big5cp950'=>'big5',
'cp367'=>'ascii','cp819'=>'iso88591','cpgr'=>'cp869','cpis'=>'cp861','csascii'=>'ascii','csbig5'=>'big5',
'cscp855'=>'cp855','cscp857'=>'cp857','cscp860'=>'cp860','cscp861'=>'cp861','cscp863'=>'cp863','cscp864'=>'cp864',
'cscp865'=>'cp865','cscp866'=>'cp866','cscp869'=>'cp869','cseuckr'=>'euckr','cseucpkdfmtjapanese'=>'eucjp',
'csgb2312'=>'gb18030','csisolatin1'=>'iso88591','csisolatin2'=>'iso88592','csisolatin3'=>'iso88593',
'csisolatin4'=>'iso88594','csisolatin5'=>'iso88599','csisolatinarabic'=>'iso88596',
'csisolatincyrillic'=>'iso88595','csisolatingreek'=>'iso88597','csisolatinhebrew'=>'iso88598','cskoi8r'=>'koi8r',
'cspc850multilingual'=>'cp850','cspc862latinhebrew'=>'cp862','cspc8codepage437'=>'cp437','cspcp852'=>'cp852',
'csshiftjis'=>'shiftjis','cyrillic'=>'iso88595','ecma114'=>'iso88596','ecma118'=>'iso88597','elot928'=>'iso88597',
'extendedunixcodepackedformatforjapanese'=>'eucjp','gb2312'=>'gb18030','greek'=>'iso88597','greek8'=>'iso88597',
'hebrew'=>'iso88598','hkscsbig5'=>'big5hkscs','iso646irv:1991'=>'ascii','iso646us'=>'ascii',
'iso885914:1998'=>'iso885914','iso88591:1987'=>'iso88591','iso88592:1987'=>'iso88592','iso88593:1988'=>'iso88593',
'iso88594:1988'=>'iso88594','iso88595:1988'=>'iso88595','iso88596:1987'=>'iso88596','iso88597:1987'=>'iso88597',
'iso88598:1988'=>'iso88598','iso88599:1989'=>'iso88599','isoceltic'=>'iso885914','isoir100'=>'iso88591',
'isoir101'=>'iso88592','isoir109'=>'iso88593','isoir110'=>'iso88594','isoir126'=>'iso88597','isoir127'=>'iso88596',
'isoir138'=>'iso88598','isoir144'=>'iso88595','isoir148'=>'iso88599','isoir166'=>'tis620','isoir179'=>'iso885913',
'isoir199'=>'iso885914','isoir226'=>'iso885916','isoir6'=>'ascii','l1'=>'iso88591','l10'=>'iso885916','l2'=>'iso88592',
'l3'=>'iso88593','l4'=>'iso88594','l5'=>'iso88599','l7'=>'iso885913','l8'=>'iso885914','latin1'=>'iso88591',
'latin10'=>'iso885916','latin2'=>'iso88592','latin3'=>'iso88593','latin4'=>'iso88594','latin5'=>'iso88599',
'latin7'=>'iso885913','latin8'=>'iso885914','mscyrl'=>'cp1251','mshebr'=>'cp1255','mskanji'=>'shiftjis',
'sjis'=>'shiftjis','tcabig5'=>'big5','tis6200'=>'tis620','tis62025291'=>'tis620','tis62025330'=>'tis620',
'us'=>'ascii','usascii'=>'ascii');

?>