<?php

/**
*@file euc_kr.php
* EUC-KR Mapping and Charset implementation.
*
*/

//
// +----------------------------------------------------------------------+
// | Akelos PHP Application Framework                                     |
// +----------------------------------------------------------------------+
// | Copyright (c) 2002-2005, Akelos Media, S.L.  http://www.akelos.org/  |
// | Released under the GNU Lesser General Public License                 |
// +----------------------------------------------------------------------+
// | You should have received the following files along with this library |
// | - COPYRIGHT (Additional copyright notice)                            |
// | - DISCLAIMER (Disclaimer of warranty)                                |
// | - README (Important information regarding this library)              |
// +----------------------------------------------------------------------+
//





/**
* EUC-KR  driver for Charset Class
*
* Charset::euc_kr provides functionality to convert
* EUC-KR strings, to UTF-8 multibyte format and vice versa.
*
* @package AKELOS
* @subpackage Localize
* @author Bermi Ferrer Martinez <bermi@akelos.org>
* @copyright Copyright (c) 2002-2005, Akelos Media, S.L. http://www.akelos.org
* @license GNU Lesser General Public License <http://www.gnu.org/copyleft/lesser.html>
* @link http://www.unicode.org/Public/MAPPINGS/ Original Mapping taken from Unicode.org
* @since 0.1
* @version $Revision 0.1 $
*/
class euc_kr extends AkCharset
{


	// ------ CLASS ATTRIBUTES ------ //



	// ---- Private attributes ---- //


	/**
	* EUC-KR to UTF-8 mapping array.
	*
	* @access private
	* @var    array    $_toUtfMap
	*/
	var $_toUtfMap = array(0=>0,1=>1,2=>2,3=>3,4=>4,5=>5,6=>6,7=>7,8=>8,9=>9,10=>10,11=>11,12=>12,13=>13,14=>14,15=>15,16=>16,17=>17,18=>18,19=>19,20=>20,21=>21,22=>22,23=>23,24=>24,25=>25,26=>26,27=>27,28=>28,29=>29,30=>30,31=>31,32=>32,33=>33,34=>34,35=>35,36=>36,37=>37,38=>38,39=>39,40=>40,41=>41,42=>42,43=>43,44=>44,45=>45,46=>46,47=>47,48=>48,49=>49,50=>50,51=>51,52=>52,53=>53,54=>54,55=>55,56=>56,57=>57,58=>58,59=>59,60=>60,61=>61,62=>62,63=>63,64=>64,65=>65,66=>66,67=>67,68=>68,69=>69,70=>70,71=>71,72=>72,73=>73,74=>74,75=>75,76=>76,77=>77,78=>78,79=>79,80=>80,81=>81,82=>82,83=>83,84=>84,85=>85,86=>86,87=>87,88=>88,89=>89,90=>90,91=>91,92=>92,93=>93,94=>94,95=>95,96=>96,97=>97,98=>98,99=>99,100=>100,101=>101,102=>102,103=>103,104=>104,105=>105,106=>106,107=>107,108=>108,109=>109,110=>110,111=>111,112=>112,113=>113,114=>114,115=>115,116=>116,117=>117,118=>118,119=>119,120=>120,121=>121,122=>122,123=>123,124=>124,125=>125,126=>126,127=>127,41377=>12288,41378=>12289,41379=>12290,41380=>183,41381=>8229,41382=>8230,41383=>168,41384=>12291,41385=>173,41386=>8213,41387=>8741,41388=>65340,41389=>8764,41390=>8216,41391=>8217,41392=>8220,41393=>8221,41394=>12308,41395=>12309,41396=>12296,41397=>12297,41398=>12298,41399=>12299,41400=>12300,41401=>12301,41402=>12302,41403=>12303,41404=>12304,41405=>12305,41406=>177,41407=>215,41408=>247,41409=>8800,41410=>8804,41411=>8805,41412=>8734,41413=>8756,41414=>176,41415=>8242,41416=>8243,41417=>8451,41418=>8491,41419=>65504,41420=>65505,41421=>65509,41422=>9794,41423=>9792,41424=>8736,41425=>8869,41426=>8978,41427=>8706,41428=>8711,41429=>8801,41430=>8786,41431=>167,41432=>8251,41433=>9734,41434=>9733,41435=>9675,41436=>9679,41437=>9678,41438=>9671,41439=>9670,41440=>9633,41441=>9632,41442=>9651,41443=>9650,41444=>9661,41445=>9660,41446=>8594,41447=>8592,41448=>8593,41449=>8595,41450=>8596,41451=>12307,41452=>8810,41453=>8811,41454=>8730,41455=>8765,41456=>8733,41457=>8757,41458=>8747,41459=>8748,41460=>8712,41461=>8715,41462=>8838,41463=>8839,41464=>8834,41465=>8835,41466=>8746,41467=>8745,41468=>8743,41469=>8744,41470=>65506,41633=>8658,41634=>8660,41635=>8704,41636=>8707,41637=>180,41638=>65374,41639=>711,41640=>728,41641=>733,41642=>730,41643=>729,41644=>184,41645=>731,41646=>161,41647=>191,41648=>720,41649=>8750,41650=>8721,41651=>8719,41652=>164,41653=>8457,41654=>8240,41655=>9665,41656=>9664,41657=>9655,41658=>9654,41659=>9828,41660=>9824,41661=>9825,41662=>9829,41663=>9831,41664=>9827,41665=>8857,41666=>9672,41667=>9635,41668=>9680,41669=>9681,41670=>9618,41671=>9636,41672=>9637,41673=>9640,41674=>9639,41675=>9638,41676=>9641,41677=>9832,41678=>9743,41679=>9742,41680=>9756,41681=>9758,41682=>182,41683=>8224,41684=>8225,41685=>8597,41686=>8599,41687=>8601,41688=>8598,41689=>8600,41690=>9837,41691=>9833,41692=>9834,41693=>9836,41694=>12927,41695=>12828,41696=>8470,41697=>13255,41698=>8482,41699=>13250,41700=>13272,41701=>8481,41702=>8364,41703=>174,41889=>65281,41890=>65282,41891=>65283,41892=>65284,41893=>65285,41894=>65286,41895=>65287,41896=>65288,41897=>65289,41898=>65290,41899=>65291,41900=>65292,41901=>65293,41902=>65294,41903=>65295,41904=>65296,41905=>65297,41906=>65298,41907=>65299,41908=>65300,41909=>65301,41910=>65302,41911=>65303,41912=>65304,41913=>65305,41914=>65306,41915=>65307,41916=>65308,41917=>65309,41918=>65310,41919=>65311,41920=>65312,41921=>65313,41922=>65314,41923=>65315,41924=>65316,41925=>65317,41926=>65318,41927=>65319,41928=>65320,41929=>65321,41930=>65322,41931=>65323,41932=>65324,41933=>65325,41934=>65326,41935=>65327,41936=>65328,41937=>65329,41938=>65330,41939=>65331,41940=>65332,41941=>65333,41942=>65334,41943=>65335,41944=>65336,41945=>65337,41946=>65338,41947=>65339,41948=>65510,41949=>65341,41950=>65342,41951=>65343,41952=>65344,41953=>65345,41954=>65346,41955=>65347,41956=>65348,41957=>65349,41958=>65350,41959=>65351,41960=>65352,41961=>65353,41962=>65354,41963=>65355,41964=>65356,41965=>65357,41966=>65358,41967=>65359,41968=>65360,41969=>65361,41970=>65362,41971=>65363,41972=>65364,41973=>65365,41974=>65366,41975=>65367,41976=>65368,41977=>65369,41978=>65370,41979=>65371,41980=>65372,41981=>65373,41982=>65507,42145=>12593,42146=>12594,42147=>12595,42148=>12596,42149=>12597,42150=>12598,42151=>12599,42152=>12600,42153=>12601,42154=>12602,42155=>12603,42156=>12604,42157=>12605,42158=>12606,42159=>12607,42160=>12608,42161=>12609,42162=>12610,42163=>12611,42164=>12612,42165=>12613,42166=>12614,42167=>12615,42168=>12616,42169=>12617,42170=>12618,42171=>12619,42172=>12620,42173=>12621,42174=>12622,42175=>12623,42176=>12624,42177=>12625,42178=>12626,42179=>12627,42180=>12628,42181=>12629,42182=>12630,42183=>12631,42184=>12632,42185=>12633,42186=>12634,42187=>12635,42188=>12636,42189=>12637,42190=>12638,42191=>12639,42192=>12640,42193=>12641,42194=>12642,42195=>12643,42196=>12644,42197=>12645,42198=>12646,42199=>12647,42200=>12648,42201=>12649,42202=>12650,42203=>12651,42204=>12652,42205=>12653,42206=>12654,42207=>12655,42208=>12656,42209=>12657,42210=>12658,42211=>12659,42212=>12660,42213=>12661,42214=>12662,42215=>12663,42216=>12664,42217=>12665,42218=>12666,42219=>12667,42220=>12668,42221=>12669,42222=>12670,42223=>12671,42224=>12672,42225=>12673,42226=>12674,42227=>12675,42228=>12676,42229=>12677,42230=>12678,42231=>12679,42232=>12680,42233=>12681,42234=>12682,42235=>12683,42236=>12684,42237=>12685,42238=>12686,42401=>8560,42402=>8561,42403=>8562,42404=>8563,42405=>8564,42406=>8565,42407=>8566,42408=>8567,42409=>8568,42410=>8569,42416=>8544,42417=>8545,42418=>8546,42419=>8547,42420=>8548,42421=>8549,42422=>8550,42423=>8551,42424=>8552,42425=>8553,42433=>913,42434=>914,42435=>915,42436=>916,42437=>917,42438=>918,42439=>919,42440=>920,42441=>921,42442=>922,42443=>923,42444=>924,42445=>925,42446=>926,42447=>927,42448=>928,42449=>929,42450=>931,42451=>932,42452=>933,42453=>934,42454=>935,42455=>936,42456=>937,42465=>945,42466=>946,42467=>947,42468=>948,42469=>949,42470=>950,42471=>951,42472=>952,42473=>953,42474=>954,42475=>955,42476=>956,42477=>957,42478=>958,42479=>959,42480=>960,42481=>961,42482=>963,42483=>964,42484=>965,42485=>966,42486=>967,42487=>968,42488=>969,42657=>9472,42658=>9474,42659=>9484,42660=>9488,42661=>9496,42662=>9492,42663=>9500,42664=>9516,42665=>9508,42666=>9524,42667=>9532,42668=>9473,42669=>9475,42670=>9487,42671=>9491,42672=>9499,42673=>9495,42674=>9507,42675=>9523,42676=>9515,42677=>9531,42678=>9547,42679=>9504,42680=>9519,42681=>9512,42682=>9527,42683=>9535,42684=>9501,42685=>9520,42686=>9509,42687=>9528,42688=>9538,42689=>9490,42690=>9489,42691=>9498,42692=>9497,42693=>9494,42694=>9493,42695=>9486,42696=>9485,42697=>9502,42698=>9503,42699=>9505,42700=>9506,42701=>9510,42702=>9511,42703=>9513,42704=>9514,42705=>9517,42706=>9518,42707=>9521,42708=>9522,42709=>9525,42710=>9526,42711=>9529,42712=>9530,42713=>9533,42714=>9534,42715=>9536,42716=>9537,42717=>9539,42718=>9540,42719=>9541,42720=>9542,42721=>9543,42722=>9544,42723=>9545,42724=>9546,42913=>13205,42914=>13206,42915=>13207,42916=>8467,42917=>13208,42918=>13252,42919=>13219,42920=>13220,42921=>13221,42922=>13222,42923=>13209,42924=>13210,42925=>13211,42926=>13212,42927=>13213,42928=>13214,42929=>13215,42930=>13216,42931=>13217,42932=>13218,42933=>13258,42934=>13197,42935=>13198,42936=>13199,42937=>13263,42938=>13192,42939=>13193,42940=>13256,42941=>13223,42942=>13224,42943=>13232,42944=>13233,42945=>13234,42946=>13235,42947=>13236,42948=>13237,42949=>13238,42950=>13239,42951=>13240,42952=>13241,42953=>13184,42954=>13185,42955=>13186,42956=>13187,42957=>13188,42958=>13242,42959=>13243,42960=>13244,42961=>13245,42962=>13246,42963=>13247,42964=>13200,42965=>13201,42966=>13202,42967=>13203,42968=>13204,42969=>8486,42970=>13248,42971=>13249,42972=>13194,42973=>13195,42974=>13196,42975=>13270,42976=>13253,42977=>13229,42978=>13230,42979=>13231,42980=>13275,42981=>13225,42982=>13226,42983=>13227,42984=>13228,42985=>13277,42986=>13264,42987=>13267,42988=>13251,42989=>13257,42990=>13276,42991=>13254,43169=>198,43170=>208,43171=>170,43172=>294,43174=>306,43176=>319,43177=>321,43178=>216,43179=>338,43180=>186,43181=>222,43182=>358,43183=>330,43185=>12896,43186=>12897,43187=>12898,43188=>12899,43189=>12900,43190=>12901,43191=>12902,43192=>12903,43193=>12904,43194=>12905,43195=>12906,43196=>12907,43197=>12908,43198=>12909,43199=>12910,43200=>12911,43201=>12912,43202=>12913,43203=>12914,43204=>12915,43205=>12916,43206=>12917,43207=>12918,43208=>12919,43209=>12920,43210=>12921,43211=>12922,43212=>12923,43213=>9424,43214=>9425,43215=>9426,43216=>9427,43217=>9428,43218=>9429,43219=>9430,43220=>9431,43221=>9432,43222=>9433,43223=>9434,43224=>9435,43225=>9436,43226=>9437,43227=>9438,43228=>9439,43229=>9440,43230=>9441,43231=>9442,43232=>9443,43233=>9444,43234=>9445,43235=>9446,43236=>9447,43237=>9448,43238=>9449,43239=>9312,43240=>9313,43241=>9314,43242=>9315,43243=>9316,43244=>9317,43245=>9318,43246=>9319,43247=>9320,43248=>9321,43249=>9322,43250=>9323,43251=>9324,43252=>9325,43253=>9326,43254=>189,43255=>8531,43256=>8532,43257=>188,43258=>190,43259=>8539,43260=>8540,43261=>8541,43262=>8542,43425=>230,43426=>273,43427=>240,43428=>295,43429=>305,43430=>307,43431=>312,43432=>320,43433=>322,43434=>248,43435=>339,43436=>223,43437=>254,43438=>359,43439=>331,43440=>329,43441=>12800,43442=>12801,43443=>12802,43444=>12803,43445=>12804,43446=>12805,43447=>12806,43448=>12807,43449=>12808,43450=>12809,43451=>12810,43452=>12811,43453=>12812,43454=>12813,43455=>12814,43456=>12815,43457=>12816,43458=>12817,43459=>12818,43460=>12819,43461=>12820,43462=>12821,43463=>12822,43464=>12823,43465=>12824,43466=>12825,43467=>12826,43468=>12827,43469=>9372,43470=>9373,43471=>9374,43472=>9375,43473=>9376,43474=>9377,43475=>9378,43476=>9379,43477=>9380,43478=>9381,43479=>9382,43480=>9383,43481=>9384,43482=>9385,43483=>9386,43484=>9387,43485=>9388,43486=>9389,43487=>9390,43488=>9391,43489=>9392,43490=>9393,43491=>9394,43492=>9395,43493=>9396,43494=>9397,43495=>9332,43496=>9333,43497=>9334,43498=>9335,43499=>9336,43500=>9337,43501=>9338,43502=>9339,43503=>9340,43504=>9341,43505=>9342,43506=>9343,43507=>9344,43508=>9345,43509=>9346,43510=>185,43511=>178,43512=>179,43513=>8308,43514=>8319,43515=>8321,43516=>8322,43517=>8323,43518=>8324,43681=>12353,43682=>12354,43683=>12355,43684=>12356,43685=>12357,43686=>12358,43687=>12359,43688=>12360,43689=>12361,43690=>12362,43691=>12363,43692=>12364,43693=>12365,43694=>12366,43695=>12367,43696=>12368,43697=>12369,43698=>12370,43699=>12371,43700=>12372,43701=>12373,43702=>12374,43703=>12375,43704=>12376,43705=>12377,43706=>12378,43707=>12379,43708=>12380,43709=>12381,43710=>12382,43711=>12383,43712=>12384,43713=>12385,43714=>12386,43715=>12387,43716=>12388,43717=>12389,43718=>12390,43719=>12391,43720=>12392,43721=>12393,43722=>12394,43723=>12395,43724=>12396,43725=>12397,43726=>12398,43727=>12399,43728=>12400,43729=>12401,43730=>12402,43731=>12403,43732=>12404,43733=>12405,43734=>12406,43735=>12407,43736=>12408,43737=>12409,43738=>12410,43739=>12411,43740=>12412,43741=>12413,43742=>12414,43743=>12415,43744=>12416,43745=>12417,43746=>12418,43747=>12419,43748=>12420,43749=>12421,43750=>12422,43751=>12423,43752=>12424,43753=>12425,43754=>12426,43755=>12427,43756=>12428,43757=>12429,43758=>12430,43759=>12431,43760=>12432,43761=>12433,43762=>12434,43763=>12435,43937=>12449,43938=>12450,43939=>12451,43940=>12452,43941=>12453,43942=>12454,43943=>12455,43944=>12456,43945=>12457,43946=>12458,43947=>12459,43948=>12460,43949=>12461,43950=>12462,43951=>12463,43952=>12464,43953=>12465,43954=>12466,43955=>12467,43956=>12468,43957=>12469,43958=>12470,43959=>12471,43960=>12472,43961=>12473,43962=>12474,43963=>12475,43964=>12476,43965=>12477,43966=>12478,43967=>12479,43968=>12480,43969=>12481,43970=>12482,43971=>12483,43972=>12484,43973=>12485,43974=>12486,43975=>12487,43976=>12488,43977=>12489,43978=>12490,43979=>12491,43980=>12492,43981=>12493,43982=>12494,43983=>12495,43984=>12496,43985=>12497,43986=>12498,43987=>12499,43988=>12500,43989=>12501,43990=>12502,43991=>12503,43992=>12504,43993=>12505,43994=>12506,43995=>12507,43996=>12508,43997=>12509,43998=>12510,43999=>12511,44000=>12512,44001=>12513,44002=>12514,44003=>12515,44004=>12516,44005=>12517,44006=>12518,44007=>12519,44008=>12520,44009=>12521,44010=>12522,44011=>12523,44012=>12524,44013=>12525,44014=>12526,44015=>12527,44016=>12528,44017=>12529,44018=>12530,44019=>12531,44020=>12532,44021=>12533,44022=>12534,44193=>1040,44194=>1041,44195=>1042,44196=>1043,44197=>1044,44198=>1045,44199=>1025,44200=>1046,44201=>1047,44202=>1048,44203=>1049,44204=>1050,44205=>1051,44206=>1052,44207=>1053,44208=>1054,44209=>1055,44210=>1056,44211=>1057,44212=>1058,44213=>1059,44214=>1060,44215=>1061,44216=>1062,44217=>1063,44218=>1064,44219=>1065,44220=>1066,44221=>1067,44222=>1068,44223=>1069,44224=>1070,44225=>1071,44241=>1072,44242=>1073,44243=>1074,44244=>1075,44245=>1076,44246=>1077,44247=>1105,44248=>1078,44249=>1079,44250=>1080,44251=>1081,44252=>1082,44253=>1083,44254=>1084,44255=>1085,44256=>1086,44257=>1087,44258=>1088,44259=>1089,44260=>1090,44261=>1091,44262=>1092,44263=>1093,44264=>1094,44265=>1095,44266=>1096,44267=>1097,44268=>1098,44269=>1099,44270=>1100,44271=>1101,44272=>1102,44273=>1103,45217=>44032,45218=>44033,45219=>44036,45220=>44039,45221=>44040,45222=>44041,45223=>44042,45224=>44048,45225=>44049,45226=>44050,45227=>44051,45228=>44052,45229=>44053,45230=>44054,45231=>44055,45232=>44057,45233=>44058,45234=>44059,45235=>44060,45236=>44061,45237=>44064,45238=>44068,45239=>44076,45240=>44077,45241=>44079,45242=>44080,45243=>44081,45244=>44088,45245=>44089,45246=>44092,45247=>44096,45248=>44107,45249=>44109,45250=>44116,45251=>44120,45252=>44124,45253=>44144,45254=>44145,45255=>44148,45256=>44151,45257=>44152,45258=>44154,45259=>44160,45260=>44161,45261=>44163,45262=>44164,45263=>44165,45264=>44166,45265=>44169,45266=>44170,45267=>44171,45268=>44172,45269=>44176,45270=>44180,45271=>44188,45272=>44189,45273=>44191,45274=>44192,45275=>44193,45276=>44200,45277=>44201,45278=>44202,45279=>44204,45280=>44207,45281=>44208,45282=>44216,45283=>44217,45284=>44219,45285=>44220,45286=>44221,45287=>44225,45288=>44228,45289=>44232,45290=>44236,45291=>44245,45292=>44247,45293=>44256,45294=>44257,45295=>44260,45296=>44263,45297=>44264,45298=>44266,45299=>44268,45300=>44271,45301=>44272,45302=>44273,45303=>44275,45304=>44277,45305=>44278,45306=>44284,45307=>44285,45308=>44288,45309=>44292,45310=>44294,45473=>44300,45474=>44301,45475=>44303,45476=>44305,45477=>44312,45478=>44316,45479=>44320,45480=>44329,45481=>44332,45482=>44333,45483=>44340,45484=>44341,45485=>44344,45486=>44348,45487=>44356,45488=>44357,45489=>44359,45490=>44361,45491=>44368,45492=>44372,45493=>44376,45494=>44385,45495=>44387,45496=>44396,45497=>44397,45498=>44400,45499=>44403,45500=>44404,45501=>44405,45502=>44406,45503=>44411,45504=>44412,45505=>44413,45506=>44415,45507=>44417,45508=>44418,45509=>44424,45510=>44425,45511=>44428,45512=>44432,45513=>44444,45514=>44445,45515=>44452,45516=>44471,45517=>44480,45518=>44481,45519=>44484,45520=>44488,45521=>44496,45522=>44497,45523=>44499,45524=>44508,45525=>44512,45526=>44516,45527=>44536,45528=>44537,45529=>44540,45530=>44543,45531=>44544,45532=>44545,45533=>44552,45534=>44553,45535=>44555,45536=>44557,45537=>44564,45538=>44592,45539=>44593,45540=>44596,45541=>44599,45542=>44600,45543=>44602,45544=>44608,45545=>44609,45546=>44611,45547=>44613,45548=>44614,45549=>44618,45550=>44620,45551=>44621,45552=>44622,45553=>44624,45554=>44628,45555=>44630,45556=>44636,45557=>44637,45558=>44639,45559=>44640,45560=>44641,45561=>44645,45562=>44648,45563=>44649,45564=>44652,45565=>44656,45566=>44664,45729=>44665,45730=>44667,45731=>44668,45732=>44669,45733=>44676,45734=>44677,45735=>44684,45736=>44732,45737=>44733,45738=>44734,45739=>44736,45740=>44740,45741=>44748,45742=>44749,45743=>44751,45744=>44752,45745=>44753,45746=>44760,45747=>44761,45748=>44764,45749=>44776,45750=>44779,45751=>44781,45752=>44788,45753=>44792,45754=>44796,45755=>44807,45756=>44808,45757=>44813,45758=>44816,45759=>44844,45760=>44845,45761=>44848,45762=>44850,45763=>44852,45764=>44860,45765=>44861,45766=>44863,45767=>44865,45768=>44866,45769=>44867,45770=>44872,45771=>44873,45772=>44880,45773=>44892,45774=>44893,45775=>44900,45776=>44901,45777=>44921,45778=>44928,45779=>44932,45780=>44936,45781=>44944,45782=>44945,45783=>44949,45784=>44956,45785=>44984,45786=>44985,45787=>44988,45788=>44992,45789=>44999,45790=>45000,45791=>45001,45792=>45003,45793=>45005,45794=>45006,45795=>45012,45796=>45020,45797=>45032,45798=>45033,45799=>45040,45800=>45041,45801=>45044,45802=>45048,45803=>45056,45804=>45057,45805=>45060,45806=>45068,45807=>45072,45808=>45076,45809=>45084,45810=>45085,45811=>45096,45812=>45124,45813=>45125,45814=>45128,45815=>45130,45816=>45132,45817=>45134,45818=>45139,45819=>45140,45820=>45141,45821=>45143,45822=>45145,45985=>45149,45986=>45180,45987=>45181,45988=>45184,45989=>45188,45990=>45196,45991=>45197,45992=>45199,45993=>45201,45994=>45208,45995=>45209,45996=>45210,45997=>45212,45998=>45215,45999=>45216,46000=>45217,46001=>45218,46002=>45224,46003=>45225,46004=>45227,46005=>45228,46006=>45229,46007=>45230,46008=>45231,46009=>45233,46010=>45235,46011=>45236,46012=>45237,46013=>45240,46014=>45244,46015=>45252,46016=>45253,46017=>45255,46018=>45256,46019=>45257,46020=>45264,46021=>45265,46022=>45268,46023=>45272,46024=>45280,46025=>45285,46026=>45320,46027=>45321,46028=>45323,46029=>45324,46030=>45328,46031=>45330,46032=>45331,46033=>45336,46034=>45337,46035=>45339,46036=>45340,46037=>45341,46038=>45347,46039=>45348,46040=>45349,46041=>45352,46042=>45356,46043=>45364,46044=>45365,46045=>45367,46046=>45368,46047=>45369,46048=>45376,46049=>45377,46050=>45380,46051=>45384,46052=>45392,46053=>45393,46054=>45396,46055=>45397,46056=>45400,46057=>45404,46058=>45408,46059=>45432,46060=>45433,46061=>45436,46062=>45440,46063=>45442,46064=>45448,46065=>45449,46066=>45451,46067=>45453,46068=>45458,46069=>45459,46070=>45460,46071=>45464,46072=>45468,46073=>45480,46074=>45516,46075=>45520,46076=>45524,46077=>45532,46078=>45533,46241=>45535,46242=>45544,46243=>45545,46244=>45548,46245=>45552,46246=>45561,46247=>45563,46248=>45565,46249=>45572,46250=>45573,46251=>45576,46252=>45579,46253=>45580,46254=>45588,46255=>45589,46256=>45591,46257=>45593,46258=>45600,46259=>45620,46260=>45628,46261=>45656,46262=>45660,46263=>45664,46264=>45672,46265=>45673,46266=>45684,46267=>45685,46268=>45692,46269=>45700,46270=>45701,46271=>45705,46272=>45712,46273=>45713,46274=>45716,46275=>45720,46276=>45721,46277=>45722,46278=>45728,46279=>45729,46280=>45731,46281=>45733,46282=>45734,46283=>45738,46284=>45740,46285=>45744,46286=>45748,46287=>45768,46288=>45769,46289=>45772,46290=>45776,46291=>45778,46292=>45784,46293=>45785,46294=>45787,46295=>45789,46296=>45794,46297=>45796,46298=>45797,46299=>45798,46300=>45800,46301=>45803,46302=>45804,46303=>45805,46304=>45806,46305=>45807,46306=>45811,46307=>45812,46308=>45813,46309=>45815,46310=>45816,46311=>45817,46312=>45818,46313=>45819,46314=>45823,46315=>45824,46316=>45825,46317=>45828,46318=>45832,46319=>45840,46320=>45841,46321=>45843,46322=>45844,46323=>45845,46324=>45852,46325=>45908,46326=>45909,46327=>45910,46328=>45912,46329=>45915,46330=>45916,46331=>45918,46332=>45919,46333=>45924,46334=>45925,46497=>45927,46498=>45929,46499=>45931,46500=>45934,46501=>45936,46502=>45937,46503=>45940,46504=>45944,46505=>45952,46506=>45953,46507=>45955,46508=>45956,46509=>45957,46510=>45964,46511=>45968,46512=>45972,46513=>45984,46514=>45985,46515=>45992,46516=>45996,46517=>46020,46518=>46021,46519=>46024,46520=>46027,46521=>46028,46522=>46030,46523=>46032,46524=>46036,46525=>46037,46526=>46039,46527=>46041,46528=>46043,46529=>46045,46530=>46048,46531=>46052,46532=>46056,46533=>46076,46534=>46096,46535=>46104,46536=>46108,46537=>46112,46538=>46120,46539=>46121,46540=>46123,46541=>46132,46542=>46160,46543=>46161,46544=>46164,46545=>46168,46546=>46176,46547=>46177,46548=>46179,46549=>46181,46550=>46188,46551=>46208,46552=>46216,46553=>46237,46554=>46244,46555=>46248,46556=>46252,46557=>46261,46558=>46263,46559=>46265,46560=>46272,46561=>46276,46562=>46280,46563=>46288,46564=>46293,46565=>46300,46566=>46301,46567=>46304,46568=>46307,46569=>46308,46570=>46310,46571=>46316,46572=>46317,46573=>46319,46574=>46321,46575=>46328,46576=>46356,46577=>46357,46578=>46360,46579=>46363,46580=>46364,46581=>46372,46582=>46373,46583=>46375,46584=>46376,46585=>46377,46586=>46378,46587=>46384,46588=>46385,46589=>46388,46590=>46392,46753=>46400,46754=>46401,46755=>46403,46756=>46404,46757=>46405,46758=>46411,46759=>46412,46760=>46413,46761=>46416,46762=>46420,46763=>46428,46764=>46429,46765=>46431,46766=>46432,46767=>46433,46768=>46496,46769=>46497,46770=>46500,46771=>46504,46772=>46506,46773=>46507,46774=>46512,46775=>46513,46776=>46515,46777=>46516,46778=>46517,46779=>46523,46780=>46524,46781=>46525,46782=>46528,46783=>46532,46784=>46540,46785=>46541,46786=>46543,46787=>46544,46788=>46545,46789=>46552,46790=>46572,46791=>46608,46792=>46609,46793=>46612,46794=>46616,46795=>46629,46796=>46636,46797=>46644,46798=>46664,46799=>46692,46800=>46696,46801=>46748,46802=>46749,46803=>46752,46804=>46756,46805=>46763,46806=>46764,46807=>46769,46808=>46804,46809=>46832,46810=>46836,46811=>46840,46812=>46848,46813=>46849,46814=>46853,46815=>46888,46816=>46889,46817=>46892,46818=>46895,46819=>46896,46820=>46904,46821=>46905,46822=>46907,46823=>46916,46824=>46920,46825=>46924,46826=>46932,46827=>46933,46828=>46944,46829=>46948,46830=>46952,46831=>46960,46832=>46961,46833=>46963,46834=>46965,46835=>46972,46836=>46973,46837=>46976,46838=>46980,46839=>46988,46840=>46989,46841=>46991,46842=>46992,46843=>46993,46844=>46994,46845=>46998,46846=>46999,47009=>47000,47010=>47001,47011=>47004,47012=>47008,47013=>47016,47014=>47017,47015=>47019,47016=>47020,47017=>47021,47018=>47028,47019=>47029,47020=>47032,47021=>47047,47022=>47049,47023=>47084,47024=>47085,47025=>47088,47026=>47092,47027=>47100,47028=>47101,47029=>47103,47030=>47104,47031=>47105,47032=>47111,47033=>47112,47034=>47113,47035=>47116,47036=>47120,47037=>47128,47038=>47129,47039=>47131,47040=>47133,47041=>47140,47042=>47141,47043=>47144,47044=>47148,47045=>47156,47046=>47157,47047=>47159,47048=>47160,47049=>47161,47050=>47168,47051=>47172,47052=>47185,47053=>47187,47054=>47196,47055=>47197,47056=>47200,47057=>47204,47058=>47212,47059=>47213,47060=>47215,47061=>47217,47062=>47224,47063=>47228,47064=>47245,47065=>47272,47066=>47280,47067=>47284,47068=>47288,47069=>47296,47070=>47297,47071=>47299,47072=>47301,47073=>47308,47074=>47312,47075=>47316,47076=>47325,47077=>47327,47078=>47329,47079=>47336,47080=>47337,47081=>47340,47082=>47344,47083=>47352,47084=>47353,47085=>47355,47086=>47357,47087=>47364,47088=>47384,47089=>47392,47090=>47420,47091=>47421,47092=>47424,47093=>47428,47094=>47436,47095=>47439,47096=>47441,47097=>47448,47098=>47449,47099=>47452,47100=>47456,47101=>47464,47102=>47465,47265=>47467,47266=>47469,47267=>47476,47268=>47477,47269=>47480,47270=>47484,47271=>47492,47272=>47493,47273=>47495,47274=>47497,47275=>47498,47276=>47501,47277=>47502,47278=>47532,47279=>47533,47280=>47536,47281=>47540,47282=>47548,47283=>47549,47284=>47551,47285=>47553,47286=>47560,47287=>47561,47288=>47564,47289=>47566,47290=>47567,47291=>47568,47292=>47569,47293=>47570,47294=>47576,47295=>47577,47296=>47579,47297=>47581,47298=>47582,47299=>47585,47300=>47587,47301=>47588,47302=>47589,47303=>47592,47304=>47596,47305=>47604,47306=>47605,47307=>47607,47308=>47608,47309=>47609,47310=>47610,47311=>47616,47312=>47617,47313=>47624,47314=>47637,47315=>47672,47316=>47673,47317=>47676,47318=>47680,47319=>47682,47320=>47688,47321=>47689,47322=>47691,47323=>47693,47324=>47694,47325=>47699,47326=>47700,47327=>47701,47328=>47704,47329=>47708,47330=>47716,47331=>47717,47332=>47719,47333=>47720,47334=>47721,47335=>47728,47336=>47729,47337=>47732,47338=>47736,47339=>47747,47340=>47748,47341=>47749,47342=>47751,47343=>47756,47344=>47784,47345=>47785,47346=>47787,47347=>47788,47348=>47792,47349=>47794,47350=>47800,47351=>47801,47352=>47803,47353=>47805,47354=>47812,47355=>47816,47356=>47832,47357=>47833,47358=>47868,47521=>47872,47522=>47876,47523=>47885,47524=>47887,47525=>47889,47526=>47896,47527=>47900,47528=>47904,47529=>47913,47530=>47915,47531=>47924,47532=>47925,47533=>47926,47534=>47928,47535=>47931,47536=>47932,47537=>47933,47538=>47934,47539=>47940,47540=>47941,47541=>47943,47542=>47945,47543=>47949,47544=>47951,47545=>47952,47546=>47956,47547=>47960,47548=>47969,47549=>47971,47550=>47980,47551=>48008,47552=>48012,47553=>48016,47554=>48036,47555=>48040,47556=>48044,47557=>48052,47558=>48055,47559=>48064,47560=>48068,47561=>48072,47562=>48080,47563=>48083,47564=>48120,47565=>48121,47566=>48124,47567=>48127,47568=>48128,47569=>48130,47570=>48136,47571=>48137,47572=>48139,47573=>48140,47574=>48141,47575=>48143,47576=>48145,47577=>48148,47578=>48149,47579=>48150,47580=>48151,47581=>48152,47582=>48155,47583=>48156,47584=>48157,47585=>48158,47586=>48159,47587=>48164,47588=>48165,47589=>48167,47590=>48169,47591=>48173,47592=>48176,47593=>48177,47594=>48180,47595=>48184,47596=>48192,47597=>48193,47598=>48195,47599=>48196,47600=>48197,47601=>48201,47602=>48204,47603=>48205,47604=>48208,47605=>48221,47606=>48260,47607=>48261,47608=>48264,47609=>48267,47610=>48268,47611=>48270,47612=>48276,47613=>48277,47614=>48279,47777=>48281,47778=>48282,47779=>48288,47780=>48289,47781=>48292,47782=>48295,47783=>48296,47784=>48304,47785=>48305,47786=>48307,47787=>48308,47788=>48309,47789=>48316,47790=>48317,47791=>48320,47792=>48324,47793=>48333,47794=>48335,47795=>48336,47796=>48337,47797=>48341,47798=>48344,47799=>48348,47800=>48372,47801=>48373,47802=>48374,47803=>48376,47804=>48380,47805=>48388,47806=>48389,47807=>48391,47808=>48393,47809=>48400,47810=>48404,47811=>48420,47812=>48428,47813=>48448,47814=>48456,47815=>48457,47816=>48460,47817=>48464,47818=>48472,47819=>48473,47820=>48484,47821=>48488,47822=>48512,47823=>48513,47824=>48516,47825=>48519,47826=>48520,47827=>48521,47828=>48522,47829=>48528,47830=>48529,47831=>48531,47832=>48533,47833=>48537,47834=>48538,47835=>48540,47836=>48548,47837=>48560,47838=>48568,47839=>48596,47840=>48597,47841=>48600,47842=>48604,47843=>48617,47844=>48624,47845=>48628,47846=>48632,47847=>48640,47848=>48643,47849=>48645,47850=>48652,47851=>48653,47852=>48656,47853=>48660,47854=>48668,47855=>48669,47856=>48671,47857=>48708,47858=>48709,47859=>48712,47860=>48716,47861=>48718,47862=>48724,47863=>48725,47864=>48727,47865=>48729,47866=>48730,47867=>48731,47868=>48736,47869=>48737,47870=>48740,48033=>48744,48034=>48746,48035=>48752,48036=>48753,48037=>48755,48038=>48756,48039=>48757,48040=>48763,48041=>48764,48042=>48765,48043=>48768,48044=>48772,48045=>48780,48046=>48781,48047=>48783,48048=>48784,48049=>48785,48050=>48792,48051=>48793,48052=>48808,48053=>48848,48054=>48849,48055=>48852,48056=>48855,48057=>48856,48058=>48864,48059=>48867,48060=>48868,48061=>48869,48062=>48876,48063=>48897,48064=>48904,48065=>48905,48066=>48920,48067=>48921,48068=>48923,48069=>48924,48070=>48925,48071=>48960,48072=>48961,48073=>48964,48074=>48968,48075=>48976,48076=>48977,48077=>48981,48078=>49044,48079=>49072,48080=>49093,48081=>49100,48082=>49101,48083=>49104,48084=>49108,48085=>49116,48086=>49119,48087=>49121,48088=>49212,48089=>49233,48090=>49240,48091=>49244,48092=>49248,48093=>49256,48094=>49257,48095=>49296,48096=>49297,48097=>49300,48098=>49304,48099=>49312,48100=>49313,48101=>49315,48102=>49317,48103=>49324,48104=>49325,48105=>49327,48106=>49328,48107=>49331,48108=>49332,48109=>49333,48110=>49334,48111=>49340,48112=>49341,48113=>49343,48114=>49344,48115=>49345,48116=>49349,48117=>49352,48118=>49353,48119=>49356,48120=>49360,48121=>49368,48122=>49369,48123=>49371,48124=>49372,48125=>49373,48126=>49380,48289=>49381,48290=>49384,48291=>49388,48292=>49396,48293=>49397,48294=>49399,48295=>49401,48296=>49408,48297=>49412,48298=>49416,48299=>49424,48300=>49429,48301=>49436,48302=>49437,48303=>49438,48304=>49439,48305=>49440,48306=>49443,48307=>49444,48308=>49446,48309=>49447,48310=>49452,48311=>49453,48312=>49455,48313=>49456,48314=>49457,48315=>49462,48316=>49464,48317=>49465,48318=>49468,48319=>49472,48320=>49480,48321=>49481,48322=>49483,48323=>49484,48324=>49485,48325=>49492,48326=>49493,48327=>49496,48328=>49500,48329=>49508,48330=>49509,48331=>49511,48332=>49512,48333=>49513,48334=>49520,48335=>49524,48336=>49528,48337=>49541,48338=>49548,48339=>49549,48340=>49550,48341=>49552,48342=>49556,48343=>49558,48344=>49564,48345=>49565,48346=>49567,48347=>49569,48348=>49573,48349=>49576,48350=>49577,48351=>49580,48352=>49584,48353=>49597,48354=>49604,48355=>49608,48356=>49612,48357=>49620,48358=>49623,48359=>49624,48360=>49632,48361=>49636,48362=>49640,48363=>49648,48364=>49649,48365=>49651,48366=>49660,48367=>49661,48368=>49664,48369=>49668,48370=>49676,48371=>49677,48372=>49679,48373=>49681,48374=>49688,48375=>49689,48376=>49692,48377=>49695,48378=>49696,48379=>49704,48380=>49705,48381=>49707,48382=>49709,48545=>49711,48546=>49713,48547=>49714,48548=>49716,48549=>49736,48550=>49744,48551=>49745,48552=>49748,48553=>49752,48554=>49760,48555=>49765,48556=>49772,48557=>49773,48558=>49776,48559=>49780,48560=>49788,48561=>49789,48562=>49791,48563=>49793,48564=>49800,48565=>49801,48566=>49808,48567=>49816,48568=>49819,48569=>49821,48570=>49828,48571=>49829,48572=>49832,48573=>49836,48574=>49837,48575=>49844,48576=>49845,48577=>49847,48578=>49849,48579=>49884,48580=>49885,48581=>49888,48582=>49891,48583=>49892,48584=>49899,48585=>49900,48586=>49901,48587=>49903,48588=>49905,48589=>49910,48590=>49912,48591=>49913,48592=>49915,48593=>49916,48594=>49920,48595=>49928,48596=>49929,48597=>49932,48598=>49933,48599=>49939,48600=>49940,48601=>49941,48602=>49944,48603=>49948,48604=>49956,48605=>49957,48606=>49960,48607=>49961,48608=>49989,48609=>50024,48610=>50025,48611=>50028,48612=>50032,48613=>50034,48614=>50040,48615=>50041,48616=>50044,48617=>50045,48618=>50052,48619=>50056,48620=>50060,48621=>50112,48622=>50136,48623=>50137,48624=>50140,48625=>50143,48626=>50144,48627=>50146,48628=>50152,48629=>50153,48630=>50157,48631=>50164,48632=>50165,48633=>50168,48634=>50184,48635=>50192,48636=>50212,48637=>50220,48638=>50224,48801=>50228,48802=>50236,48803=>50237,48804=>50248,48805=>50276,48806=>50277,48807=>50280,48808=>50284,48809=>50292,48810=>50293,48811=>50297,48812=>50304,48813=>50324,48814=>50332,48815=>50360,48816=>50364,48817=>50409,48818=>50416,48819=>50417,48820=>50420,48821=>50424,48822=>50426,48823=>50431,48824=>50432,48825=>50433,48826=>50444,48827=>50448,48828=>50452,48829=>50460,48830=>50472,48831=>50473,48832=>50476,48833=>50480,48834=>50488,48835=>50489,48836=>50491,48837=>50493,48838=>50500,48839=>50501,48840=>50504,48841=>50505,48842=>50506,48843=>50508,48844=>50509,48845=>50510,48846=>50515,48847=>50516,48848=>50517,48849=>50519,48850=>50520,48851=>50521,48852=>50525,48853=>50526,48854=>50528,48855=>50529,48856=>50532,48857=>50536,48858=>50544,48859=>50545,48860=>50547,48861=>50548,48862=>50549,48863=>50556,48864=>50557,48865=>50560,48866=>50564,48867=>50567,48868=>50572,48869=>50573,48870=>50575,48871=>50577,48872=>50581,48873=>50583,48874=>50584,48875=>50588,48876=>50592,48877=>50601,48878=>50612,48879=>50613,48880=>50616,48881=>50617,48882=>50619,48883=>50620,48884=>50621,48885=>50622,48886=>50628,48887=>50629,48888=>50630,48889=>50631,48890=>50632,48891=>50633,48892=>50634,48893=>50636,48894=>50638,49057=>50640,49058=>50641,49059=>50644,49060=>50648,49061=>50656,49062=>50657,49063=>50659,49064=>50661,49065=>50668,49066=>50669,49067=>50670,49068=>50672,49069=>50676,49070=>50678,49071=>50679,49072=>50684,49073=>50685,49074=>50686,49075=>50687,49076=>50688,49077=>50689,49078=>50693,49079=>50694,49080=>50695,49081=>50696,49082=>50700,49083=>50704,49084=>50712,49085=>50713,49086=>50715,49087=>50716,49088=>50724,49089=>50725,49090=>50728,49091=>50732,49092=>50733,49093=>50734,49094=>50736,49095=>50739,49096=>50740,49097=>50741,49098=>50743,49099=>50745,49100=>50747,49101=>50752,49102=>50753,49103=>50756,49104=>50760,49105=>50768,49106=>50769,49107=>50771,49108=>50772,49109=>50773,49110=>50780,49111=>50781,49112=>50784,49113=>50796,49114=>50799,49115=>50801,49116=>50808,49117=>50809,49118=>50812,49119=>50816,49120=>50824,49121=>50825,49122=>50827,49123=>50829,49124=>50836,49125=>50837,49126=>50840,49127=>50844,49128=>50852,49129=>50853,49130=>50855,49131=>50857,49132=>50864,49133=>50865,49134=>50868,49135=>50872,49136=>50873,49137=>50874,49138=>50880,49139=>50881,49140=>50883,49141=>50885,49142=>50892,49143=>50893,49144=>50896,49145=>50900,49146=>50908,49147=>50909,49148=>50912,49149=>50913,49150=>50920,49313=>50921,49314=>50924,49315=>50928,49316=>50936,49317=>50937,49318=>50941,49319=>50948,49320=>50949,49321=>50952,49322=>50956,49323=>50964,49324=>50965,49325=>50967,49326=>50969,49327=>50976,49328=>50977,49329=>50980,49330=>50984,49331=>50992,49332=>50993,49333=>50995,49334=>50997,49335=>50999,49336=>51004,49337=>51005,49338=>51008,49339=>51012,49340=>51018,49341=>51020,49342=>51021,49343=>51023,49344=>51025,49345=>51026,49346=>51027,49347=>51028,49348=>51029,49349=>51030,49350=>51031,49351=>51032,49352=>51036,49353=>51040,49354=>51048,49355=>51051,49356=>51060,49357=>51061,49358=>51064,49359=>51068,49360=>51069,49361=>51070,49362=>51075,49363=>51076,49364=>51077,49365=>51079,49366=>51080,49367=>51081,49368=>51082,49369=>51086,49370=>51088,49371=>51089,49372=>51092,49373=>51094,49374=>51095,49375=>51096,49376=>51098,49377=>51104,49378=>51105,49379=>51107,49380=>51108,49381=>51109,49382=>51110,49383=>51116,49384=>51117,49385=>51120,49386=>51124,49387=>51132,49388=>51133,49389=>51135,49390=>51136,49391=>51137,49392=>51144,49393=>51145,49394=>51148,49395=>51150,49396=>51152,49397=>51160,49398=>51165,49399=>51172,49400=>51176,49401=>51180,49402=>51200,49403=>51201,49404=>51204,49405=>51208,49406=>51210,49569=>51216,49570=>51217,49571=>51219,49572=>51221,49573=>51222,49574=>51228,49575=>51229,49576=>51232,49577=>51236,49578=>51244,49579=>51245,49580=>51247,49581=>51249,49582=>51256,49583=>51260,49584=>51264,49585=>51272,49586=>51273,49587=>51276,49588=>51277,49589=>51284,49590=>51312,49591=>51313,49592=>51316,49593=>51320,49594=>51322,49595=>51328,49596=>51329,49597=>51331,49598=>51333,49599=>51334,49600=>51335,49601=>51339,49602=>51340,49603=>51341,49604=>51348,49605=>51357,49606=>51359,49607=>51361,49608=>51368,49609=>51388,49610=>51389,49611=>51396,49612=>51400,49613=>51404,49614=>51412,49615=>51413,49616=>51415,49617=>51417,49618=>51424,49619=>51425,49620=>51428,49621=>51445,49622=>51452,49623=>51453,49624=>51456,49625=>51460,49626=>51461,49627=>51462,49628=>51468,49629=>51469,49630=>51471,49631=>51473,49632=>51480,49633=>51500,49634=>51508,49635=>51536,49636=>51537,49637=>51540,49638=>51544,49639=>51552,49640=>51553,49641=>51555,49642=>51564,49643=>51568,49644=>51572,49645=>51580,49646=>51592,49647=>51593,49648=>51596,49649=>51600,49650=>51608,49651=>51609,49652=>51611,49653=>51613,49654=>51648,49655=>51649,49656=>51652,49657=>51655,49658=>51656,49659=>51658,49660=>51664,49661=>51665,49662=>51667,49825=>51669,49826=>51670,49827=>51673,49828=>51674,49829=>51676,49830=>51677,49831=>51680,49832=>51682,49833=>51684,49834=>51687,49835=>51692,49836=>51693,49837=>51695,49838=>51696,49839=>51697,49840=>51704,49841=>51705,49842=>51708,49843=>51712,49844=>51720,49845=>51721,49846=>51723,49847=>51724,49848=>51725,49849=>51732,49850=>51736,49851=>51753,49852=>51788,49853=>51789,49854=>51792,49855=>51796,49856=>51804,49857=>51805,49858=>51807,49859=>51808,49860=>51809,49861=>51816,49862=>51837,49863=>51844,49864=>51864,49865=>51900,49866=>51901,49867=>51904,49868=>51908,49869=>51916,49870=>51917,49871=>51919,49872=>51921,49873=>51923,49874=>51928,49875=>51929,49876=>51936,49877=>51948,49878=>51956,49879=>51976,49880=>51984,49881=>51988,49882=>51992,49883=>52000,49884=>52001,49885=>52033,49886=>52040,49887=>52041,49888=>52044,49889=>52048,49890=>52056,49891=>52057,49892=>52061,49893=>52068,49894=>52088,49895=>52089,49896=>52124,49897=>52152,49898=>52180,49899=>52196,49900=>52199,49901=>52201,49902=>52236,49903=>52237,49904=>52240,49905=>52244,49906=>52252,49907=>52253,49908=>52257,49909=>52258,49910=>52263,49911=>52264,49912=>52265,49913=>52268,49914=>52270,49915=>52272,49916=>52280,49917=>52281,49918=>52283,50081=>52284,50082=>52285,50083=>52286,50084=>52292,50085=>52293,50086=>52296,50087=>52300,50088=>52308,50089=>52309,50090=>52311,50091=>52312,50092=>52313,50093=>52320,50094=>52324,50095=>52326,50096=>52328,50097=>52336,50098=>52341,50099=>52376,50100=>52377,50101=>52380,50102=>52384,50103=>52392,50104=>52393,50105=>52395,50106=>52396,50107=>52397,50108=>52404,50109=>52405,50110=>52408,50111=>52412,50112=>52420,50113=>52421,50114=>52423,50115=>52425,50116=>52432,50117=>52436,50118=>52452,50119=>52460,50120=>52464,50121=>52481,50122=>52488,50123=>52489,50124=>52492,50125=>52496,50126=>52504,50127=>52505,50128=>52507,50129=>52509,50130=>52516,50131=>52520,50132=>52524,50133=>52537,50134=>52572,50135=>52576,50136=>52580,50137=>52588,50138=>52589,50139=>52591,50140=>52593,50141=>52600,50142=>52616,50143=>52628,50144=>52629,50145=>52632,50146=>52636,50147=>52644,50148=>52645,50149=>52647,50150=>52649,50151=>52656,50152=>52676,50153=>52684,50154=>52688,50155=>52712,50156=>52716,50157=>52720,50158=>52728,50159=>52729,50160=>52731,50161=>52733,50162=>52740,50163=>52744,50164=>52748,50165=>52756,50166=>52761,50167=>52768,50168=>52769,50169=>52772,50170=>52776,50171=>52784,50172=>52785,50173=>52787,50174=>52789,50337=>52824,50338=>52825,50339=>52828,50340=>52831,50341=>52832,50342=>52833,50343=>52840,50344=>52841,50345=>52843,50346=>52845,50347=>52852,50348=>52853,50349=>52856,50350=>52860,50351=>52868,50352=>52869,50353=>52871,50354=>52873,50355=>52880,50356=>52881,50357=>52884,50358=>52888,50359=>52896,50360=>52897,50361=>52899,50362=>52900,50363=>52901,50364=>52908,50365=>52909,50366=>52929,50367=>52964,50368=>52965,50369=>52968,50370=>52971,50371=>52972,50372=>52980,50373=>52981,50374=>52983,50375=>52984,50376=>52985,50377=>52992,50378=>52993,50379=>52996,50380=>53000,50381=>53008,50382=>53009,50383=>53011,50384=>53013,50385=>53020,50386=>53024,50387=>53028,50388=>53036,50389=>53037,50390=>53039,50391=>53040,50392=>53041,50393=>53048,50394=>53076,50395=>53077,50396=>53080,50397=>53084,50398=>53092,50399=>53093,50400=>53095,50401=>53097,50402=>53104,50403=>53105,50404=>53108,50405=>53112,50406=>53120,50407=>53125,50408=>53132,50409=>53153,50410=>53160,50411=>53168,50412=>53188,50413=>53216,50414=>53217,50415=>53220,50416=>53224,50417=>53232,50418=>53233,50419=>53235,50420=>53237,50421=>53244,50422=>53248,50423=>53252,50424=>53265,50425=>53272,50426=>53293,50427=>53300,50428=>53301,50429=>53304,50430=>53308,50593=>53316,50594=>53317,50595=>53319,50596=>53321,50597=>53328,50598=>53332,50599=>53336,50600=>53344,50601=>53356,50602=>53357,50603=>53360,50604=>53364,50605=>53372,50606=>53373,50607=>53377,50608=>53412,50609=>53413,50610=>53416,50611=>53420,50612=>53428,50613=>53429,50614=>53431,50615=>53433,50616=>53440,50617=>53441,50618=>53444,50619=>53448,50620=>53449,50621=>53456,50622=>53457,50623=>53459,50624=>53460,50625=>53461,50626=>53468,50627=>53469,50628=>53472,50629=>53476,50630=>53484,50631=>53485,50632=>53487,50633=>53488,50634=>53489,50635=>53496,50636=>53517,50637=>53552,50638=>53553,50639=>53556,50640=>53560,50641=>53562,50642=>53568,50643=>53569,50644=>53571,50645=>53572,50646=>53573,50647=>53580,50648=>53581,50649=>53584,50650=>53588,50651=>53596,50652=>53597,50653=>53599,50654=>53601,50655=>53608,50656=>53612,50657=>53628,50658=>53636,50659=>53640,50660=>53664,50661=>53665,50662=>53668,50663=>53672,50664=>53680,50665=>53681,50666=>53683,50667=>53685,50668=>53690,50669=>53692,50670=>53696,50671=>53720,50672=>53748,50673=>53752,50674=>53767,50675=>53769,50676=>53776,50677=>53804,50678=>53805,50679=>53808,50680=>53812,50681=>53820,50682=>53821,50683=>53823,50684=>53825,50685=>53832,50686=>53852,50849=>53860,50850=>53888,50851=>53889,50852=>53892,50853=>53896,50854=>53904,50855=>53905,50856=>53909,50857=>53916,50858=>53920,50859=>53924,50860=>53932,50861=>53937,50862=>53944,50863=>53945,50864=>53948,50865=>53951,50866=>53952,50867=>53954,50868=>53960,50869=>53961,50870=>53963,50871=>53972,50872=>53976,50873=>53980,50874=>53988,50875=>53989,50876=>54000,50877=>54001,50878=>54004,50879=>54008,50880=>54016,50881=>54017,50882=>54019,50883=>54021,50884=>54028,50885=>54029,50886=>54030,50887=>54032,50888=>54036,50889=>54038,50890=>54044,50891=>54045,50892=>54047,50893=>54048,50894=>54049,50895=>54053,50896=>54056,50897=>54057,50898=>54060,50899=>54064,50900=>54072,50901=>54073,50902=>54075,50903=>54076,50904=>54077,50905=>54084,50906=>54085,50907=>54140,50908=>54141,50909=>54144,50910=>54148,50911=>54156,50912=>54157,50913=>54159,50914=>54160,50915=>54161,50916=>54168,50917=>54169,50918=>54172,50919=>54176,50920=>54184,50921=>54185,50922=>54187,50923=>54189,50924=>54196,50925=>54200,50926=>54204,50927=>54212,50928=>54213,50929=>54216,50930=>54217,50931=>54224,50932=>54232,50933=>54241,50934=>54243,50935=>54252,50936=>54253,50937=>54256,50938=>54260,50939=>54268,50940=>54269,50941=>54271,50942=>54273,51105=>54280,51106=>54301,51107=>54336,51108=>54340,51109=>54364,51110=>54368,51111=>54372,51112=>54381,51113=>54383,51114=>54392,51115=>54393,51116=>54396,51117=>54399,51118=>54400,51119=>54402,51120=>54408,51121=>54409,51122=>54411,51123=>54413,51124=>54420,51125=>54441,51126=>54476,51127=>54480,51128=>54484,51129=>54492,51130=>54495,51131=>54504,51132=>54508,51133=>54512,51134=>54520,51135=>54523,51136=>54525,51137=>54532,51138=>54536,51139=>54540,51140=>54548,51141=>54549,51142=>54551,51143=>54588,51144=>54589,51145=>54592,51146=>54596,51147=>54604,51148=>54605,51149=>54607,51150=>54609,51151=>54616,51152=>54617,51153=>54620,51154=>54624,51155=>54629,51156=>54632,51157=>54633,51158=>54635,51159=>54637,51160=>54644,51161=>54645,51162=>54648,51163=>54652,51164=>54660,51165=>54661,51166=>54663,51167=>54664,51168=>54665,51169=>54672,51170=>54693,51171=>54728,51172=>54729,51173=>54732,51174=>54736,51175=>54738,51176=>54744,51177=>54745,51178=>54747,51179=>54749,51180=>54756,51181=>54757,51182=>54760,51183=>54764,51184=>54772,51185=>54773,51186=>54775,51187=>54777,51188=>54784,51189=>54785,51190=>54788,51191=>54792,51192=>54800,51193=>54801,51194=>54803,51195=>54804,51196=>54805,51197=>54812,51198=>54816,51361=>54820,51362=>54829,51363=>54840,51364=>54841,51365=>54844,51366=>54848,51367=>54853,51368=>54856,51369=>54857,51370=>54859,51371=>54861,51372=>54865,51373=>54868,51374=>54869,51375=>54872,51376=>54876,51377=>54887,51378=>54889,51379=>54896,51380=>54897,51381=>54900,51382=>54915,51383=>54917,51384=>54924,51385=>54925,51386=>54928,51387=>54932,51388=>54941,51389=>54943,51390=>54945,51391=>54952,51392=>54956,51393=>54960,51394=>54969,51395=>54971,51396=>54980,51397=>54981,51398=>54984,51399=>54988,51400=>54993,51401=>54996,51402=>54999,51403=>55001,51404=>55008,51405=>55012,51406=>55016,51407=>55024,51408=>55029,51409=>55036,51410=>55037,51411=>55040,51412=>55044,51413=>55057,51414=>55064,51415=>55065,51416=>55068,51417=>55072,51418=>55080,51419=>55081,51420=>55083,51421=>55085,51422=>55092,51423=>55093,51424=>55096,51425=>55100,51426=>55108,51427=>55111,51428=>55113,51429=>55120,51430=>55121,51431=>55124,51432=>55126,51433=>55127,51434=>55128,51435=>55129,51436=>55136,51437=>55137,51438=>55139,51439=>55141,51440=>55145,51441=>55148,51442=>55152,51443=>55156,51444=>55164,51445=>55165,51446=>55169,51447=>55176,51448=>55177,51449=>55180,51450=>55184,51451=>55192,51452=>55193,51453=>55195,51454=>55197,51873=>20285,51874=>20339,51875=>20551,51876=>20729,51877=>21152,51878=>21487,51879=>21621,51880=>21733,51881=>22025,51882=>23233,51883=>23478,51884=>26247,51885=>26550,51886=>26551,51887=>26607,51888=>27468,51889=>29634,51890=>30146,51891=>31292,51892=>33499,51893=>33540,51894=>34903,51895=>34952,51896=>35382,51897=>36040,51898=>36303,51899=>36603,51900=>36838,51901=>39381,51902=>21051,51903=>21364,51904=>21508,51905=>24682,51906=>24932,51907=>27580,51908=>29647,51909=>33050,51910=>35258,51911=>35282,51912=>38307,51913=>20355,51914=>21002,51915=>22718,51916=>22904,51917=>23014,51918=>24178,51919=>24185,51920=>25031,51921=>25536,51922=>26438,51923=>26604,51924=>26751,51925=>28567,51926=>30286,51927=>30475,51928=>30965,51929=>31240,51930=>31487,51931=>31777,51932=>32925,51933=>33390,51934=>33393,51935=>35563,51936=>38291,51937=>20075,51938=>21917,51939=>26359,51940=>28212,51941=>30883,51942=>31469,51943=>33883,51944=>35088,51945=>34638,51946=>38824,51947=>21208,51948=>22350,51949=>22570,51950=>23884,51951=>24863,51952=>25022,51953=>25121,51954=>25954,51955=>26577,51956=>27204,51957=>28187,51958=>29976,51959=>30131,51960=>30435,51961=>30640,51962=>32058,51963=>37039,51964=>37969,51965=>37970,51966=>40853,52129=>21283,52130=>23724,52131=>30002,52132=>32987,52133=>37440,52134=>38296,52135=>21083,52136=>22536,52137=>23004,52138=>23713,52139=>23831,52140=>24247,52141=>24378,52142=>24394,52143=>24951,52144=>27743,52145=>30074,52146=>30086,52147=>31968,52148=>32115,52149=>32177,52150=>32652,52151=>33108,52152=>33313,52153=>34193,52154=>35137,52155=>35611,52156=>37628,52157=>38477,52158=>40007,52159=>20171,52160=>20215,52161=>20491,52162=>20977,52163=>22607,52164=>24887,52165=>24894,52166=>24936,52167=>25913,52168=>27114,52169=>28433,52170=>30117,52171=>30342,52172=>30422,52173=>31623,52174=>33445,52175=>33995,52176=>63744,52177=>37799,52178=>38283,52179=>21888,52180=>23458,52181=>22353,52182=>63745,52183=>31923,52184=>32697,52185=>37301,52186=>20520,52187=>21435,52188=>23621,52189=>24040,52190=>25298,52191=>25454,52192=>25818,52193=>25831,52194=>28192,52195=>28844,52196=>31067,52197=>36317,52198=>36382,52199=>63746,52200=>36989,52201=>37445,52202=>37624,52203=>20094,52204=>20214,52205=>20581,52206=>24062,52207=>24314,52208=>24838,52209=>26967,52210=>33137,52211=>34388,52212=>36423,52213=>37749,52214=>39467,52215=>20062,52216=>20625,52217=>26480,52218=>26688,52219=>20745,52220=>21133,52221=>21138,52222=>27298,52385=>30652,52386=>37392,52387=>40660,52388=>21163,52389=>24623,52390=>36850,52391=>20552,52392=>25001,52393=>25581,52394=>25802,52395=>26684,52396=>27268,52397=>28608,52398=>33160,52399=>35233,52400=>38548,52401=>22533,52402=>29309,52403=>29356,52404=>29956,52405=>32121,52406=>32365,52407=>32937,52408=>35211,52409=>35700,52410=>36963,52411=>40273,52412=>25225,52413=>27770,52414=>28500,52415=>32080,52416=>32570,52417=>35363,52418=>20860,52419=>24906,52420=>31645,52421=>35609,52422=>37463,52423=>37772,52424=>20140,52425=>20435,52426=>20510,52427=>20670,52428=>20742,52429=>21185,52430=>21197,52431=>21375,52432=>22384,52433=>22659,52434=>24218,52435=>24465,52436=>24950,52437=>25004,52438=>25806,52439=>25964,52440=>26223,52441=>26299,52442=>26356,52443=>26775,52444=>28039,52445=>28805,52446=>28913,52447=>29855,52448=>29861,52449=>29898,52450=>30169,52451=>30828,52452=>30956,52453=>31455,52454=>31478,52455=>32069,52456=>32147,52457=>32789,52458=>32831,52459=>33051,52460=>33686,52461=>35686,52462=>36629,52463=>36885,52464=>37857,52465=>38915,52466=>38968,52467=>39514,52468=>39912,52469=>20418,52470=>21843,52471=>22586,52472=>22865,52473=>23395,52474=>23622,52475=>24760,52476=>25106,52477=>26690,52478=>26800,52641=>26856,52642=>28330,52643=>30028,52644=>30328,52645=>30926,52646=>31293,52647=>31995,52648=>32363,52649=>32380,52650=>35336,52651=>35489,52652=>35903,52653=>38542,52654=>40388,52655=>21476,52656=>21481,52657=>21578,52658=>21617,52659=>22266,52660=>22993,52661=>23396,52662=>23611,52663=>24235,52664=>25335,52665=>25911,52666=>25925,52667=>25970,52668=>26272,52669=>26543,52670=>27073,52671=>27837,52672=>30204,52673=>30352,52674=>30590,52675=>31295,52676=>32660,52677=>32771,52678=>32929,52679=>33167,52680=>33510,52681=>33533,52682=>33776,52683=>34241,52684=>34865,52685=>34996,52686=>35493,52687=>63747,52688=>36764,52689=>37678,52690=>38599,52691=>39015,52692=>39640,52693=>40723,52694=>21741,52695=>26011,52696=>26354,52697=>26767,52698=>31296,52699=>35895,52700=>40288,52701=>22256,52702=>22372,52703=>23825,52704=>26118,52705=>26801,52706=>26829,52707=>28414,52708=>29736,52709=>34974,52710=>39908,52711=>27752,52712=>63748,52713=>39592,52714=>20379,52715=>20844,52716=>20849,52717=>21151,52718=>23380,52719=>24037,52720=>24656,52721=>24685,52722=>25329,52723=>25511,52724=>25915,52725=>29657,52726=>31354,52727=>34467,52728=>36002,52729=>38799,52730=>20018,52731=>23521,52732=>25096,52733=>26524,52734=>29916,52897=>31185,52898=>33747,52899=>35463,52900=>35506,52901=>36328,52902=>36942,52903=>37707,52904=>38982,52905=>24275,52906=>27112,52907=>34303,52908=>37101,52909=>63749,52910=>20896,52911=>23448,52912=>23532,52913=>24931,52914=>26874,52915=>27454,52916=>28748,52917=>29743,52918=>29912,52919=>31649,52920=>32592,52921=>33733,52922=>35264,52923=>36011,52924=>38364,52925=>39208,52926=>21038,52927=>24669,52928=>25324,52929=>36866,52930=>20362,52931=>20809,52932=>21281,52933=>22745,52934=>24291,52935=>26336,52936=>27960,52937=>28826,52938=>29378,52939=>29654,52940=>31568,52941=>33009,52942=>37979,52943=>21350,52944=>25499,52945=>32619,52946=>20054,52947=>20608,52948=>22602,52949=>22750,52950=>24618,52951=>24871,52952=>25296,52953=>27088,52954=>39745,52955=>23439,52956=>32024,52957=>32945,52958=>36703,52959=>20132,52960=>20689,52961=>21676,52962=>21932,52963=>23308,52964=>23968,52965=>24039,52966=>25898,52967=>25934,52968=>26657,52969=>27211,52970=>29409,52971=>30350,52972=>30703,52973=>32094,52974=>32761,52975=>33184,52976=>34126,52977=>34527,52978=>36611,52979=>36686,52980=>37066,52981=>39171,52982=>39509,52983=>39851,52984=>19992,52985=>20037,52986=>20061,52987=>20167,52988=>20465,52989=>20855,52990=>21246,53153=>21312,53154=>21475,53155=>21477,53156=>21646,53157=>22036,53158=>22389,53159=>22434,53160=>23495,53161=>23943,53162=>24272,53163=>25084,53164=>25304,53165=>25937,53166=>26552,53167=>26601,53168=>27083,53169=>27472,53170=>27590,53171=>27628,53172=>27714,53173=>28317,53174=>28792,53175=>29399,53176=>29590,53177=>29699,53178=>30655,53179=>30697,53180=>31350,53181=>32127,53182=>32777,53183=>33276,53184=>33285,53185=>33290,53186=>33503,53187=>34914,53188=>35635,53189=>36092,53190=>36544,53191=>36881,53192=>37041,53193=>37476,53194=>37558,53195=>39378,53196=>39493,53197=>40169,53198=>40407,53199=>40860,53200=>22283,53201=>23616,53202=>33738,53203=>38816,53204=>38827,53205=>40628,53206=>21531,53207=>31384,53208=>32676,53209=>35033,53210=>36557,53211=>37089,53212=>22528,53213=>23624,53214=>25496,53215=>31391,53216=>23470,53217=>24339,53218=>31353,53219=>31406,53220=>33422,53221=>36524,53222=>20518,53223=>21048,53224=>21240,53225=>21367,53226=>22280,53227=>25331,53228=>25458,53229=>27402,53230=>28099,53231=>30519,53232=>21413,53233=>29527,53234=>34152,53235=>36470,53236=>38357,53237=>26426,53238=>27331,53239=>28528,53240=>35437,53241=>36556,53242=>39243,53243=>63750,53244=>26231,53245=>27512,53246=>36020,53409=>39740,53410=>63751,53411=>21483,53412=>22317,53413=>22862,53414=>25542,53415=>27131,53416=>29674,53417=>30789,53418=>31418,53419=>31429,53420=>31998,53421=>33909,53422=>35215,53423=>36211,53424=>36917,53425=>38312,53426=>21243,53427=>22343,53428=>30023,53429=>31584,53430=>33740,53431=>37406,53432=>63752,53433=>27224,53434=>20811,53435=>21067,53436=>21127,53437=>25119,53438=>26840,53439=>26997,53440=>38553,53441=>20677,53442=>21156,53443=>21220,53444=>25027,53445=>26020,53446=>26681,53447=>27135,53448=>29822,53449=>31563,53450=>33465,53451=>33771,53452=>35250,53453=>35641,53454=>36817,53455=>39241,53456=>63753,53457=>20170,53458=>22935,53459=>25810,53460=>26129,53461=>27278,53462=>29748,53463=>31105,53464=>31165,53465=>33449,53466=>34942,53467=>34943,53468=>35167,53469=>63754,53470=>37670,53471=>20235,53472=>21450,53473=>24613,53474=>25201,53475=>27762,53476=>32026,53477=>32102,53478=>20120,53479=>20834,53480=>30684,53481=>32943,53482=>20225,53483=>20238,53484=>20854,53485=>20864,53486=>21980,53487=>22120,53488=>22331,53489=>22522,53490=>22524,53491=>22804,53492=>22855,53493=>22931,53494=>23492,53495=>23696,53496=>23822,53497=>24049,53498=>24190,53499=>24524,53500=>25216,53501=>26071,53502=>26083,53665=>26398,53666=>26399,53667=>26462,53668=>26827,53669=>26820,53670=>27231,53671=>27450,53672=>27683,53673=>27773,53674=>27778,53675=>28103,53676=>29592,53677=>29734,53678=>29738,53679=>29826,53680=>29859,53681=>30072,53682=>30079,53683=>30849,53684=>30959,53685=>31041,53686=>31047,53687=>31048,53688=>31098,53689=>31637,53690=>32000,53691=>32186,53692=>32648,53693=>32774,53694=>32813,53695=>32908,53696=>35352,53697=>35663,53698=>35912,53699=>36215,53700=>37665,53701=>37668,53702=>39138,53703=>39249,53704=>39438,53705=>39439,53706=>39525,53707=>40594,53708=>32202,53709=>20342,53710=>21513,53711=>25326,53712=>26708,53713=>37329,53714=>21931,53715=>20794,53716=>63755,53717=>63756,53718=>23068,53719=>25062,53720=>63757,53721=>25295,53722=>25343,53723=>63758,53724=>63759,53725=>63760,53726=>63761,53727=>63762,53728=>63763,53729=>37027,53730=>63764,53731=>63765,53732=>63766,53733=>63767,53734=>63768,53735=>35582,53736=>63769,53737=>63770,53738=>63771,53739=>63772,53740=>26262,53741=>63773,53742=>29014,53743=>63774,53744=>63775,53745=>38627,53746=>63776,53747=>25423,53748=>25466,53749=>21335,53750=>63777,53751=>26511,53752=>26976,53753=>28275,53754=>63778,53755=>30007,53756=>63779,53757=>63780,53758=>63781,53921=>32013,53922=>63782,53923=>63783,53924=>34930,53925=>22218,53926=>23064,53927=>63784,53928=>63785,53929=>63786,53930=>63787,53931=>63788,53932=>20035,53933=>63789,53934=>20839,53935=>22856,53936=>26608,53937=>32784,53938=>63790,53939=>22899,53940=>24180,53941=>25754,53942=>31178,53943=>24565,53944=>24684,53945=>25288,53946=>25467,53947=>23527,53948=>23511,53949=>21162,53950=>63791,53951=>22900,53952=>24361,53953=>24594,53954=>63792,53955=>63793,53956=>63794,53957=>29785,53958=>63795,53959=>63796,53960=>63797,53961=>63798,53962=>63799,53963=>63800,53964=>39377,53965=>63801,53966=>63802,53967=>63803,53968=>63804,53969=>63805,53970=>63806,53971=>63807,53972=>63808,53973=>63809,53974=>63810,53975=>63811,53976=>28611,53977=>63812,53978=>63813,53979=>33215,53980=>36786,53981=>24817,53982=>63814,53983=>63815,53984=>33126,53985=>63816,53986=>63817,53987=>23615,53988=>63818,53989=>63819,53990=>63820,53991=>63821,53992=>63822,53993=>63823,53994=>63824,53995=>63825,53996=>23273,53997=>35365,53998=>26491,53999=>32016,54000=>63826,54001=>63827,54002=>63828,54003=>63829,54004=>63830,54005=>63831,54006=>33021,54007=>63832,54008=>63833,54009=>23612,54010=>27877,54011=>21311,54012=>28346,54013=>22810,54014=>33590,54177=>20025,54178=>20150,54179=>20294,54180=>21934,54181=>22296,54182=>22727,54183=>24406,54184=>26039,54185=>26086,54186=>27264,54187=>27573,54188=>28237,54189=>30701,54190=>31471,54191=>31774,54192=>32222,54193=>34507,54194=>34962,54195=>37170,54196=>37723,54197=>25787,54198=>28606,54199=>29562,54200=>30136,54201=>36948,54202=>21846,54203=>22349,54204=>25018,54205=>25812,54206=>26311,54207=>28129,54208=>28251,54209=>28525,54210=>28601,54211=>30192,54212=>32835,54213=>33213,54214=>34113,54215=>35203,54216=>35527,54217=>35674,54218=>37663,54219=>27795,54220=>30035,54221=>31572,54222=>36367,54223=>36957,54224=>21776,54225=>22530,54226=>22616,54227=>24162,54228=>25095,54229=>25758,54230=>26848,54231=>30070,54232=>31958,54233=>34739,54234=>40680,54235=>20195,54236=>22408,54237=>22382,54238=>22823,54239=>23565,54240=>23729,54241=>24118,54242=>24453,54243=>25140,54244=>25825,54245=>29619,54246=>33274,54247=>34955,54248=>36024,54249=>38538,54250=>40667,54251=>23429,54252=>24503,54253=>24755,54254=>20498,54255=>20992,54256=>21040,54257=>22294,54258=>22581,54259=>22615,54260=>23566,54261=>23648,54262=>23798,54263=>23947,54264=>24230,54265=>24466,54266=>24764,54267=>25361,54268=>25481,54269=>25623,54270=>26691,54433=>26873,54434=>27330,54435=>28120,54436=>28193,54437=>28372,54438=>28644,54439=>29182,54440=>30428,54441=>30585,54442=>31153,54443=>31291,54444=>33796,54445=>35241,54446=>36077,54447=>36339,54448=>36424,54449=>36867,54450=>36884,54451=>36947,54452=>37117,54453=>37709,54454=>38518,54455=>38876,54456=>27602,54457=>28678,54458=>29272,54459=>29346,54460=>29544,54461=>30563,54462=>31167,54463=>31716,54464=>32411,54465=>35712,54466=>22697,54467=>24775,54468=>25958,54469=>26109,54470=>26302,54471=>27788,54472=>28958,54473=>29129,54474=>35930,54475=>38931,54476=>20077,54477=>31361,54478=>20189,54479=>20908,54480=>20941,54481=>21205,54482=>21516,54483=>24999,54484=>26481,54485=>26704,54486=>26847,54487=>27934,54488=>28540,54489=>30140,54490=>30643,54491=>31461,54492=>33012,54493=>33891,54494=>37509,54495=>20828,54496=>26007,54497=>26460,54498=>26515,54499=>30168,54500=>31431,54501=>33651,54502=>63834,54503=>35910,54504=>36887,54505=>38957,54506=>23663,54507=>33216,54508=>33434,54509=>36929,54510=>36975,54511=>37389,54512=>24471,54513=>23965,54514=>27225,54515=>29128,54516=>30331,54517=>31561,54518=>34276,54519=>35588,54520=>37159,54521=>39472,54522=>21895,54523=>25078,54524=>63835,54525=>30313,54526=>32645,54689=>34367,54690=>34746,54691=>35064,54692=>37007,54693=>63836,54694=>27931,54695=>28889,54696=>29662,54697=>32097,54698=>33853,54699=>63837,54700=>37226,54701=>39409,54702=>63838,54703=>20098,54704=>21365,54705=>27396,54706=>27410,54707=>28734,54708=>29211,54709=>34349,54710=>40478,54711=>21068,54712=>36771,54713=>23888,54714=>25829,54715=>25900,54716=>27414,54717=>28651,54718=>31811,54719=>32412,54720=>34253,54721=>35172,54722=>35261,54723=>25289,54724=>33240,54725=>34847,54726=>24266,54727=>26391,54728=>28010,54729=>29436,54730=>29701,54731=>29807,54732=>34690,54733=>37086,54734=>20358,54735=>23821,54736=>24480,54737=>33802,54738=>20919,54739=>25504,54740=>30053,54741=>20142,54742=>20486,54743=>20841,54744=>20937,54745=>26753,54746=>27153,54747=>31918,54748=>31921,54749=>31975,54750=>33391,54751=>35538,54752=>36635,54753=>37327,54754=>20406,54755=>20791,54756=>21237,54757=>21570,54758=>24300,54759=>24942,54760=>25150,54761=>26053,54762=>27354,54763=>28670,54764=>31018,54765=>34268,54766=>34851,54767=>38317,54768=>39522,54769=>39530,54770=>40599,54771=>40654,54772=>21147,54773=>26310,54774=>27511,54775=>28701,54776=>31019,54777=>36706,54778=>38722,54779=>24976,54780=>25088,54781=>25891,54782=>28451,54945=>29001,54946=>29833,54947=>32244,54948=>32879,54949=>34030,54950=>36646,54951=>36899,54952=>37706,54953=>20925,54954=>21015,54955=>21155,54956=>27916,54957=>28872,54958=>35010,54959=>24265,54960=>25986,54961=>27566,54962=>28610,54963=>31806,54964=>29557,54965=>20196,54966=>20278,54967=>22265,54968=>63839,54969=>23738,54970=>23994,54971=>24604,54972=>29618,54973=>31533,54974=>32666,54975=>32718,54976=>32838,54977=>36894,54978=>37428,54979=>38646,54980=>38728,54981=>38936,54982=>40801,54983=>20363,54984=>28583,54985=>31150,54986=>37300,54987=>38583,54988=>21214,54989=>63840,54990=>25736,54991=>25796,54992=>27347,54993=>28510,54994=>28696,54995=>29200,54996=>30439,54997=>32769,54998=>34310,54999=>34396,55000=>36335,55001=>36613,55002=>38706,55003=>39791,55004=>40442,55005=>40565,55006=>30860,55007=>31103,55008=>32160,55009=>33737,55010=>37636,55011=>40575,55012=>40595,55013=>35542,55014=>22751,55015=>24324,55016=>26407,55017=>28711,55018=>29903,55019=>31840,55020=>32894,55021=>20769,55022=>28712,55023=>29282,55024=>30922,55025=>36034,55026=>36058,55027=>36084,55028=>38647,55029=>20102,55030=>20698,55031=>23534,55032=>24278,55033=>26009,55034=>29134,55035=>30274,55036=>30637,55037=>32842,55038=>34044,55201=>36988,55202=>39719,55203=>40845,55204=>22744,55205=>23105,55206=>23650,55207=>27155,55208=>28122,55209=>28431,55210=>30267,55211=>32047,55212=>32311,55213=>34078,55214=>35128,55215=>37860,55216=>38475,55217=>21129,55218=>26066,55219=>26611,55220=>27060,55221=>27969,55222=>28316,55223=>28687,55224=>29705,55225=>29792,55226=>30041,55227=>30244,55228=>30827,55229=>35628,55230=>39006,55231=>20845,55232=>25134,55233=>38520,55234=>20374,55235=>20523,55236=>23833,55237=>28138,55238=>32184,55239=>36650,55240=>24459,55241=>24900,55242=>26647,55243=>63841,55244=>38534,55245=>21202,55246=>32907,55247=>20956,55248=>20940,55249=>26974,55250=>31260,55251=>32190,55252=>33777,55253=>38517,55254=>20442,55255=>21033,55256=>21400,55257=>21519,55258=>21774,55259=>23653,55260=>24743,55261=>26446,55262=>26792,55263=>28012,55264=>29313,55265=>29432,55266=>29702,55267=>29827,55268=>63842,55269=>30178,55270=>31852,55271=>32633,55272=>32696,55273=>33673,55274=>35023,55275=>35041,55276=>37324,55277=>37328,55278=>38626,55279=>39881,55280=>21533,55281=>28542,55282=>29136,55283=>29848,55284=>34298,55285=>36522,55286=>38563,55287=>40023,55288=>40607,55289=>26519,55290=>28107,55291=>29747,55292=>33256,55293=>38678,55294=>30764,55457=>31435,55458=>31520,55459=>31890,55460=>25705,55461=>29802,55462=>30194,55463=>30908,55464=>30952,55465=>39340,55466=>39764,55467=>40635,55468=>23518,55469=>24149,55470=>28448,55471=>33180,55472=>33707,55473=>37000,55474=>19975,55475=>21325,55476=>23081,55477=>24018,55478=>24398,55479=>24930,55480=>25405,55481=>26217,55482=>26364,55483=>28415,55484=>28459,55485=>28771,55486=>30622,55487=>33836,55488=>34067,55489=>34875,55490=>36627,55491=>39237,55492=>39995,55493=>21788,55494=>25273,55495=>26411,55496=>27819,55497=>33545,55498=>35178,55499=>38778,55500=>20129,55501=>22916,55502=>24536,55503=>24537,55504=>26395,55505=>32178,55506=>32596,55507=>33426,55508=>33579,55509=>33725,55510=>36638,55511=>37017,55512=>22475,55513=>22969,55514=>23186,55515=>23504,55516=>26151,55517=>26522,55518=>26757,55519=>27599,55520=>29028,55521=>32629,55522=>36023,55523=>36067,55524=>36993,55525=>39749,55526=>33032,55527=>35978,55528=>38476,55529=>39488,55530=>40613,55531=>23391,55532=>27667,55533=>29467,55534=>30450,55535=>30431,55536=>33804,55537=>20906,55538=>35219,55539=>20813,55540=>20885,55541=>21193,55542=>26825,55543=>27796,55544=>30468,55545=>30496,55546=>32191,55547=>32236,55548=>38754,55549=>40629,55550=>28357,55713=>34065,55714=>20901,55715=>21517,55716=>21629,55717=>26126,55718=>26269,55719=>26919,55720=>28319,55721=>30399,55722=>30609,55723=>33559,55724=>33986,55725=>34719,55726=>37225,55727=>37528,55728=>40180,55729=>34946,55730=>20398,55731=>20882,55732=>21215,55733=>22982,55734=>24125,55735=>24917,55736=>25720,55737=>25721,55738=>26286,55739=>26576,55740=>27169,55741=>27597,55742=>27611,55743=>29279,55744=>29281,55745=>29761,55746=>30520,55747=>30683,55748=>32791,55749=>33468,55750=>33541,55751=>35584,55752=>35624,55753=>35980,55754=>26408,55755=>27792,55756=>29287,55757=>30446,55758=>30566,55759=>31302,55760=>40361,55761=>27519,55762=>27794,55763=>22818,55764=>26406,55765=>33945,55766=>21359,55767=>22675,55768=>22937,55769=>24287,55770=>25551,55771=>26164,55772=>26483,55773=>28218,55774=>29483,55775=>31447,55776=>33495,55777=>37672,55778=>21209,55779=>24043,55780=>25006,55781=>25035,55782=>25098,55783=>25287,55784=>25771,55785=>26080,55786=>26969,55787=>27494,55788=>27595,55789=>28961,55790=>29687,55791=>30045,55792=>32326,55793=>33310,55794=>33538,55795=>34154,55796=>35491,55797=>36031,55798=>38695,55799=>40289,55800=>22696,55801=>40664,55802=>20497,55803=>21006,55804=>21563,55805=>21839,55806=>25991,55969=>27766,55970=>32010,55971=>32011,55972=>32862,55973=>34442,55974=>38272,55975=>38639,55976=>21247,55977=>27797,55978=>29289,55979=>21619,55980=>23194,55981=>23614,55982=>23883,55983=>24396,55984=>24494,55985=>26410,55986=>26806,55987=>26979,55988=>28220,55989=>28228,55990=>30473,55991=>31859,55992=>32654,55993=>34183,55994=>35598,55995=>36855,55996=>38753,55997=>40692,55998=>23735,55999=>24758,56000=>24845,56001=>25003,56002=>25935,56003=>26107,56004=>26108,56005=>27665,56006=>27887,56007=>29599,56008=>29641,56009=>32225,56010=>38292,56011=>23494,56012=>34588,56013=>35600,56014=>21085,56015=>21338,56016=>25293,56017=>25615,56018=>25778,56019=>26420,56020=>27192,56021=>27850,56022=>29632,56023=>29854,56024=>31636,56025=>31893,56026=>32283,56027=>33162,56028=>33334,56029=>34180,56030=>36843,56031=>38649,56032=>39361,56033=>20276,56034=>21322,56035=>21453,56036=>21467,56037=>25292,56038=>25644,56039=>25856,56040=>26001,56041=>27075,56042=>27886,56043=>28504,56044=>29677,56045=>30036,56046=>30242,56047=>30436,56048=>30460,56049=>30928,56050=>30971,56051=>31020,56052=>32070,56053=>33324,56054=>34784,56055=>36820,56056=>38930,56057=>39151,56058=>21187,56059=>25300,56060=>25765,56061=>28196,56062=>28497,56225=>30332,56226=>36299,56227=>37297,56228=>37474,56229=>39662,56230=>39747,56231=>20515,56232=>20621,56233=>22346,56234=>22952,56235=>23592,56236=>24135,56237=>24439,56238=>25151,56239=>25918,56240=>26041,56241=>26049,56242=>26121,56243=>26507,56244=>27036,56245=>28354,56246=>30917,56247=>32033,56248=>32938,56249=>33152,56250=>33323,56251=>33459,56252=>33953,56253=>34444,56254=>35370,56255=>35607,56256=>37030,56257=>38450,56258=>40848,56259=>20493,56260=>20467,56261=>63843,56262=>22521,56263=>24472,56264=>25308,56265=>25490,56266=>26479,56267=>28227,56268=>28953,56269=>30403,56270=>32972,56271=>32986,56272=>35060,56273=>35061,56274=>35097,56275=>36064,56276=>36649,56277=>37197,56278=>38506,56279=>20271,56280=>20336,56281=>24091,56282=>26575,56283=>26658,56284=>30333,56285=>30334,56286=>39748,56287=>24161,56288=>27146,56289=>29033,56290=>29140,56291=>30058,56292=>63844,56293=>32321,56294=>34115,56295=>34281,56296=>39132,56297=>20240,56298=>31567,56299=>32624,56300=>38309,56301=>20961,56302=>24070,56303=>26805,56304=>27710,56305=>27726,56306=>27867,56307=>29359,56308=>31684,56309=>33539,56310=>27861,56311=>29754,56312=>20731,56313=>21128,56314=>22721,56315=>25816,56316=>27287,56317=>29863,56318=>30294,56481=>30887,56482=>34327,56483=>38370,56484=>38713,56485=>63845,56486=>21342,56487=>24321,56488=>35722,56489=>36776,56490=>36783,56491=>37002,56492=>21029,56493=>30629,56494=>40009,56495=>40712,56496=>19993,56497=>20482,56498=>20853,56499=>23643,56500=>24183,56501=>26142,56502=>26170,56503=>26564,56504=>26821,56505=>28851,56506=>29953,56507=>30149,56508=>31177,56509=>31453,56510=>36647,56511=>39200,56512=>39432,56513=>20445,56514=>22561,56515=>22577,56516=>23542,56517=>26222,56518=>27493,56519=>27921,56520=>28282,56521=>28541,56522=>29668,56523=>29995,56524=>33769,56525=>35036,56526=>35091,56527=>35676,56528=>36628,56529=>20239,56530=>20693,56531=>21264,56532=>21340,56533=>23443,56534=>24489,56535=>26381,56536=>31119,56537=>33145,56538=>33583,56539=>34068,56540=>35079,56541=>35206,56542=>36665,56543=>36667,56544=>39333,56545=>39954,56546=>26412,56547=>20086,56548=>20472,56549=>22857,56550=>23553,56551=>23791,56552=>23792,56553=>25447,56554=>26834,56555=>28925,56556=>29090,56557=>29739,56558=>32299,56559=>34028,56560=>34562,56561=>36898,56562=>37586,56563=>40179,56564=>19981,56565=>20184,56566=>20463,56567=>20613,56568=>21078,56569=>21103,56570=>21542,56571=>21648,56572=>22496,56573=>22827,56574=>23142,56737=>23386,56738=>23413,56739=>23500,56740=>24220,56741=>63846,56742=>25206,56743=>25975,56744=>26023,56745=>28014,56746=>28325,56747=>29238,56748=>31526,56749=>31807,56750=>32566,56751=>33104,56752=>33105,56753=>33178,56754=>33344,56755=>33433,56756=>33705,56757=>35331,56758=>36000,56759=>36070,56760=>36091,56761=>36212,56762=>36282,56763=>37096,56764=>37340,56765=>38428,56766=>38468,56767=>39385,56768=>40167,56769=>21271,56770=>20998,56771=>21545,56772=>22132,56773=>22707,56774=>22868,56775=>22894,56776=>24575,56777=>24996,56778=>25198,56779=>26128,56780=>27774,56781=>28954,56782=>30406,56783=>31881,56784=>31966,56785=>32027,56786=>33452,56787=>36033,56788=>38640,56789=>63847,56790=>20315,56791=>24343,56792=>24447,56793=>25282,56794=>23849,56795=>26379,56796=>26842,56797=>30844,56798=>32323,56799=>40300,56800=>19989,56801=>20633,56802=>21269,56803=>21290,56804=>21329,56805=>22915,56806=>23138,56807=>24199,56808=>24754,56809=>24970,56810=>25161,56811=>25209,56812=>26000,56813=>26503,56814=>27047,56815=>27604,56816=>27606,56817=>27607,56818=>27608,56819=>27832,56820=>63848,56821=>29749,56822=>30202,56823=>30738,56824=>30865,56825=>31189,56826=>31192,56827=>31875,56828=>32203,56829=>32737,56830=>32933,56993=>33086,56994=>33218,56995=>33778,56996=>34586,56997=>35048,56998=>35513,56999=>35692,57000=>36027,57001=>37145,57002=>38750,57003=>39131,57004=>40763,57005=>22188,57006=>23338,57007=>24428,57008=>25996,57009=>27315,57010=>27567,57011=>27996,57012=>28657,57013=>28693,57014=>29277,57015=>29613,57016=>36007,57017=>36051,57018=>38971,57019=>24977,57020=>27703,57021=>32856,57022=>39425,57023=>20045,57024=>20107,57025=>20123,57026=>20181,57027=>20282,57028=>20284,57029=>20351,57030=>20447,57031=>20735,57032=>21490,57033=>21496,57034=>21766,57035=>21987,57036=>22235,57037=>22763,57038=>22882,57039=>23057,57040=>23531,57041=>23546,57042=>23556,57043=>24051,57044=>24107,57045=>24473,57046=>24605,57047=>25448,57048=>26012,57049=>26031,57050=>26614,57051=>26619,57052=>26797,57053=>27515,57054=>27801,57055=>27863,57056=>28195,57057=>28681,57058=>29509,57059=>30722,57060=>31038,57061=>31040,57062=>31072,57063=>31169,57064=>31721,57065=>32023,57066=>32114,57067=>32902,57068=>33293,57069=>33678,57070=>34001,57071=>34503,57072=>35039,57073=>35408,57074=>35422,57075=>35613,57076=>36060,57077=>36198,57078=>36781,57079=>37034,57080=>39164,57081=>39391,57082=>40605,57083=>21066,57084=>63849,57085=>26388,57086=>63850,57249=>20632,57250=>21034,57251=>23665,57252=>25955,57253=>27733,57254=>29642,57255=>29987,57256=>30109,57257=>31639,57258=>33948,57259=>37240,57260=>38704,57261=>20087,57262=>25746,57263=>27578,57264=>29022,57265=>34217,57266=>19977,57267=>63851,57268=>26441,57269=>26862,57270=>28183,57271=>33439,57272=>34072,57273=>34923,57274=>25591,57275=>28545,57276=>37394,57277=>39087,57278=>19978,57279=>20663,57280=>20687,57281=>20767,57282=>21830,57283=>21930,57284=>22039,57285=>23360,57286=>23577,57287=>23776,57288=>24120,57289=>24202,57290=>24224,57291=>24258,57292=>24819,57293=>26705,57294=>27233,57295=>28248,57296=>29245,57297=>29248,57298=>29376,57299=>30456,57300=>31077,57301=>31665,57302=>32724,57303=>35059,57304=>35316,57305=>35443,57306=>35937,57307=>36062,57308=>38684,57309=>22622,57310=>29885,57311=>36093,57312=>21959,57313=>63852,57314=>31329,57315=>32034,57316=>33394,57317=>29298,57318=>29983,57319=>29989,57320=>63853,57321=>31513,57322=>22661,57323=>22779,57324=>23996,57325=>24207,57326=>24246,57327=>24464,57328=>24661,57329=>25234,57330=>25471,57331=>25933,57332=>26257,57333=>26329,57334=>26360,57335=>26646,57336=>26866,57337=>29312,57338=>29790,57339=>31598,57340=>32110,57341=>32214,57342=>32626,57505=>32997,57506=>33298,57507=>34223,57508=>35199,57509=>35475,57510=>36893,57511=>37604,57512=>40653,57513=>40736,57514=>22805,57515=>22893,57516=>24109,57517=>24796,57518=>26132,57519=>26227,57520=>26512,57521=>27728,57522=>28101,57523=>28511,57524=>30707,57525=>30889,57526=>33990,57527=>37323,57528=>37675,57529=>20185,57530=>20682,57531=>20808,57532=>21892,57533=>23307,57534=>23459,57535=>25159,57536=>25982,57537=>26059,57538=>28210,57539=>29053,57540=>29697,57541=>29764,57542=>29831,57543=>29887,57544=>30316,57545=>31146,57546=>32218,57547=>32341,57548=>32680,57549=>33146,57550=>33203,57551=>33337,57552=>34330,57553=>34796,57554=>35445,57555=>36323,57556=>36984,57557=>37521,57558=>37925,57559=>39245,57560=>39854,57561=>21352,57562=>23633,57563=>26964,57564=>27844,57565=>27945,57566=>28203,57567=>33292,57568=>34203,57569=>35131,57570=>35373,57571=>35498,57572=>38634,57573=>40807,57574=>21089,57575=>26297,57576=>27570,57577=>32406,57578=>34814,57579=>36109,57580=>38275,57581=>38493,57582=>25885,57583=>28041,57584=>29166,57585=>63854,57586=>22478,57587=>22995,57588=>23468,57589=>24615,57590=>24826,57591=>25104,57592=>26143,57593=>26207,57594=>29481,57595=>29689,57596=>30427,57597=>30465,57598=>31596,57761=>32854,57762=>32882,57763=>33125,57764=>35488,57765=>37266,57766=>19990,57767=>21218,57768=>27506,57769=>27927,57770=>31237,57771=>31545,57772=>32048,57773=>63855,57774=>36016,57775=>21484,57776=>22063,57777=>22609,57778=>23477,57779=>23567,57780=>23569,57781=>24034,57782=>25152,57783=>25475,57784=>25620,57785=>26157,57786=>26803,57787=>27836,57788=>28040,57789=>28335,57790=>28703,57791=>28836,57792=>29138,57793=>29990,57794=>30095,57795=>30094,57796=>30233,57797=>31505,57798=>31712,57799=>31787,57800=>32032,57801=>32057,57802=>34092,57803=>34157,57804=>34311,57805=>35380,57806=>36877,57807=>36961,57808=>37045,57809=>37559,57810=>38902,57811=>39479,57812=>20439,57813=>23660,57814=>26463,57815=>28049,57816=>31903,57817=>32396,57818=>35606,57819=>36118,57820=>36895,57821=>23403,57822=>24061,57823=>25613,57824=>33984,57825=>36956,57826=>39137,57827=>29575,57828=>23435,57829=>24730,57830=>26494,57831=>28126,57832=>35359,57833=>35494,57834=>36865,57835=>38924,57836=>21047,57837=>63856,57838=>28753,57839=>30862,57840=>37782,57841=>34928,57842=>37335,57843=>20462,57844=>21463,57845=>22013,57846=>22234,57847=>22402,57848=>22781,57849=>23234,57850=>23432,57851=>23723,57852=>23744,57853=>24101,57854=>24833,58017=>25101,58018=>25163,58019=>25480,58020=>25628,58021=>25910,58022=>25976,58023=>27193,58024=>27530,58025=>27700,58026=>27929,58027=>28465,58028=>29159,58029=>29417,58030=>29560,58031=>29703,58032=>29874,58033=>30246,58034=>30561,58035=>31168,58036=>31319,58037=>31466,58038=>31929,58039=>32143,58040=>32172,58041=>32353,58042=>32670,58043=>33065,58044=>33585,58045=>33936,58046=>34010,58047=>34282,58048=>34966,58049=>35504,58050=>35728,58051=>36664,58052=>36930,58053=>36995,58054=>37228,58055=>37526,58056=>37561,58057=>38539,58058=>38567,58059=>38568,58060=>38614,58061=>38656,58062=>38920,58063=>39318,58064=>39635,58065=>39706,58066=>21460,58067=>22654,58068=>22809,58069=>23408,58070=>23487,58071=>28113,58072=>28506,58073=>29087,58074=>29729,58075=>29881,58076=>32901,58077=>33789,58078=>24033,58079=>24455,58080=>24490,58081=>24642,58082=>26092,58083=>26642,58084=>26991,58085=>27219,58086=>27529,58087=>27957,58088=>28147,58089=>29667,58090=>30462,58091=>30636,58092=>31565,58093=>32020,58094=>33059,58095=>33308,58096=>33600,58097=>34036,58098=>34147,58099=>35426,58100=>35524,58101=>37255,58102=>37662,58103=>38918,58104=>39348,58105=>25100,58106=>34899,58107=>36848,58108=>37477,58109=>23815,58110=>23847,58273=>23913,58274=>29791,58275=>33181,58276=>34664,58277=>28629,58278=>25342,58279=>32722,58280=>35126,58281=>35186,58282=>19998,58283=>20056,58284=>20711,58285=>21213,58286=>21319,58287=>25215,58288=>26119,58289=>32361,58290=>34821,58291=>38494,58292=>20365,58293=>21273,58294=>22070,58295=>22987,58296=>23204,58297=>23608,58298=>23630,58299=>23629,58300=>24066,58301=>24337,58302=>24643,58303=>26045,58304=>26159,58305=>26178,58306=>26558,58307=>26612,58308=>29468,58309=>30690,58310=>31034,58311=>32709,58312=>33940,58313=>33997,58314=>35222,58315=>35430,58316=>35433,58317=>35553,58318=>35925,58319=>35962,58320=>22516,58321=>23508,58322=>24335,58323=>24687,58324=>25325,58325=>26893,58326=>27542,58327=>28252,58328=>29060,58329=>31698,58330=>34645,58331=>35672,58332=>36606,58333=>39135,58334=>39166,58335=>20280,58336=>20353,58337=>20449,58338=>21627,58339=>23072,58340=>23480,58341=>24892,58342=>26032,58343=>26216,58344=>29180,58345=>30003,58346=>31070,58347=>32051,58348=>33102,58349=>33251,58350=>33688,58351=>34218,58352=>34254,58353=>34563,58354=>35338,58355=>36523,58356=>36763,58357=>63857,58358=>36805,58359=>22833,58360=>23460,58361=>23526,58362=>24713,58363=>23529,58364=>23563,58365=>24515,58366=>27777,58529=>63858,58530=>28145,58531=>28683,58532=>29978,58533=>33455,58534=>35574,58535=>20160,58536=>21313,58537=>63859,58538=>38617,58539=>27663,58540=>20126,58541=>20420,58542=>20818,58543=>21854,58544=>23077,58545=>23784,58546=>25105,58547=>29273,58548=>33469,58549=>33706,58550=>34558,58551=>34905,58552=>35357,58553=>38463,58554=>38597,58555=>39187,58556=>40201,58557=>40285,58558=>22538,58559=>23731,58560=>23997,58561=>24132,58562=>24801,58563=>24853,58564=>25569,58565=>27138,58566=>28197,58567=>37122,58568=>37716,58569=>38990,58570=>39952,58571=>40823,58572=>23433,58573=>23736,58574=>25353,58575=>26191,58576=>26696,58577=>30524,58578=>38593,58579=>38797,58580=>38996,58581=>39839,58582=>26017,58583=>35585,58584=>36555,58585=>38332,58586=>21813,58587=>23721,58588=>24022,58589=>24245,58590=>26263,58591=>30284,58592=>33780,58593=>38343,58594=>22739,58595=>25276,58596=>29390,58597=>40232,58598=>20208,58599=>22830,58600=>24591,58601=>26171,58602=>27523,58603=>31207,58604=>40230,58605=>21395,58606=>21696,58607=>22467,58608=>23830,58609=>24859,58610=>26326,58611=>28079,58612=>30861,58613=>33406,58614=>38552,58615=>38724,58616=>21380,58617=>25212,58618=>25494,58619=>28082,58620=>32266,58621=>33099,58622=>38989,58785=>27387,58786=>32588,58787=>40367,58788=>40474,58789=>20063,58790=>20539,58791=>20918,58792=>22812,58793=>24825,58794=>25590,58795=>26928,58796=>29242,58797=>32822,58798=>63860,58799=>37326,58800=>24369,58801=>63861,58802=>63862,58803=>32004,58804=>33509,58805=>33903,58806=>33979,58807=>34277,58808=>36493,58809=>63863,58810=>20335,58811=>63864,58812=>63865,58813=>22756,58814=>23363,58815=>24665,58816=>25562,58817=>25880,58818=>25965,58819=>26264,58820=>63866,58821=>26954,58822=>27171,58823=>27915,58824=>28673,58825=>29036,58826=>30162,58827=>30221,58828=>31155,58829=>31344,58830=>63867,58831=>32650,58832=>63868,58833=>35140,58834=>63869,58835=>35731,58836=>37312,58837=>38525,58838=>63870,58839=>39178,58840=>22276,58841=>24481,58842=>26044,58843=>28417,58844=>30208,58845=>31142,58846=>35486,58847=>39341,58848=>39770,58849=>40812,58850=>20740,58851=>25014,58852=>25233,58853=>27277,58854=>33222,58855=>20547,58856=>22576,58857=>24422,58858=>28937,58859=>35328,58860=>35578,58861=>23420,58862=>34326,58863=>20474,58864=>20796,58865=>22196,58866=>22852,58867=>25513,58868=>28153,58869=>23978,58870=>26989,58871=>20870,58872=>20104,58873=>20313,58874=>63871,58875=>63872,58876=>63873,58877=>22914,58878=>63874,59041=>63875,59042=>27487,59043=>27741,59044=>63876,59045=>29877,59046=>30998,59047=>63877,59048=>33287,59049=>33349,59050=>33593,59051=>36671,59052=>36701,59053=>63878,59054=>39192,59055=>63879,59056=>63880,59057=>63881,59058=>20134,59059=>63882,59060=>22495,59061=>24441,59062=>26131,59063=>63883,59064=>63884,59065=>30123,59066=>32377,59067=>35695,59068=>63885,59069=>36870,59070=>39515,59071=>22181,59072=>22567,59073=>23032,59074=>23071,59075=>23476,59076=>63886,59077=>24310,59078=>63887,59079=>63888,59080=>25424,59081=>25403,59082=>63889,59083=>26941,59084=>27783,59085=>27839,59086=>28046,59087=>28051,59088=>28149,59089=>28436,59090=>63890,59091=>28895,59092=>28982,59093=>29017,59094=>63891,59095=>29123,59096=>29141,59097=>63892,59098=>30799,59099=>30831,59100=>63893,59101=>31605,59102=>32227,59103=>63894,59104=>32303,59105=>63895,59106=>34893,59107=>36575,59108=>63896,59109=>63897,59110=>63898,59111=>37467,59112=>63899,59113=>40182,59114=>63900,59115=>63901,59116=>63902,59117=>24709,59118=>28037,59119=>63903,59120=>29105,59121=>63904,59122=>63905,59123=>38321,59124=>21421,59125=>63906,59126=>63907,59127=>63908,59128=>26579,59129=>63909,59130=>28814,59131=>28976,59132=>29744,59133=>33398,59134=>33490,59297=>63910,59298=>38331,59299=>39653,59300=>40573,59301=>26308,59302=>63911,59303=>29121,59304=>33865,59305=>63912,59306=>63913,59307=>22603,59308=>63914,59309=>63915,59310=>23992,59311=>24433,59312=>63916,59313=>26144,59314=>26254,59315=>27001,59316=>27054,59317=>27704,59318=>27891,59319=>28214,59320=>28481,59321=>28634,59322=>28699,59323=>28719,59324=>29008,59325=>29151,59326=>29552,59327=>63917,59328=>29787,59329=>63918,59330=>29908,59331=>30408,59332=>31310,59333=>32403,59334=>63919,59335=>63920,59336=>33521,59337=>35424,59338=>36814,59339=>63921,59340=>37704,59341=>63922,59342=>38681,59343=>63923,59344=>63924,59345=>20034,59346=>20522,59347=>63925,59348=>21000,59349=>21473,59350=>26355,59351=>27757,59352=>28618,59353=>29450,59354=>30591,59355=>31330,59356=>33454,59357=>34269,59358=>34306,59359=>63926,59360=>35028,59361=>35427,59362=>35709,59363=>35947,59364=>63927,59365=>37555,59366=>63928,59367=>38675,59368=>38928,59369=>20116,59370=>20237,59371=>20425,59372=>20658,59373=>21320,59374=>21566,59375=>21555,59376=>21978,59377=>22626,59378=>22714,59379=>22887,59380=>23067,59381=>23524,59382=>24735,59383=>63929,59384=>25034,59385=>25942,59386=>26111,59387=>26212,59388=>26791,59389=>27738,59390=>28595,59553=>28879,59554=>29100,59555=>29522,59556=>31613,59557=>34568,59558=>35492,59559=>39986,59560=>40711,59561=>23627,59562=>27779,59563=>29508,59564=>29577,59565=>37434,59566=>28331,59567=>29797,59568=>30239,59569=>31337,59570=>32277,59571=>34314,59572=>20800,59573=>22725,59574=>25793,59575=>29934,59576=>29973,59577=>30320,59578=>32705,59579=>37013,59580=>38605,59581=>39252,59582=>28198,59583=>29926,59584=>31401,59585=>31402,59586=>33253,59587=>34521,59588=>34680,59589=>35355,59590=>23113,59591=>23436,59592=>23451,59593=>26785,59594=>26880,59595=>28003,59596=>29609,59597=>29715,59598=>29740,59599=>30871,59600=>32233,59601=>32747,59602=>33048,59603=>33109,59604=>33694,59605=>35916,59606=>38446,59607=>38929,59608=>26352,59609=>24448,59610=>26106,59611=>26505,59612=>27754,59613=>29579,59614=>20525,59615=>23043,59616=>27498,59617=>30702,59618=>22806,59619=>23916,59620=>24013,59621=>29477,59622=>30031,59623=>63930,59624=>63931,59625=>20709,59626=>20985,59627=>22575,59628=>22829,59629=>22934,59630=>23002,59631=>23525,59632=>63932,59633=>63933,59634=>23970,59635=>25303,59636=>25622,59637=>25747,59638=>25854,59639=>63934,59640=>26332,59641=>63935,59642=>27208,59643=>63936,59644=>29183,59645=>29796,59646=>63937,59809=>31368,59810=>31407,59811=>32327,59812=>32350,59813=>32768,59814=>33136,59815=>63938,59816=>34799,59817=>35201,59818=>35616,59819=>36953,59820=>63939,59821=>36992,59822=>39250,59823=>24958,59824=>27442,59825=>28020,59826=>32287,59827=>35109,59828=>36785,59829=>20433,59830=>20653,59831=>20887,59832=>21191,59833=>22471,59834=>22665,59835=>23481,59836=>24248,59837=>24898,59838=>27029,59839=>28044,59840=>28263,59841=>28342,59842=>29076,59843=>29794,59844=>29992,59845=>29996,59846=>32883,59847=>33592,59848=>33993,59849=>36362,59850=>37780,59851=>37854,59852=>63940,59853=>20110,59854=>20305,59855=>20598,59856=>20778,59857=>21448,59858=>21451,59859=>21491,59860=>23431,59861=>23507,59862=>23588,59863=>24858,59864=>24962,59865=>26100,59866=>29275,59867=>29591,59868=>29760,59869=>30402,59870=>31056,59871=>31121,59872=>31161,59873=>32006,59874=>32701,59875=>33419,59876=>34261,59877=>34398,59878=>36802,59879=>36935,59880=>37109,59881=>37354,59882=>38533,59883=>38632,59884=>38633,59885=>21206,59886=>24423,59887=>26093,59888=>26161,59889=>26671,59890=>29020,59891=>31286,59892=>37057,59893=>38922,59894=>20113,59895=>63941,59896=>27218,59897=>27550,59898=>28560,59899=>29065,59900=>32792,59901=>33464,59902=>34131,60065=>36939,60066=>38549,60067=>38642,60068=>38907,60069=>34074,60070=>39729,60071=>20112,60072=>29066,60073=>38596,60074=>20803,60075=>21407,60076=>21729,60077=>22291,60078=>22290,60079=>22435,60080=>23195,60081=>23236,60082=>23491,60083=>24616,60084=>24895,60085=>25588,60086=>27781,60087=>27961,60088=>28274,60089=>28304,60090=>29232,60091=>29503,60092=>29783,60093=>33489,60094=>34945,60095=>36677,60096=>36960,60097=>63942,60098=>38498,60099=>39000,60100=>40219,60101=>26376,60102=>36234,60103=>37470,60104=>20301,60105=>20553,60106=>20702,60107=>21361,60108=>22285,60109=>22996,60110=>23041,60111=>23561,60112=>24944,60113=>26256,60114=>28205,60115=>29234,60116=>29771,60117=>32239,60118=>32963,60119=>33806,60120=>33894,60121=>34111,60122=>34655,60123=>34907,60124=>35096,60125=>35586,60126=>36949,60127=>38859,60128=>39759,60129=>20083,60130=>20369,60131=>20754,60132=>20842,60133=>63943,60134=>21807,60135=>21929,60136=>23418,60137=>23461,60138=>24188,60139=>24189,60140=>24254,60141=>24736,60142=>24799,60143=>24840,60144=>24841,60145=>25540,60146=>25912,60147=>26377,60148=>63944,60149=>26580,60150=>26586,60151=>63945,60152=>26977,60153=>26978,60154=>27833,60155=>27943,60156=>63946,60157=>28216,60158=>63947,60321=>28641,60322=>29494,60323=>29495,60324=>63948,60325=>29788,60326=>30001,60327=>63949,60328=>30290,60329=>63950,60330=>63951,60331=>32173,60332=>33278,60333=>33848,60334=>35029,60335=>35480,60336=>35547,60337=>35565,60338=>36400,60339=>36418,60340=>36938,60341=>36926,60342=>36986,60343=>37193,60344=>37321,60345=>37742,60346=>63952,60347=>63953,60348=>22537,60349=>63954,60350=>27603,60351=>32905,60352=>32946,60353=>63955,60354=>63956,60355=>20801,60356=>22891,60357=>23609,60358=>63957,60359=>63958,60360=>28516,60361=>29607,60362=>32996,60363=>36103,60364=>63959,60365=>37399,60366=>38287,60367=>63960,60368=>63961,60369=>63962,60370=>63963,60371=>32895,60372=>25102,60373=>28700,60374=>32104,60375=>34701,60376=>63964,60377=>22432,60378=>24681,60379=>24903,60380=>27575,60381=>35518,60382=>37504,60383=>38577,60384=>20057,60385=>21535,60386=>28139,60387=>34093,60388=>38512,60389=>38899,60390=>39150,60391=>25558,60392=>27875,60393=>37009,60394=>20957,60395=>25033,60396=>33210,60397=>40441,60398=>20381,60399=>20506,60400=>20736,60401=>23452,60402=>24847,60403=>25087,60404=>25836,60405=>26885,60406=>27589,60407=>30097,60408=>30691,60409=>32681,60410=>33380,60411=>34191,60412=>34811,60413=>34915,60414=>35516,60577=>35696,60578=>37291,60579=>20108,60580=>20197,60581=>20234,60582=>63965,60583=>63966,60584=>22839,60585=>23016,60586=>63967,60587=>24050,60588=>24347,60589=>24411,60590=>24609,60591=>63968,60592=>63969,60593=>63970,60594=>63971,60595=>29246,60596=>29669,60597=>63972,60598=>30064,60599=>30157,60600=>63973,60601=>31227,60602=>63974,60603=>32780,60604=>32819,60605=>32900,60606=>33505,60607=>33617,60608=>63975,60609=>63976,60610=>36029,60611=>36019,60612=>36999,60613=>63977,60614=>63978,60615=>39156,60616=>39180,60617=>63979,60618=>63980,60619=>28727,60620=>30410,60621=>32714,60622=>32716,60623=>32764,60624=>35610,60625=>20154,60626=>20161,60627=>20995,60628=>21360,60629=>63981,60630=>21693,60631=>22240,60632=>23035,60633=>23493,60634=>24341,60635=>24525,60636=>28270,60637=>63982,60638=>63983,60639=>32106,60640=>33589,60641=>63984,60642=>34451,60643=>35469,60644=>63985,60645=>38765,60646=>38775,60647=>63986,60648=>63987,60649=>19968,60650=>20314,60651=>20350,60652=>22777,60653=>26085,60654=>28322,60655=>36920,60656=>37808,60657=>39353,60658=>20219,60659=>22764,60660=>22922,60661=>23001,60662=>24641,60663=>63988,60664=>63989,60665=>31252,60666=>63990,60667=>33615,60668=>36035,60669=>20837,60670=>21316,60833=>63991,60834=>63992,60835=>63993,60836=>20173,60837=>21097,60838=>23381,60839=>33471,60840=>20180,60841=>21050,60842=>21672,60843=>22985,60844=>23039,60845=>23376,60846=>23383,60847=>23388,60848=>24675,60849=>24904,60850=>28363,60851=>28825,60852=>29038,60853=>29574,60854=>29943,60855=>30133,60856=>30913,60857=>32043,60858=>32773,60859=>33258,60860=>33576,60861=>34071,60862=>34249,60863=>35566,60864=>36039,60865=>38604,60866=>20316,60867=>21242,60868=>22204,60869=>26027,60870=>26152,60871=>28796,60872=>28856,60873=>29237,60874=>32189,60875=>33421,60876=>37196,60877=>38592,60878=>40306,60879=>23409,60880=>26855,60881=>27544,60882=>28538,60883=>30430,60884=>23697,60885=>26283,60886=>28507,60887=>31668,60888=>31786,60889=>34870,60890=>38620,60891=>19976,60892=>20183,60893=>21280,60894=>22580,60895=>22715,60896=>22767,60897=>22892,60898=>23559,60899=>24115,60900=>24196,60901=>24373,60902=>25484,60903=>26290,60904=>26454,60905=>27167,60906=>27299,60907=>27404,60908=>28479,60909=>29254,60910=>63994,60911=>29520,60912=>29835,60913=>31456,60914=>31911,60915=>33144,60916=>33247,60917=>33255,60918=>33674,60919=>33900,60920=>34083,60921=>34196,60922=>34255,60923=>35037,60924=>36115,60925=>37292,60926=>38263,61089=>38556,61090=>20877,61091=>21705,61092=>22312,61093=>23472,61094=>25165,61095=>26448,61096=>26685,61097=>26771,61098=>28221,61099=>28371,61100=>28797,61101=>32289,61102=>35009,61103=>36001,61104=>36617,61105=>40779,61106=>40782,61107=>29229,61108=>31631,61109=>35533,61110=>37658,61111=>20295,61112=>20302,61113=>20786,61114=>21632,61115=>22992,61116=>24213,61117=>25269,61118=>26485,61119=>26990,61120=>27159,61121=>27822,61122=>28186,61123=>29401,61124=>29482,61125=>30141,61126=>31672,61127=>32053,61128=>33511,61129=>33785,61130=>33879,61131=>34295,61132=>35419,61133=>36015,61134=>36487,61135=>36889,61136=>37048,61137=>38606,61138=>40799,61139=>21219,61140=>21514,61141=>23265,61142=>23490,61143=>25688,61144=>25973,61145=>28404,61146=>29380,61147=>63995,61148=>30340,61149=>31309,61150=>31515,61151=>31821,61152=>32318,61153=>32735,61154=>33659,61155=>35627,61156=>36042,61157=>36196,61158=>36321,61159=>36447,61160=>36842,61161=>36857,61162=>36969,61163=>37841,61164=>20291,61165=>20346,61166=>20659,61167=>20840,61168=>20856,61169=>21069,61170=>21098,61171=>22625,61172=>22652,61173=>22880,61174=>23560,61175=>23637,61176=>24283,61177=>24731,61178=>25136,61179=>26643,61180=>27583,61181=>27656,61182=>28593,61345=>29006,61346=>29728,61347=>30000,61348=>30008,61349=>30033,61350=>30322,61351=>31564,61352=>31627,61353=>31661,61354=>31686,61355=>32399,61356=>35438,61357=>36670,61358=>36681,61359=>37439,61360=>37523,61361=>37666,61362=>37931,61363=>38651,61364=>39002,61365=>39019,61366=>39198,61367=>20999,61368=>25130,61369=>25240,61370=>27993,61371=>30308,61372=>31434,61373=>31680,61374=>32118,61375=>21344,61376=>23742,61377=>24215,61378=>28472,61379=>28857,61380=>31896,61381=>38673,61382=>39822,61383=>40670,61384=>25509,61385=>25722,61386=>34678,61387=>19969,61388=>20117,61389=>20141,61390=>20572,61391=>20597,61392=>21576,61393=>22979,61394=>23450,61395=>24128,61396=>24237,61397=>24311,61398=>24449,61399=>24773,61400=>25402,61401=>25919,61402=>25972,61403=>26060,61404=>26230,61405=>26232,61406=>26622,61407=>26984,61408=>27273,61409=>27491,61410=>27712,61411=>28096,61412=>28136,61413=>28191,61414=>28254,61415=>28702,61416=>28833,61417=>29582,61418=>29693,61419=>30010,61420=>30555,61421=>30855,61422=>31118,61423=>31243,61424=>31357,61425=>31934,61426=>32142,61427=>33351,61428=>35330,61429=>35562,61430=>35998,61431=>37165,61432=>37194,61433=>37336,61434=>37478,61435=>37580,61436=>37664,61437=>38662,61438=>38742,61601=>38748,61602=>38914,61603=>40718,61604=>21046,61605=>21137,61606=>21884,61607=>22564,61608=>24093,61609=>24351,61610=>24716,61611=>25552,61612=>26799,61613=>28639,61614=>31085,61615=>31532,61616=>33229,61617=>34234,61618=>35069,61619=>35576,61620=>36420,61621=>37261,61622=>38500,61623=>38555,61624=>38717,61625=>38988,61626=>40778,61627=>20430,61628=>20806,61629=>20939,61630=>21161,61631=>22066,61632=>24340,61633=>24427,61634=>25514,61635=>25805,61636=>26089,61637=>26177,61638=>26362,61639=>26361,61640=>26397,61641=>26781,61642=>26839,61643=>27133,61644=>28437,61645=>28526,61646=>29031,61647=>29157,61648=>29226,61649=>29866,61650=>30522,61651=>31062,61652=>31066,61653=>31199,61654=>31264,61655=>31381,61656=>31895,61657=>31967,61658=>32068,61659=>32368,61660=>32903,61661=>34299,61662=>34468,61663=>35412,61664=>35519,61665=>36249,61666=>36481,61667=>36896,61668=>36973,61669=>37347,61670=>38459,61671=>38613,61672=>40165,61673=>26063,61674=>31751,61675=>36275,61676=>37827,61677=>23384,61678=>23562,61679=>21330,61680=>25305,61681=>29469,61682=>20519,61683=>23447,61684=>24478,61685=>24752,61686=>24939,61687=>26837,61688=>28121,61689=>29742,61690=>31278,61691=>32066,61692=>32156,61693=>32305,61694=>33131,61857=>36394,61858=>36405,61859=>37758,61860=>37912,61861=>20304,61862=>22352,61863=>24038,61864=>24231,61865=>25387,61866=>32618,61867=>20027,61868=>20303,61869=>20367,61870=>20570,61871=>23005,61872=>32964,61873=>21610,61874=>21608,61875=>22014,61876=>22863,61877=>23449,61878=>24030,61879=>24282,61880=>26205,61881=>26417,61882=>26609,61883=>26666,61884=>27880,61885=>27954,61886=>28234,61887=>28557,61888=>28855,61889=>29664,61890=>30087,61891=>31820,61892=>32002,61893=>32044,61894=>32162,61895=>33311,61896=>34523,61897=>35387,61898=>35461,61899=>36208,61900=>36490,61901=>36659,61902=>36913,61903=>37198,61904=>37202,61905=>37956,61906=>39376,61907=>31481,61908=>31909,61909=>20426,61910=>20737,61911=>20934,61912=>22472,61913=>23535,61914=>23803,61915=>26201,61916=>27197,61917=>27994,61918=>28310,61919=>28652,61920=>28940,61921=>30063,61922=>31459,61923=>34850,61924=>36897,61925=>36981,61926=>38603,61927=>39423,61928=>33537,61929=>20013,61930=>20210,61931=>34886,61932=>37325,61933=>21373,61934=>27355,61935=>26987,61936=>27713,61937=>33914,61938=>22686,61939=>24974,61940=>26366,61941=>25327,61942=>28893,61943=>29969,61944=>30151,61945=>32338,61946=>33976,61947=>35657,61948=>36104,61949=>20043,61950=>21482,62113=>21675,62114=>22320,62115=>22336,62116=>24535,62117=>25345,62118=>25351,62119=>25711,62120=>25903,62121=>26088,62122=>26234,62123=>26525,62124=>26547,62125=>27490,62126=>27744,62127=>27802,62128=>28460,62129=>30693,62130=>30757,62131=>31049,62132=>31063,62133=>32025,62134=>32930,62135=>33026,62136=>33267,62137=>33437,62138=>33463,62139=>34584,62140=>35468,62141=>63996,62142=>36100,62143=>36286,62144=>36978,62145=>30452,62146=>31257,62147=>31287,62148=>32340,62149=>32887,62150=>21767,62151=>21972,62152=>22645,62153=>25391,62154=>25634,62155=>26185,62156=>26187,62157=>26733,62158=>27035,62159=>27524,62160=>27941,62161=>28337,62162=>29645,62163=>29800,62164=>29857,62165=>30043,62166=>30137,62167=>30433,62168=>30494,62169=>30603,62170=>31206,62171=>32265,62172=>32285,62173=>33275,62174=>34095,62175=>34967,62176=>35386,62177=>36049,62178=>36587,62179=>36784,62180=>36914,62181=>37805,62182=>38499,62183=>38515,62184=>38663,62185=>20356,62186=>21489,62187=>23018,62188=>23241,62189=>24089,62190=>26702,62191=>29894,62192=>30142,62193=>31209,62194=>31378,62195=>33187,62196=>34541,62197=>36074,62198=>36300,62199=>36845,62200=>26015,62201=>26389,62202=>63997,62203=>22519,62204=>28503,62205=>32221,62206=>36655,62369=>37878,62370=>38598,62371=>24501,62372=>25074,62373=>28548,62374=>19988,62375=>20376,62376=>20511,62377=>21449,62378=>21983,62379=>23919,62380=>24046,62381=>27425,62382=>27492,62383=>30923,62384=>31642,62385=>63998,62386=>36425,62387=>36554,62388=>36974,62389=>25417,62390=>25662,62391=>30528,62392=>31364,62393=>37679,62394=>38015,62395=>40810,62396=>25776,62397=>28591,62398=>29158,62399=>29864,62400=>29914,62401=>31428,62402=>31762,62403=>32386,62404=>31922,62405=>32408,62406=>35738,62407=>36106,62408=>38013,62409=>39184,62410=>39244,62411=>21049,62412=>23519,62413=>25830,62414=>26413,62415=>32046,62416=>20717,62417=>21443,62418=>22649,62419=>24920,62420=>24921,62421=>25082,62422=>26028,62423=>31449,62424=>35730,62425=>35734,62426=>20489,62427=>20513,62428=>21109,62429=>21809,62430=>23100,62431=>24288,62432=>24432,62433=>24884,62434=>25950,62435=>26124,62436=>26166,62437=>26274,62438=>27085,62439=>28356,62440=>28466,62441=>29462,62442=>30241,62443=>31379,62444=>33081,62445=>33369,62446=>33750,62447=>33980,62448=>20661,62449=>22512,62450=>23488,62451=>23528,62452=>24425,62453=>25505,62454=>30758,62455=>32181,62456=>33756,62457=>34081,62458=>37319,62459=>37365,62460=>20874,62461=>26613,62462=>31574,62625=>36012,62626=>20932,62627=>22971,62628=>24765,62629=>34389,62630=>20508,62631=>63999,62632=>21076,62633=>23610,62634=>24957,62635=>25114,62636=>25299,62637=>25842,62638=>26021,62639=>28364,62640=>30240,62641=>33034,62642=>36448,62643=>38495,62644=>38587,62645=>20191,62646=>21315,62647=>21912,62648=>22825,62649=>24029,62650=>25797,62651=>27849,62652=>28154,62653=>29588,62654=>31359,62655=>33307,62656=>34214,62657=>36068,62658=>36368,62659=>36983,62660=>37351,62661=>38369,62662=>38433,62663=>38854,62664=>20984,62665=>21746,62666=>21894,62667=>24505,62668=>25764,62669=>28552,62670=>32180,62671=>36639,62672=>36685,62673=>37941,62674=>20681,62675=>23574,62676=>27838,62677=>28155,62678=>29979,62679=>30651,62680=>31805,62681=>31844,62682=>35449,62683=>35522,62684=>22558,62685=>22974,62686=>24086,62687=>25463,62688=>29266,62689=>30090,62690=>30571,62691=>35548,62692=>36028,62693=>36626,62694=>24307,62695=>26228,62696=>28152,62697=>32893,62698=>33729,62699=>35531,62700=>38737,62701=>39894,62702=>64000,62703=>21059,62704=>26367,62705=>28053,62706=>28399,62707=>32224,62708=>35558,62709=>36910,62710=>36958,62711=>39636,62712=>21021,62713=>21119,62714=>21736,62715=>24980,62716=>25220,62717=>25307,62718=>26786,62881=>26898,62882=>26970,62883=>27189,62884=>28818,62885=>28966,62886=>30813,62887=>30977,62888=>30990,62889=>31186,62890=>31245,62891=>32918,62892=>33400,62893=>33493,62894=>33609,62895=>34121,62896=>35970,62897=>36229,62898=>37218,62899=>37259,62900=>37294,62901=>20419,62902=>22225,62903=>29165,62904=>30679,62905=>34560,62906=>35320,62907=>23544,62908=>24534,62909=>26449,62910=>37032,62911=>21474,62912=>22618,62913=>23541,62914=>24740,62915=>24961,62916=>25696,62917=>32317,62918=>32880,62919=>34085,62920=>37507,62921=>25774,62922=>20652,62923=>23828,62924=>26368,62925=>22684,62926=>25277,62927=>25512,62928=>26894,62929=>27000,62930=>27166,62931=>28267,62932=>30394,62933=>31179,62934=>33467,62935=>33833,62936=>35535,62937=>36264,62938=>36861,62939=>37138,62940=>37195,62941=>37276,62942=>37648,62943=>37656,62944=>37786,62945=>38619,62946=>39478,62947=>39949,62948=>19985,62949=>30044,62950=>31069,62951=>31482,62952=>31569,62953=>31689,62954=>32302,62955=>33988,62956=>36441,62957=>36468,62958=>36600,62959=>36880,62960=>26149,62961=>26943,62962=>29763,62963=>20986,62964=>26414,62965=>40668,62966=>20805,62967=>24544,62968=>27798,62969=>34802,62970=>34909,62971=>34935,62972=>24756,62973=>33205,62974=>33795,63137=>36101,63138=>21462,63139=>21561,63140=>22068,63141=>23094,63142=>23601,63143=>28810,63144=>32736,63145=>32858,63146=>33030,63147=>33261,63148=>36259,63149=>37257,63150=>39519,63151=>40434,63152=>20596,63153=>20164,63154=>21408,63155=>24827,63156=>28204,63157=>23652,63158=>20360,63159=>20516,63160=>21988,63161=>23769,63162=>24159,63163=>24677,63164=>26772,63165=>27835,63166=>28100,63167=>29118,63168=>30164,63169=>30196,63170=>30305,63171=>31258,63172=>31305,63173=>32199,63174=>32251,63175=>32622,63176=>33268,63177=>34473,63178=>36636,63179=>38601,63180=>39347,63181=>40786,63182=>21063,63183=>21189,63184=>39149,63185=>35242,63186=>19971,63187=>26578,63188=>28422,63189=>20405,63190=>23522,63191=>26517,63192=>27784,63193=>28024,63194=>29723,63195=>30759,63196=>37341,63197=>37756,63198=>34756,63199=>31204,63200=>31281,63201=>24555,63202=>20182,63203=>21668,63204=>21822,63205=>22702,63206=>22949,63207=>24816,63208=>25171,63209=>25302,63210=>26422,63211=>26965,63212=>33333,63213=>38464,63214=>39345,63215=>39389,63216=>20524,63217=>21331,63218=>21828,63219=>22396,63220=>64001,63221=>25176,63222=>64002,63223=>25826,63224=>26219,63225=>26589,63226=>28609,63227=>28655,63228=>29730,63229=>29752,63230=>35351,63393=>37944,63394=>21585,63395=>22022,63396=>22374,63397=>24392,63398=>24986,63399=>27470,63400=>28760,63401=>28845,63402=>32187,63403=>35477,63404=>22890,63405=>33067,63406=>25506,63407=>30472,63408=>32829,63409=>36010,63410=>22612,63411=>25645,63412=>27067,63413=>23445,63414=>24081,63415=>28271,63416=>64003,63417=>34153,63418=>20812,63419=>21488,63420=>22826,63421=>24608,63422=>24907,63423=>27526,63424=>27760,63425=>27888,63426=>31518,63427=>32974,63428=>33492,63429=>36294,63430=>37040,63431=>39089,63432=>64004,63433=>25799,63434=>28580,63435=>25745,63436=>25860,63437=>20814,63438=>21520,63439=>22303,63440=>35342,63441=>24927,63442=>26742,63443=>64005,63444=>30171,63445=>31570,63446=>32113,63447=>36890,63448=>22534,63449=>27084,63450=>33151,63451=>35114,63452=>36864,63453=>38969,63454=>20600,63455=>22871,63456=>22956,63457=>25237,63458=>36879,63459=>39722,63460=>24925,63461=>29305,63462=>38358,63463=>22369,63464=>23110,63465=>24052,63466=>25226,63467=>25773,63468=>25850,63469=>26487,63470=>27874,63471=>27966,63472=>29228,63473=>29750,63474=>30772,63475=>32631,63476=>33453,63477=>36315,63478=>38935,63479=>21028,63480=>22338,63481=>26495,63482=>29256,63483=>29923,63484=>36009,63485=>36774,63486=>37393,63649=>38442,63650=>20843,63651=>21485,63652=>25420,63653=>20329,63654=>21764,63655=>24726,63656=>25943,63657=>27803,63658=>28031,63659=>29260,63660=>29437,63661=>31255,63662=>35207,63663=>35997,63664=>24429,63665=>28558,63666=>28921,63667=>33192,63668=>24846,63669=>20415,63670=>20559,63671=>25153,63672=>29255,63673=>31687,63674=>32232,63675=>32745,63676=>36941,63677=>38829,63678=>39449,63679=>36022,63680=>22378,63681=>24179,63682=>26544,63683=>33805,63684=>35413,63685=>21536,63686=>23318,63687=>24163,63688=>24290,63689=>24330,63690=>25987,63691=>32954,63692=>34109,63693=>38281,63694=>38491,63695=>20296,63696=>21253,63697=>21261,63698=>21263,63699=>21638,63700=>21754,63701=>22275,63702=>24067,63703=>24598,63704=>25243,63705=>25265,63706=>25429,63707=>64006,63708=>27873,63709=>28006,63710=>30129,63711=>30770,63712=>32990,63713=>33071,63714=>33502,63715=>33889,63716=>33970,63717=>34957,63718=>35090,63719=>36875,63720=>37610,63721=>39165,63722=>39825,63723=>24133,63724=>26292,63725=>26333,63726=>28689,63727=>29190,63728=>64007,63729=>20469,63730=>21117,63731=>24426,63732=>24915,63733=>26451,63734=>27161,63735=>28418,63736=>29922,63737=>31080,63738=>34920,63739=>35961,63740=>39111,63741=>39108,63742=>39491,63905=>21697,63906=>31263,63907=>26963,63908=>35575,63909=>35914,63910=>39080,63911=>39342,63912=>24444,63913=>25259,63914=>30130,63915=>30382,63916=>34987,63917=>36991,63918=>38466,63919=>21305,63920=>24380,63921=>24517,63922=>27852,63923=>29644,63924=>30050,63925=>30091,63926=>31558,63927=>33534,63928=>39325,63929=>20047,63930=>36924,63931=>19979,63932=>20309,63933=>21414,63934=>22799,63935=>24264,63936=>26160,63937=>27827,63938=>29781,63939=>33655,63940=>34662,63941=>36032,63942=>36944,63943=>38686,63944=>39957,63945=>22737,63946=>23416,63947=>34384,63948=>35604,63949=>40372,63950=>23506,63951=>24680,63952=>24717,63953=>26097,63954=>27735,63955=>28450,63956=>28579,63957=>28698,63958=>32597,63959=>32752,63960=>38289,63961=>38290,63962=>38480,63963=>38867,63964=>21106,63965=>36676,63966=>20989,63967=>21547,63968=>21688,63969=>21859,63970=>21898,63971=>27323,63972=>28085,63973=>32216,63974=>33382,63975=>37532,63976=>38519,63977=>40569,63978=>21512,63979=>21704,63980=>30418,63981=>34532,63982=>38308,63983=>38356,63984=>38492,63985=>20130,63986=>20233,63987=>23022,63988=>23270,63989=>24055,63990=>24658,63991=>25239,63992=>26477,63993=>26689,63994=>27782,63995=>28207,63996=>32568,63997=>32923,63998=>33322,64161=>64008,64162=>64009,64163=>38917,64164=>20133,64165=>20565,64166=>21683,64167=>22419,64168=>22874,64169=>23401,64170=>23475,64171=>25032,64172=>26999,64173=>28023,64174=>28707,64175=>34809,64176=>35299,64177=>35442,64178=>35559,64179=>36994,64180=>39405,64181=>39608,64182=>21182,64183=>26680,64184=>20502,64185=>24184,64186=>26447,64187=>33607,64188=>34892,64189=>20139,64190=>21521,64191=>22190,64192=>29670,64193=>37141,64194=>38911,64195=>39177,64196=>39255,64197=>39321,64198=>22099,64199=>22687,64200=>34395,64201=>35377,64202=>25010,64203=>27382,64204=>29563,64205=>36562,64206=>27463,64207=>38570,64208=>39511,64209=>22869,64210=>29184,64211=>36203,64212=>38761,64213=>20436,64214=>23796,64215=>24358,64216=>25080,64217=>26203,64218=>27883,64219=>28843,64220=>29572,64221=>29625,64222=>29694,64223=>30505,64224=>30541,64225=>32067,64226=>32098,64227=>32291,64228=>33335,64229=>34898,64230=>64010,64231=>36066,64232=>37449,64233=>39023,64234=>23377,64235=>31348,64236=>34880,64237=>38913,64238=>23244,64239=>20448,64240=>21332,64241=>22846,64242=>23805,64243=>25406,64244=>28025,64245=>29433,64246=>33029,64247=>33031,64248=>33698,64249=>37583,64250=>38960,64251=>20136,64252=>20804,64253=>21009,64254=>22411,64417=>24418,64418=>27842,64419=>28366,64420=>28677,64421=>28752,64422=>28847,64423=>29074,64424=>29673,64425=>29801,64426=>33610,64427=>34722,64428=>34913,64429=>36872,64430=>37026,64431=>37795,64432=>39336,64433=>20846,64434=>24407,64435=>24800,64436=>24935,64437=>26291,64438=>34137,64439=>36426,64440=>37295,64441=>38795,64442=>20046,64443=>20114,64444=>21628,64445=>22741,64446=>22778,64447=>22909,64448=>23733,64449=>24359,64450=>25142,64451=>25160,64452=>26122,64453=>26215,64454=>27627,64455=>28009,64456=>28111,64457=>28246,64458=>28408,64459=>28564,64460=>28640,64461=>28649,64462=>28765,64463=>29392,64464=>29733,64465=>29786,64466=>29920,64467=>30355,64468=>31068,64469=>31946,64470=>32286,64471=>32993,64472=>33446,64473=>33899,64474=>33983,64475=>34382,64476=>34399,64477=>34676,64478=>35703,64479=>35946,64480=>37804,64481=>38912,64482=>39013,64483=>24785,64484=>25110,64485=>37239,64486=>23130,64487=>26127,64488=>28151,64489=>28222,64490=>29759,64491=>39746,64492=>24573,64493=>24794,64494=>31503,64495=>21700,64496=>24344,64497=>27742,64498=>27859,64499=>27946,64500=>28888,64501=>32005,64502=>34425,64503=>35340,64504=>40251,64505=>21270,64506=>21644,64507=>23301,64508=>27194,64509=>28779,64510=>30069,64673=>31117,64674=>31166,64675=>33457,64676=>33775,64677=>35441,64678=>35649,64679=>36008,64680=>38772,64681=>64011,64682=>25844,64683=>25899,64684=>30906,64685=>30907,64686=>31339,64687=>20024,64688=>21914,64689=>22864,64690=>23462,64691=>24187,64692=>24739,64693=>25563,64694=>27489,64695=>26213,64696=>26707,64697=>28185,64698=>29029,64699=>29872,64700=>32008,64701=>36996,64702=>39529,64703=>39973,64704=>27963,64705=>28369,64706=>29502,64707=>35905,64708=>38346,64709=>20976,64710=>24140,64711=>24488,64712=>24653,64713=>24822,64714=>24880,64715=>24908,64716=>26179,64717=>26180,64718=>27045,64719=>27841,64720=>28255,64721=>28361,64722=>28514,64723=>29004,64724=>29852,64725=>30343,64726=>31681,64727=>31783,64728=>33618,64729=>34647,64730=>36945,64731=>38541,64732=>40643,64733=>21295,64734=>22238,64735=>24315,64736=>24458,64737=>24674,64738=>24724,64739=>25079,64740=>26214,64741=>26371,64742=>27292,64743=>28142,64744=>28590,64745=>28784,64746=>29546,64747=>32362,64748=>33214,64749=>33588,64750=>34516,64751=>35496,64752=>36036,64753=>21123,64754=>29554,64755=>23446,64756=>27243,64757=>37892,64758=>21742,64759=>22150,64760=>23389,64761=>25928,64762=>25989,64763=>26313,64764=>26783,64765=>28045,64766=>28102,64929=>29243,64930=>32948,64931=>37237,64932=>39501,64933=>20399,64934=>20505,64935=>21402,64936=>21518,64937=>21564,64938=>21897,64939=>21957,64940=>24127,64941=>24460,64942=>26429,64943=>29030,64944=>29661,64945=>36869,64946=>21211,64947=>21235,64948=>22628,64949=>22734,64950=>28932,64951=>29071,64952=>29179,64953=>34224,64954=>35347,64955=>26248,64956=>34216,64957=>21927,64958=>26244,64959=>29002,64960=>33841,64961=>21321,64962=>21913,64963=>27585,64964=>24409,64965=>24509,64966=>25582,64967=>26249,64968=>28999,64969=>35569,64970=>36637,64971=>40638,64972=>20241,64973=>25658,64974=>28875,64975=>30054,64976=>34407,64977=>24676,64978=>35662,64979=>40440,64980=>20807,64981=>20982,64982=>21256,64983=>27958,64984=>33016,64985=>40657,64986=>26133,64987=>27427,64988=>28824,64989=>30165,64990=>21507,64991=>23673,64992=>32007,64993=>35350,64994=>27424,64995=>27453,64996=>27462,64997=>21560,64998=>24688,64999=>27965,65000=>32725,65001=>33288,65002=>20694,65003=>20958,65004=>21916,65005=>22123,65006=>22221,65007=>23020,65008=>23305,65009=>24076,65010=>24985,65011=>24984,65012=>25137,65013=>26206,65014=>26342,65015=>29081,65016=>29113,65017=>29114,65018=>29351,65019=>31143,65020=>31232,65021=>32690,65022=>35440);
		

	/**
	*  UTF-8 to EUC-KR mapping array.
	*
	* @access private
	* @var    array    $_fromUtfMap
	*/
	var $_fromUtfMap = null;


	// ------------------------------



	// ------ CLASS METHODS ------ //


	// ---- Public methods ---- //


	/**
	* Encodes given EUC-KR string into UFT-8
	*
	* @access public
	* @see UtfDecode
	* @param    string    $string EUC-KR string
	* @return    string    UTF-8 string data
	*/
	function _Utf8StringEncode($string)
	{
		return parent::_Utf8StringEncode($string, $this->_toUtfMap);
	
	}// -- end of &Utf8StringEncode -- //

	/**
	* Decodes given UFT-8 string into EUC-KR
	*
	* @access public
	* @see UtfEncode
	* @param    string    $string UTF-8 string
	* @return    string    EUC-KR string data
	*/
	function _Utf8StringDecode($string)
	{
		$this->_LoadInverseMap();
		return parent::_Utf8StringDecode($string, $this->_fromUtfMap);
	}// -- end of &Utf8StringDecode -- //
		
		
	// ---- Private methods ---- //
		
	/**
	* Flips $this->_toUtfMap to $this->_fromUtfMap
	*
	* @access private
	* @return	null
	*/
	function _LoadInverseMap()
	{
		static $loaded;
		if(!isset($loaded)){
			$loaded = true;
			$this->_fromUtfMap = array_flip($this->_toUtfMap);
		}
	}// -- end of _LoadInverseMap -- //
	
}

?>